/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.linking.model;

import java.util.ArrayList;
import java.util.List;
import org.glassfish.jersey.examples.linking.model.ItemModel;

public class ItemsModel {
    private List<ItemModel> items = new ArrayList<ItemModel>();
    private static ItemsModel instance;

    public static synchronized ItemsModel getInstance() {
        if (instance == null) {
            instance = new ItemsModel();
        }
        return instance;
    }

    private ItemsModel() {
        for (int i = 0; i < 100; ++i) {
            this.items.add(new ItemModel("Item " + i));
        }
    }

    public boolean hasNext(String currentId) {
        return this.getIndex(currentId) < this.items.size() - 1;
    }

    public boolean hasPrev(String currentId) {
        return this.getIndex(currentId) > 0;
    }

    public ItemModel getItem(String id) {
        return this.items.get(this.getIndex(id));
    }

    public String getNextId(String id) {
        return Integer.toString(this.getIndex(id) + 1);
    }

    public String getPrevId(String id) {
        return Integer.toString(this.getIndex(id) - 1);
    }

    private int getIndex(String id) {
        return Integer.parseInt(id);
    }

    public int getSize() {
        return this.items.size();
    }
}

