/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.configured.client;

import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.examples.configured.client.HelloWorldResource;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class App {
    private static final URI BASE_URI = URI.create("http://localhost:8080/base/");
    public static final String ROOT_PATH = "helloworld";
    static final String ENTITY_PROPERTY = "entity.value";

    public static void main(String[] args) {
        try {
            System.out.println("\"Hello World\" Jersey Example App");
            ResourceConfig resourceConfig = new ResourceConfig(new Class[]{HelloWorldResource.class});
            final HttpServer server = GrizzlyHttpServerFactory.createHttpServer((URI)BASE_URI, (ResourceConfig)resourceConfig, (boolean)false);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    server.shutdownNow();
                }
            }));
            server.start();
            WebTarget target = ClientBuilder.newClient().target(BASE_URI);
            Object entity = target.getConfiguration().getProperty(ENTITY_PROPERTY);
            Object provider = target.getConfiguration().getProperty("jersey.config.client.connector.provider");
            System.out.append("  Application started.\n").append("  Sending entity \"").append((String)entity).append("\"").append(" using ").append((String)provider).append(" connector provider").append(" to echo resource ").append(BASE_URI.toASCIIString()).println(ROOT_PATH);
            try (Response response = target.path(ROOT_PATH).request().post(Entity.entity((Object)entity, (MediaType)MediaType.TEXT_PLAIN_TYPE));){
                System.out.append("  Recieved: \"").append((CharSequence)response.readEntity(String.class)).println("\"");
            }
            server.stop();
            System.exit(0);
        }
        catch (IOException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

