/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.simple;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.util.ExtendedLogger;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.internal.ConfigHelper;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.server.spi.RequestScopedInitializer;
import org.simpleframework.http.Address;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.Status;

public final class SimpleContainer
implements org.simpleframework.http.core.Container,
Container {
    private static final ExtendedLogger logger = new ExtendedLogger(Logger.getLogger(SimpleContainer.class.getName()), Level.FINEST);
    private volatile ApplicationHandler appHandler;
    private volatile ContainerLifecycleListener containerListener;

    public void handle(final Request request, final Response response) {
        Writer responseWriter = new Writer(response);
        URI baseUri = this.getBaseUri(request);
        URI requestUri = baseUri.resolve(request.getTarget());
        try {
            ContainerRequest requestContext = new ContainerRequest(baseUri, requestUri, request.getMethod(), this.getSecurityContext(request), (PropertiesDelegate)new MapPropertiesDelegate());
            requestContext.setEntityStream(request.getInputStream());
            for (String headerName : request.getNames()) {
                requestContext.headers(headerName, new Object[]{request.getValue(headerName)});
            }
            requestContext.setWriter((ContainerResponseWriter)responseWriter);
            requestContext.setRequestScopedInitializer(new RequestScopedInitializer(){

                public void initialize(ServiceLocator locator) {
                    ((Ref)locator.getService(new TypeLiteral<Ref<Request>>(){}.getType(), new Annotation[0])).set((Object)request);
                    ((Ref)locator.getService(new TypeLiteral<Ref<Response>>(){}.getType(), new Annotation[0])).set((Object)response);
                }
            });
            this.appHandler.handle(requestContext);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.close(response);
        }
    }

    private SecurityContext getSecurityContext(final Request request) {
        return new SecurityContext(){

            public boolean isUserInRole(String role) {
                return false;
            }

            public boolean isSecure() {
                return request.isSecure();
            }

            public Principal getUserPrincipal() {
                return request.getSecuritySession().getLocalPrincipal();
            }

            public String getAuthenticationScheme() {
                return null;
            }
        };
    }

    private void close(Response response) {
        try {
            response.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private URI getBaseUri(Request request) {
        try {
            Address address = request.getAddress();
            return new URI(address.getScheme(), null, address.getDomain(), address.getPort(), "/", null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public ResourceConfig getConfiguration() {
        return this.appHandler.getConfiguration();
    }

    public void reload() {
        this.reload(this.getConfiguration());
    }

    public void reload(ResourceConfig configuration) {
        this.appHandler = new ApplicationHandler((Application)configuration.register((Object)new SimpleBinder()));
        this.containerListener.onReload((Container)this);
        this.containerListener = ConfigHelper.getContainerLifecycleListener((ApplicationHandler)this.appHandler);
    }

    void onServerStart() {
        this.containerListener.onStartup((Container)this);
    }

    void onServerStop() {
        this.containerListener.onShutdown((Container)this);
    }

    SimpleContainer(ApplicationHandler application) {
        this.appHandler = application;
        this.containerListener = ConfigHelper.getContainerLifecycleListener((ApplicationHandler)application);
        this.appHandler.registerAdditionalBinders((Iterable)new HashSet<Binder>(){
            {
                this.add(new SimpleBinder());
            }
        });
    }

    private static final class Writer
    implements ContainerResponseWriter {
        private final Response response;

        Writer(Response response) {
            this.response = response;
        }

        public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse context) throws ContainerException {
            Response.StatusType statusInfo = context.getStatusInfo();
            int code = statusInfo.getStatusCode();
            String reason = statusInfo.getReasonPhrase() == null ? Status.getDescription((int)code) : statusInfo.getReasonPhrase();
            this.response.setCode(code);
            this.response.setDescription(reason);
            this.response.setContentLength(contentLength);
            for (Map.Entry e : context.getStringHeaders().entrySet()) {
                for (String value : (List)e.getValue()) {
                    this.response.addValue((String)e.getKey(), value);
                }
            }
            try {
                return this.response.getOutputStream();
            }
            catch (IOException ioe) {
                throw new ContainerException("Error during writing out the response headers.", (Throwable)ioe);
            }
        }

        public boolean suspend(long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) {
            throw new UnsupportedOperationException("Method suspend is not supported by the container.");
        }

        public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            throw new UnsupportedOperationException("Method suspend is not supported by the container.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit() {
            try {
                this.response.close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Unable to send 500 error response.", (Throwable)e);
            }
            finally {
                logger.debugLog("commit() called", new Object[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failure(Throwable error) {
            try {
                if (!this.response.isCommitted()) {
                    this.response.setCode(500);
                    this.response.setDescription(error.getMessage());
                }
            }
            finally {
                logger.debugLog("failure(...) called", new Object[0]);
                this.commit();
                this.rethrow(error);
            }
        }

        public boolean enableResponseBuffering() {
            return false;
        }

        private void rethrow(Throwable error) {
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            throw new ContainerException(error);
        }
    }

    private static class SimpleBinder
    extends AbstractBinder {
        private SimpleBinder() {
        }

        protected void configure() {
            this.bindFactory(SimpleRequestReferencingFactory.class).to(Request.class).in(PerLookup.class);
            this.bindFactory(ReferencingFactory.referenceFactory()).to((TypeLiteral)new TypeLiteral<Ref<Request>>(){}).in(RequestScoped.class);
            this.bindFactory(SimpleResponseReferencingFactory.class).to(Response.class).in(PerLookup.class);
            this.bindFactory(ReferencingFactory.referenceFactory()).to((TypeLiteral)new TypeLiteral<Ref<Response>>(){}).in(RequestScoped.class);
        }
    }

    private static class SimpleResponseReferencingFactory
    extends ReferencingFactory<Response> {
        @Inject
        public SimpleResponseReferencingFactory(Provider<Ref<Response>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class SimpleRequestReferencingFactory
    extends ReferencingFactory<Request> {
        @Inject
        public SimpleRequestReferencingFactory(Provider<Ref<Request>> referenceFactory) {
            super(referenceFactory);
        }
    }
}

