/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationWriter;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDeclaration;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JExpressionImpl;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.TypedAnnotationWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class JEnumConstant
extends JExpressionImpl
implements JDeclaration,
JAnnotatable,
JDocCommentable {
    private final String name;
    private final JClass type;
    private JDocComment jdoc = null;
    private List<JAnnotationUse> annotations = null;
    private List<JExpression> args = null;

    JEnumConstant(JClass type, String name) {
        this.name = name;
        this.type = type;
    }

    public JEnumConstant arg(JExpression arg) {
        if (arg == null) {
            throw new IllegalArgumentException();
        }
        if (this.args == null) {
            this.args = new ArrayList<JExpression>();
        }
        this.args.add(arg);
        return this;
    }

    public String getName() {
        return this.type.fullName().concat(".").concat(this.name);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public JDocComment javadoc() {
        if (this.jdoc == null) {
            this.jdoc = new JDocComment(this.type.owner());
        }
        return this.jdoc;
    }

    @Override
    public JAnnotationUse annotate(JClass clazz) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<JAnnotationUse>();
        }
        JAnnotationUse a = new JAnnotationUse(clazz);
        this.annotations.add(a);
        return a;
    }

    @Override
    public JAnnotationUse annotate(Class<? extends Annotation> clazz) {
        return this.annotate(this.type.owner().ref(clazz));
    }

    @Override
    public <W extends JAnnotationWriter> W annotate2(Class<W> clazz) {
        return TypedAnnotationWriter.create(clazz, this);
    }

    @Override
    public boolean removeAnnotation(JAnnotationUse annotation) {
        return this.annotations.remove(annotation);
    }

    @Override
    public Collection<JAnnotationUse> annotations() {
        if (this.annotations == null) {
            this.annotations = new ArrayList<JAnnotationUse>();
        }
        return Collections.unmodifiableList(this.annotations);
    }

    @Override
    public void declare(JFormatter f) {
        if (this.jdoc != null) {
            f.nl().g(this.jdoc);
        }
        if (this.annotations != null) {
            for (int i = 0; i < this.annotations.size(); ++i) {
                f.g(this.annotations.get(i)).nl();
            }
        }
        f.id(this.name);
        if (this.args != null) {
            f.p('(').g(this.args).p(')');
        }
    }

    @Override
    public void generate(JFormatter f) {
        f.t(this.type).p('.').p(this.name);
    }

    JClass type() {
        return this.type;
    }
}

