/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.faces.application.FacesMessage;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.MessageFactory;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class RegexValidator
implements Validator,
PartialStateHolder {
    private String regex;
    public static final String VALIDATOR_ID = "javax.faces.RegularExpression";
    public static final String PATTERN_NOT_SET_MESSAGE_ID = "javax.faces.validator.RegexValidator.PATTERN_NOT_SET";
    public static final String NOT_MATCHED_MESSAGE_ID = "javax.faces.validator.RegexValidator.NOT_MATCHED";
    public static final String MATCH_EXCEPTION_MESSAGE_ID = "javax.faces.validator.RegexValidator.MATCH_EXCEPTION";
    private boolean transientValue = false;
    private boolean initialState;

    public void setPattern(String string) {
        this.clearInitialState();
        this.regex = string;
    }

    public String getPattern() {
        return this.regex;
    }

    public void validate(FacesContext facesContext, UIComponent uIComponent, Object object) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (uIComponent == null) {
            throw new NullPointerException();
        }
        if (object == null) {
            return;
        }
        Locale locale = facesContext.getViewRoot().getLocale();
        if (this.regex == null || this.regex.length() == 0) {
            FacesMessage facesMessage = MessageFactory.getMessage(locale, PATTERN_NOT_SET_MESSAGE_ID, new Object[]{null});
            throw new ValidatorException(facesMessage);
        }
        try {
            Pattern pattern = Pattern.compile(this.regex);
            Matcher matcher = pattern.matcher((String)object);
            if (!matcher.matches()) {
                Object[] objectArray = new Object[]{this.regex};
                FacesMessage facesMessage = MessageFactory.getMessage(locale, NOT_MATCHED_MESSAGE_ID, objectArray);
                throw new ValidatorException(facesMessage);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            FacesMessage facesMessage = MessageFactory.getMessage(locale, MATCH_EXCEPTION_MESSAGE_ID, new Object[]{null});
            throw new ValidatorException(facesMessage, (Throwable)patternSyntaxException);
        }
    }

    public Object saveState(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.initialStateMarked()) {
            Object[] objectArray = new Object[]{this.regex};
            return objectArray;
        }
        return null;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (object != null) {
            Object[] objectArray = (Object[])object;
            this.regex = (String)objectArray[0];
        }
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean bl) {
        this.transientValue = bl;
    }

    public void markInitialState() {
        this.initialState = true;
    }

    public boolean initialStateMarked() {
        return this.initialState;
    }

    public void clearInitialState() {
        this.initialState = false;
    }
}

