/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.validator.BeanValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class MethodExpressionValidator
implements Validator,
StateHolder {
    private static final String BEANS_VALIDATION_AVAILABLE = "javax.faces.private.BEANS_VALIDATION_AVAILABLE";
    private static final String VALIDATE_EMPTY_FIELDS_PARAM_NAME = "javax.faces.VALIDATE_EMPTY_FIELDS";
    private MethodExpression methodExpression = null;
    private Boolean validateEmptyFields;
    private boolean transientValue = false;

    public MethodExpressionValidator() {
    }

    public MethodExpressionValidator(MethodExpression methodExpression) {
        this.methodExpression = methodExpression;
    }

    public void validate(FacesContext facesContext, UIComponent uIComponent, Object object) throws ValidatorException {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        if (this.validateEmptyFields(facesContext) || object != null) {
            try {
                ELContext eLContext = facesContext.getELContext();
                this.methodExpression.invoke(eLContext, new Object[]{facesContext, uIComponent, object});
            }
            catch (ELException eLException) {
                Throwable throwable = eLException.getCause();
                if (throwable instanceof ValidatorException) {
                    throw (ValidatorException)throwable;
                }
                throw eLException;
            }
        }
    }

    public Object saveState(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        Object[] objectArray = new Object[]{this.methodExpression};
        return objectArray;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (object == null) {
            return;
        }
        Object[] objectArray = (Object[])object;
        this.methodExpression = (MethodExpression)objectArray[0];
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean bl) {
        this.transientValue = bl;
    }

    private boolean validateEmptyFields(FacesContext facesContext) {
        if (this.validateEmptyFields == null) {
            ExternalContext externalContext = facesContext.getExternalContext();
            String string = externalContext.getInitParameter(VALIDATE_EMPTY_FIELDS_PARAM_NAME);
            if (null == string) {
                string = (String)externalContext.getApplicationMap().get(VALIDATE_EMPTY_FIELDS_PARAM_NAME);
            }
            this.validateEmptyFields = string == null || "auto".equals(string) ? Boolean.valueOf(this.isBeansValidationAvailable(facesContext)) : Boolean.valueOf(string);
        }
        return this.validateEmptyFields;
    }

    private boolean isBeansValidationAvailable(FacesContext facesContext) {
        boolean bl = false;
        Map<String, Object> map = facesContext.getExternalContext().getApplicationMap();
        if (map.containsKey(BEANS_VALIDATION_AVAILABLE)) {
            bl = (Boolean)map.get(BEANS_VALIDATION_AVAILABLE);
        } else {
            try {
                new BeanValidator();
                map.put(BEANS_VALIDATION_AVAILABLE, Boolean.TRUE);
                bl = true;
            }
            catch (Throwable throwable) {
                map.put(BEANS_VALIDATION_AVAILABLE, Boolean.FALSE);
            }
        }
        return bl;
    }
}

