/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.validator.MessageFactory;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class LengthValidator
implements Validator,
PartialStateHolder {
    public static final String VALIDATOR_ID = "javax.faces.Length";
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.LengthValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.LengthValidator.MINIMUM";
    private Integer maximum;
    private Integer minimum;
    private boolean transientValue = false;
    private boolean initialState;

    public LengthValidator() {
    }

    public LengthValidator(int n) {
        this.setMaximum(n);
    }

    public LengthValidator(int n, int n2) {
        this.setMaximum(n);
        this.setMinimum(n2);
    }

    public int getMaximum() {
        return this.maximum != null ? this.maximum : 0;
    }

    public void setMaximum(int n) {
        this.clearInitialState();
        this.maximum = n;
    }

    public int getMinimum() {
        return this.minimum != null ? this.minimum : 0;
    }

    public void setMinimum(int n) {
        this.clearInitialState();
        this.minimum = n;
    }

    public void validate(FacesContext facesContext, UIComponent uIComponent, Object object) throws ValidatorException {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        if (object != null) {
            String string = LengthValidator.stringValue(object);
            if (this.isMaximumSet() && string.length() > this.maximum) {
                throw new ValidatorException(MessageFactory.getMessage(facesContext, MAXIMUM_MESSAGE_ID, LengthValidator.integerToString(uIComponent, this.maximum, facesContext), MessageFactory.getLabel(facesContext, uIComponent)));
            }
            if (this.isMinimumSet() && string.length() < this.minimum) {
                throw new ValidatorException(MessageFactory.getMessage(facesContext, MINIMUM_MESSAGE_ID, LengthValidator.integerToString(uIComponent, this.minimum, facesContext), MessageFactory.getLabel(facesContext, uIComponent)));
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof LengthValidator)) {
            return false;
        }
        LengthValidator lengthValidator = (LengthValidator)object;
        return this.getMaximum() == lengthValidator.getMaximum() && this.getMinimum() == lengthValidator.getMinimum() && this.isMinimumSet() == lengthValidator.isMinimumSet() && this.isMaximumSet() == lengthValidator.isMaximumSet();
    }

    public int hashCode() {
        int n = Integer.valueOf(this.getMinimum()).hashCode() + Integer.valueOf(this.getMaximum()).hashCode() + Boolean.valueOf(this.isMaximumSet()).hashCode() + Boolean.valueOf(this.isMinimumSet()).hashCode();
        return n;
    }

    private static String stringValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    private static String integerToString(UIComponent uIComponent, Integer n, FacesContext facesContext) {
        Converter converter = facesContext.getApplication().createConverter("javax.faces.Number");
        return converter.getAsString(facesContext, uIComponent, n);
    }

    private boolean isMaximumSet() {
        return this.maximum != null;
    }

    private boolean isMinimumSet() {
        return this.minimum != null;
    }

    public Object saveState(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.initialStateMarked()) {
            Object[] objectArray = new Object[]{this.maximum, this.minimum};
            return objectArray;
        }
        return null;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (object != null) {
            Object[] objectArray = (Object[])object;
            this.maximum = (Integer)objectArray[0];
            this.minimum = (Integer)objectArray[1];
        }
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean bl) {
        this.transientValue = bl;
    }

    public void markInitialState() {
        this.initialState = true;
    }

    public boolean initialStateMarked() {
        return this.initialState;
    }

    public void clearInitialState() {
        this.initialState = false;
    }
}

