/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import java.util.Collection;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import javax.faces.model.NoRowAvailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionDataModel<E>
extends DataModel<E> {
    private int index = -1;
    private Collection<E> inner;
    private E[] arrayFromInner;

    public CollectionDataModel() {
        this(null);
    }

    public CollectionDataModel(Collection<E> collection) {
        this.setWrappedData(collection);
    }

    @Override
    public boolean isRowAvailable() {
        if (this.arrayFromInner == null) {
            return false;
        }
        return this.index >= 0 && this.index < this.arrayFromInner.length;
    }

    @Override
    public int getRowCount() {
        if (this.arrayFromInner == null) {
            return -1;
        }
        return this.arrayFromInner.length;
    }

    @Override
    public E getRowData() {
        if (this.arrayFromInner == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new NoRowAvailableException();
        }
        return this.arrayFromInner[this.index];
    }

    @Override
    public int getRowIndex() {
        return this.index;
    }

    @Override
    public void setRowIndex(int n) {
        if (n < -1) {
            throw new IllegalArgumentException();
        }
        int n2 = this.index;
        this.index = n;
        if (this.arrayFromInner == null) {
            return;
        }
        DataModelListener[] dataModelListenerArray = this.getDataModelListeners();
        if (n2 != this.index && dataModelListenerArray != null) {
            Object var4_4 = null;
            if (this.isRowAvailable()) {
                var4_4 = this.getRowData();
            }
            DataModelEvent dataModelEvent = new DataModelEvent(this, this.index, var4_4);
            int n3 = dataModelListenerArray.length;
            for (int i = 0; i < n3; ++i) {
                if (null == dataModelListenerArray[i]) continue;
                dataModelListenerArray[i].rowSelected(dataModelEvent);
            }
        }
    }

    @Override
    public Object getWrappedData() {
        return this.inner;
    }

    @Override
    public void setWrappedData(Object object) {
        if (object == null) {
            this.inner = null;
            this.arrayFromInner = null;
            this.setRowIndex(-1);
        } else {
            this.inner = (Collection)object;
            this.arrayFromInner = new Object[this.inner.size()];
            this.inner.toArray(this.arrayFromInner);
            this.setRowIndex(0);
        }
    }
}

