/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.util.ConcurrentCache;
import com.sun.faces.util.FacesLogger;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExpiringConcurrentCache<K, V>
extends ConcurrentCache<K, V> {
    private final ExpiryChecker<K, V> _checker;
    private final ConcurrentMap<K, Future<V>> _cache = new ConcurrentHashMap<K, Future<V>>();
    private static final Logger _LOGGER = FacesLogger.UTIL.getLogger();

    public ExpiringConcurrentCache(ConcurrentCache.Factory<K, V> factory, ExpiryChecker<K, V> expiryChecker) {
        super(factory);
        this._checker = expiryChecker;
    }

    /*
     * Loose catch block
     */
    @Override
    public V get(final K k) throws ExecutionException {
        while (true) {
            Object object;
            FutureTask futureTask;
            boolean bl = false;
            FutureTask futureTask2 = (FutureTask)this._cache.get(k);
            if (futureTask2 == null && (futureTask2 = (Future)this._cache.putIfAbsent(k, futureTask = new FutureTask(object = new Callable<V>(){

                @Override
                public V call() throws Exception {
                    return ExpiringConcurrentCache.this.getFactory().newInstance(k);
                }
            }))) == null) {
                futureTask2 = futureTask;
                futureTask.run();
                bl = true;
            }
            try {
                object = futureTask2.get();
                if (!bl && this._getExpiryChecker().isExpired(k, object)) {
                    this._cache.remove(k, futureTask2);
                    continue;
                }
                return object;
            }
            catch (CancellationException cancellationException) {
                if (_LOGGER.isLoggable(Level.SEVERE)) {
                    _LOGGER.log(Level.SEVERE, cancellationException.toString(), cancellationException);
                }
                this._cache.remove(k, futureTask2);
                continue;
            }
            catch (ExecutionException executionException) {
                this._cache.remove(k, futureTask2);
                throw executionException;
            }
            break;
        }
        catch (InterruptedException interruptedException) {
            throw new FacesException(interruptedException);
        }
    }

    @Override
    public boolean containsKey(K k) {
        Future future = (Future)this._cache.get(k);
        if (future != null && future.isDone() && !future.isCancelled()) {
            try {
                Object v = future.get(0L, TimeUnit.MILLISECONDS);
                if (!this._getExpiryChecker().isExpired(k, v)) {
                    return true;
                }
                this._cache.remove(k, future);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (CancellationException cancellationException) {
                if (_LOGGER.isLoggable(Level.SEVERE)) {
                    _LOGGER.log(Level.SEVERE, cancellationException.toString(), cancellationException);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new FacesException(interruptedException);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return false;
    }

    private ExpiryChecker<K, V> _getExpiryChecker() {
        return this._checker;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ExpiryChecker<K, V> {
        public boolean isExpired(K var1, V var2);
    }
}

