/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.taglib.jsf_core;

import com.sun.faces.el.ELUtils;
import com.sun.faces.taglib.jsf_core.AbstractConverterTag;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import java.util.Arrays;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import javax.servlet.jsp.JspException;

public class ConvertDateTimeTag
extends AbstractConverterTag {
    private static final long serialVersionUID = -5815655767093677438L;
    private static ValueExpression CONVERTER_ID_EXPR = null;
    private static final Logger LOGGER = FacesLogger.TAGLIB.getLogger();
    private ValueExpression dateStyleExpression;
    private ValueExpression localeExpression;
    private ValueExpression patternExpression;
    private ValueExpression timeStyleExpression;
    private ValueExpression timeZoneExpression;
    private ValueExpression typeExpression;
    private String dateStyle;
    private Locale locale;
    private String pattern;
    private String timeStyle;
    private TimeZone timeZone;
    private String type;

    public ConvertDateTimeTag() {
        this.init();
    }

    public void release() {
        super.release();
        this.init();
    }

    private void init() {
        this.dateStyle = "default";
        this.dateStyleExpression = null;
        this.locale = null;
        this.localeExpression = null;
        this.pattern = null;
        this.patternExpression = null;
        this.timeStyle = "default";
        this.timeStyleExpression = null;
        this.timeZone = null;
        this.timeZoneExpression = null;
        this.type = "date";
        this.typeExpression = null;
        if (CONVERTER_ID_EXPR == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExpressionFactory expressionFactory = facesContext.getApplication().getExpressionFactory();
            CONVERTER_ID_EXPR = expressionFactory.createValueExpression(facesContext.getELContext(), "javax.faces.DateTime", String.class);
        }
    }

    public void setDateStyle(ValueExpression valueExpression) {
        this.dateStyleExpression = valueExpression;
    }

    public void setLocale(ValueExpression valueExpression) {
        this.localeExpression = valueExpression;
    }

    public void setPattern(ValueExpression valueExpression) {
        this.patternExpression = valueExpression;
    }

    public void setTimeStyle(ValueExpression valueExpression) {
        this.timeStyleExpression = valueExpression;
    }

    public void setTimeZone(ValueExpression valueExpression) {
        this.timeZoneExpression = valueExpression;
    }

    public void setType(ValueExpression valueExpression) {
        this.typeExpression = valueExpression;
    }

    public int doStartTag() throws JspException {
        super.setConverterId(CONVERTER_ID_EXPR);
        return super.doStartTag();
    }

    protected Converter createConverter() throws JspException {
        DateTimeConverter dateTimeConverter = (DateTimeConverter)super.createConverter();
        assert (null != dateTimeConverter);
        this.evaluateExpressions();
        dateTimeConverter.setDateStyle(this.dateStyle);
        dateTimeConverter.setLocale(this.locale);
        dateTimeConverter.setPattern(this.pattern);
        dateTimeConverter.setTimeStyle(this.timeStyle);
        dateTimeConverter.setTimeZone(this.timeZone);
        dateTimeConverter.setType(this.type);
        return dateTimeConverter;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void evaluateExpressions() {
        Object object;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext eLContext = facesContext.getELContext();
        if (this.dateStyleExpression != null) {
            this.dateStyle = (String)ELUtils.evaluateValueExpression(this.dateStyleExpression, eLContext);
        }
        if (this.patternExpression != null) {
            this.pattern = (String)ELUtils.evaluateValueExpression(this.patternExpression, eLContext);
        }
        if (this.timeStyleExpression != null) {
            this.timeStyle = (String)ELUtils.evaluateValueExpression(this.timeStyleExpression, eLContext);
        }
        this.type = this.typeExpression != null ? (String)ELUtils.evaluateValueExpression(this.typeExpression, eLContext) : (this.timeStyleExpression != null ? (this.dateStyleExpression != null ? "both" : "time") : "date");
        if (this.localeExpression != null) {
            if (this.localeExpression.isLiteralText()) {
                this.locale = ConvertDateTimeTag.getLocale(this.localeExpression.getExpressionString());
            } else {
                object = ELUtils.evaluateValueExpression(this.localeExpression, eLContext);
                if (object != null) {
                    if (object instanceof String) {
                        this.locale = ConvertDateTimeTag.getLocale((String)object);
                    } else {
                        if (!(object instanceof Locale)) {
                            Object[] objectArray = new Object[]{"locale", "java.lang.String or java.util.Locale", object.getClass().getName()};
                            if (!LOGGER.isLoggable(Level.SEVERE)) throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.EVAL_ATTR_UNEXPECTED_TYPE", objectArray));
                            LOGGER.log(Level.SEVERE, "jsf.core.tags.eval_result_not_expected_type", objectArray);
                            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.EVAL_ATTR_UNEXPECTED_TYPE", objectArray));
                        }
                        this.locale = (Locale)object;
                    }
                } else {
                    this.locale = facesContext.getViewRoot().getLocale();
                }
            }
        }
        if (this.timeZoneExpression == null) return;
        if (this.timeZoneExpression.isLiteralText()) {
            this.timeZone = TimeZone.getTimeZone(this.timeZoneExpression.getExpressionString());
            return;
        }
        object = ELUtils.evaluateValueExpression(this.timeZoneExpression, eLContext);
        if (object == null) return;
        if (object instanceof String) {
            this.timeZone = TimeZone.getTimeZone((String)object);
            return;
        }
        if (object instanceof TimeZone) {
            this.timeZone = (TimeZone)object;
            return;
        }
        Object[] objectArray = new Object[]{"timeZone", "java.lang.String or java.util.TimeZone", object.getClass().getName()};
        if (!LOGGER.isLoggable(Level.SEVERE)) throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.EVAL_ATTR_UNEXPECTED_TYPE", objectArray));
        LOGGER.log(Level.SEVERE, "jsf.core.tags.eval_result_not_expected_type", objectArray);
        throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.EVAL_ATTR_UNEXPECTED_TYPE", objectArray));
    }

    protected static Locale getLocale(String string) {
        if (string == null) {
            return Locale.getDefault();
        }
        if (string.length() > 2) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.core.taglib.invalid_locale_value", string);
            }
        } else {
            Object[] objectArray = Locale.getISOLanguages();
            Arrays.sort(objectArray);
            if (Arrays.binarySearch(objectArray, string) < 0 && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.core.taglib.invalid_language", string);
            }
        }
        return new Locale(string, "");
    }
}

