/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.scripting.groovy;

import com.sun.faces.scripting.groovy.GroovyHelper;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import groovy.util.GroovyScriptEngine;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyHelperImpl
extends GroovyHelper {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final String SCRIPT_PATH = "/WEB-INF/groovy/";
    private MojarraGroovyClassLoader loader;

    GroovyHelperImpl() throws Exception {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL[] uRLArray = this.getResourceRoots(externalContext, classLoader);
        if (0 < uRLArray.length) {
            GroovyScriptEngine groovyScriptEngine = new GroovyScriptEngine(uRLArray, classLoader);
            this.loader = new MojarraGroovyClassLoader(groovyScriptEngine);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Groovy support enabled.");
            }
            externalContext.getApplicationMap().put("com.sun.faces.groovyhelper", this);
            ((ServletContext)externalContext.getContext()).setAttribute("com.sun.faces.groovyhelper", (Object)this);
        }
    }

    private URL[] getResourceRoots(ExternalContext externalContext, ClassLoader classLoader) throws IOException {
        URL[] uRLArray;
        Enumeration<URL> enumeration = classLoader.getResources("META-INF/resources/");
        ArrayList<URL> arrayList = new ArrayList<URL>();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        URL uRL = externalContext.getResource(SCRIPT_PATH);
        URL[] uRLArray2 = this.getWebappResourceRoots(externalContext);
        URL[] uRLArray3 = new URL[arrayList.size()];
        arrayList.toArray(uRLArray3);
        if (null != uRL || 0 < uRLArray2.length || 0 < uRLArray3.length) {
            uRLArray = new URL[uRLArray2.length + uRLArray3.length + (null != uRL ? 1 : 0)];
            System.arraycopy(uRLArray2, 0, uRLArray, 0, uRLArray2.length);
            System.arraycopy(uRLArray3, 0, uRLArray, uRLArray2.length, uRLArray3.length);
            if (null != uRL) {
                uRLArray[uRLArray2.length + uRLArray3.length] = uRL;
            }
        } else {
            uRLArray = new URL[]{};
        }
        return uRLArray;
    }

    private URL[] getWebappResourceRoots(ExternalContext externalContext) {
        URL[] uRLArray = null;
        int n = 0;
        int n2 = 0;
        Set<String> set = externalContext.getResourcePaths("/resources/");
        if (null != set && !set.isEmpty()) {
            for (String string : set) {
                if (!string.endsWith("/")) continue;
                ++n;
            }
            uRLArray = new URL[n];
            for (String string : set) {
                if (!string.endsWith("/")) continue;
                try {
                    uRLArray[n2++] = externalContext.getResource(string);
                }
                catch (MalformedURLException malformedURLException) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, null, malformedURLException);
                }
            }
        }
        if (null == uRLArray) {
            uRLArray = new URL[]{};
        }
        return uRLArray;
    }

    @Override
    public void addURL(URL uRL) {
        this.loader.getGroovyScriptEngine().getGroovyClassLoader().addURL(uRL);
    }

    @Override
    public Class<?> loadScript(String string) {
        try {
            String string2 = string;
            if (string2.endsWith(".groovy")) {
                string2 = string2.substring(0, string2.indexOf(".groovy"));
            }
            return Util.loadClass(string2, this);
        }
        catch (Exception exception) {
            throw new FacesException(exception);
        }
    }

    @Override
    public void setClassLoader() {
        if (this.loader != null) {
            Thread.currentThread().setContextClassLoader(this.loader);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MojarraGroovyClassLoader
    extends URLClassLoader {
        private GroovyScriptEngine gse;

        public MojarraGroovyClassLoader(GroovyScriptEngine groovyScriptEngine) {
            super(new URL[0], (ClassLoader)groovyScriptEngine.getGroovyClassLoader());
            groovyScriptEngine.getGroovyClassLoader().setShouldRecompile(Boolean.TRUE);
            this.gse = groovyScriptEngine;
        }

        public GroovyScriptEngine getGroovyScriptEngine() {
            return this.gse;
        }

        @Override
        public Class<?> loadClass(String string) throws ClassNotFoundException {
            Class clazz;
            if (string == null) {
                throw new NullPointerException();
            }
            try {
                clazz = this.gse.loadScriptByName(string);
            }
            catch (Exception exception) {
                try {
                    clazz = this.gse.getGroovyClassLoader().loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new ClassNotFoundException(string, classNotFoundException);
                }
            }
            if (clazz == null) {
                throw new ClassNotFoundException(string);
            }
            return clazz;
        }
    }
}

