/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.LinkRenderer;
import com.sun.faces.util.MessageUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLinkRenderer
extends LinkRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.COMMANDLINK);
    private static final String SCRIPT_STATE = "com.sun.faces.scriptState";

    @Override
    public void decode(FacesContext facesContext, UIComponent uIComponent) {
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (!this.shouldDecode(uIComponent)) {
            return;
        }
        String string = this.decodeBehaviors(facesContext, uIComponent);
        if (CommandLinkRenderer.wasClicked(facesContext, uIComponent, string)) {
            uIComponent.queueEvent(new ActionEvent(uIComponent));
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("This commandLink resulted in form submission  ActionEvent queued.");
            }
        }
    }

    @Override
    public void encodeBegin(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (!this.shouldEncode(uIComponent)) {
            return;
        }
        boolean bl = Boolean.TRUE.equals(uIComponent.getAttributes().get("disabled"));
        String string = RenderKitUtils.getFormClientId(uIComponent, facesContext);
        if (bl || string == null) {
            this.renderAsDisabled(facesContext, uIComponent);
        } else {
            RenderKitUtils.renderJsfJs(facesContext);
            this.renderAsActive(facesContext, uIComponent);
        }
    }

    @Override
    public void encodeChildren(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (!this.shouldEncodeChildren(uIComponent)) {
            return;
        }
        if (uIComponent.getChildCount() > 0) {
            for (UIComponent uIComponent2 : uIComponent.getChildren()) {
                this.encodeRecursive(facesContext, uIComponent2);
            }
        }
    }

    @Override
    public void encodeEnd(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (!this.shouldEncode(uIComponent)) {
            return;
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        assert (responseWriter != null);
        String string = RenderKitUtils.getFormClientId(uIComponent, facesContext);
        if (string == null) {
            responseWriter.write(MessageUtils.getExceptionMessageString("com.sun.faces.COMMAND_LINK_NO_FORM_MESSAGE", new Object[0]));
            responseWriter.endElement("span");
            return;
        }
        if (Boolean.TRUE.equals(uIComponent.getAttributes().get("disabled"))) {
            responseWriter.endElement("span");
        } else {
            responseWriter.endElement("a");
        }
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected Object getValue(UIComponent uIComponent) {
        return ((UICommand)uIComponent).getValue();
    }

    @Override
    protected void renderAsActive(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        assert (responseWriter != null);
        String string = RenderKitUtils.getFormClientId(uIComponent, facesContext);
        if (string == null) {
            return;
        }
        responseWriter.startElement("a", uIComponent);
        this.writeIdAttributeIfNecessary(facesContext, responseWriter, uIComponent);
        responseWriter.writeAttribute("href", "#", "href");
        RenderKitUtils.renderPassThruAttributes(facesContext, responseWriter, uIComponent, ATTRIBUTES, CommandLinkRenderer.getNonOnClickBehaviors(uIComponent));
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(responseWriter, uIComponent);
        String string2 = (String)uIComponent.getAttributes().get("target");
        string2 = string2 != null ? string2.trim() : "";
        Collection<ClientBehaviorContext.Parameter> collection = this.getBehaviorParameters(uIComponent);
        RenderKitUtils.renderOnclick(facesContext, uIComponent, collection, string2, true);
        this.writeCommonLinkAttributes(responseWriter, uIComponent);
        this.writeValue(uIComponent, responseWriter);
        responseWriter.flush();
    }

    private static boolean wasClicked(FacesContext facesContext, UIComponent uIComponent, String string) {
        Map<String, String> map = facesContext.getExternalContext().getRequestParameterMap();
        if (string == null) {
            string = uIComponent.getClientId(facesContext);
        }
        return map.containsKey(string) || RenderKitUtils.isPartialOrBehaviorAction(facesContext, string);
    }

    private static Map<String, List<ClientBehavior>> getNonOnClickBehaviors(UIComponent uIComponent) {
        return CommandLinkRenderer.getPassThruBehaviors(uIComponent, "click", "action");
    }
}

