/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.spi.SerializationProvider;
import com.sun.faces.spi.SerializationProviderFactory;
import com.sun.faces.util.Util;
import java.io.IOException;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.lifecycle.ClientWindow;

public abstract class StateHelper {
    protected static final char[] STATE_FIELD_START = "<input type=\"hidden\" name=\"javax.faces.ViewState\" id=\"".toCharArray();
    protected static final char[] FIELD_MIDDLE = "\" value=\"".toCharArray();
    protected static final char[] FIELD_END = "\" />".toCharArray();
    protected static final char[] STATE_FIELD_AUTOCOMPLETE_END = "\" autocomplete=\"off\" />".toCharArray();
    protected SerializationProvider serialProvider;
    protected WebConfiguration webConfig;
    protected boolean compressViewState;
    protected char[] stateFieldStart;
    protected char[] fieldMiddle;
    protected char[] fieldEnd;
    protected boolean namespaceParameters;
    private static final String TOKEN_NAME = "com.sun.faces.TOKEN";

    public StateHelper() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.serialProvider = SerializationProviderFactory.createInstance(facesContext.getExternalContext());
        this.webConfig = WebConfiguration.getInstance(facesContext.getExternalContext());
        this.compressViewState = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.CompressViewState);
        this.stateFieldStart = STATE_FIELD_START;
        this.fieldMiddle = FIELD_MIDDLE;
        char[] cArray = this.fieldEnd = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.AutoCompleteOffOnViewState) ? STATE_FIELD_AUTOCOMPLETE_END : FIELD_END;
        if (this.serialProvider == null) {
            this.serialProvider = SerializationProviderFactory.createInstance(FacesContext.getCurrentInstance().getExternalContext());
        }
        this.namespaceParameters = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.NamespaceParameters);
    }

    private String createCryptographicallyStrongToken() {
        String string = "" + System.currentTimeMillis();
        return string;
    }

    public String getCryptographicallyStrongTokenFromSession(FacesContext facesContext) {
        String string = (String)facesContext.getExternalContext().getSessionMap().get(TOKEN_NAME);
        if (null == string) {
            string = this.createCryptographicallyStrongToken();
            facesContext.getExternalContext().getSessionMap().put(TOKEN_NAME, string);
        }
        return string;
    }

    public abstract void writeState(FacesContext var1, Object var2, StringBuilder var3) throws IOException;

    public abstract Object getState(FacesContext var1, String var2) throws IOException;

    public abstract boolean isStateless(FacesContext var1, String var2) throws IllegalStateException;

    protected static String getStateParamValue(FacesContext facesContext) {
        String string = facesContext.getExternalContext().getRequestParameterMap().get("javax.faces.ViewState");
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    protected void writeRenderKitIdField(FacesContext facesContext, ResponseWriter responseWriter) throws IOException {
        String string = facesContext.getViewRoot().getRenderKitId();
        String string2 = facesContext.getApplication().getDefaultRenderKitId();
        if (null == string2) {
            string2 = "HTML_BASIC";
        }
        if (string != null && !string2.equals(string)) {
            String string3;
            responseWriter.startElement("input", facesContext.getViewRoot());
            responseWriter.writeAttribute("type", "hidden", "type");
            String string4 = "javax.faces.RenderKitId";
            UIViewRoot uIViewRoot = facesContext.getViewRoot();
            if (this.namespaceParameters && uIViewRoot instanceof NamingContainer && (string3 = uIViewRoot.getContainerClientId(facesContext)) != null) {
                string4 = string3 + string4;
            }
            responseWriter.writeAttribute("name", string4, "name");
            responseWriter.writeAttribute("value", string, "value");
            responseWriter.endElement("input");
        }
    }

    protected void writeClientWindowField(FacesContext facesContext, ResponseWriter responseWriter) throws IOException {
        ClientWindow clientWindow = facesContext.getExternalContext().getClientWindow();
        if (null != clientWindow) {
            String string;
            responseWriter.startElement("input", null);
            responseWriter.writeAttribute("type", "hidden", null);
            String string2 = "javax.faces.ClientWindow";
            UIViewRoot uIViewRoot = facesContext.getViewRoot();
            if (this.namespaceParameters && uIViewRoot instanceof NamingContainer && (string = uIViewRoot.getContainerClientId(facesContext)) != null) {
                string2 = string + string2;
            }
            responseWriter.writeAttribute("name", string2, null);
            responseWriter.writeAttribute("id", Util.getClientWindowId(facesContext), null);
            responseWriter.writeAttribute("value", clientWindow.getId(), null);
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.AutoCompleteOffOnViewState)) {
                responseWriter.writeAttribute("autocomplete", "off", null);
            }
            responseWriter.endElement("input");
        }
    }
}

