/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.facelets.util.DevTools;
import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.SelectItemsIterator;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.ActionSource;
import javax.faces.component.ActionSource2;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIForm;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHint;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlMessages;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderKitUtils {
    private static final String XHTML_ATTR_PREFIX = "xml:";
    private static final String[] BOOLEAN_ATTRIBUTES = new String[]{"disabled", "ismap", "readonly"};
    private static final String[] XHTML_PREFIX_ATTRIBUTES = new String[]{"lang"};
    private static final int MAX_CONTENT_TYPE_PARTS = 4;
    private static final String CONTENT_TYPE_DELIMITER = ",";
    private static final String CONTENT_TYPE_SUBTYPE_DELIMITER = "/";
    private static final String OPTIMIZED_PACKAGE = "javax.faces.component.";
    private static final String ATTRIBUTES_THAT_ARE_SET_KEY = UIComponentBase.class.getName() + ".attributesThatAreSet";
    protected static final Logger LOGGER = FacesLogger.RENDERKIT.getLogger();

    private RenderKitUtils() {
    }

    public static RenderKit getCurrentRenderKit(FacesContext facesContext) {
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
        return renderKitFactory.getRenderKit(facesContext, facesContext.getViewRoot().getRenderKitId());
    }

    public static ResponseStateManager getResponseStateManager(FacesContext facesContext, String string) throws FacesException {
        assert (null != string);
        assert (null != facesContext);
        RenderKit renderKit = facesContext.getRenderKit();
        if (renderKit == null) {
            RenderKitFactory renderKitFactory = (RenderKitFactory)RequestStateManager.get(facesContext, "com.sun.faces.renderKitImplForRequest");
            if (renderKitFactory != null) {
                renderKit = renderKitFactory.getRenderKit(facesContext, string);
            } else {
                renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
                if (renderKitFactory == null) {
                    throw new FacesException("Unable to locate RenderKitFactory for javax.faces.render.RenderKitFactory");
                }
                RequestStateManager.set(facesContext, "com.sun.faces.renderKitImplForRequest", renderKitFactory);
                renderKit = renderKitFactory.getRenderKit(facesContext, string);
                if (renderKit == null) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "Unable to locate renderkit instance for render-kit-id {0}.  Using {1} instead.", new String[]{string, "HTML_BASIC"});
                    }
                    string = "HTML_BASIC";
                    UIViewRoot uIViewRoot = facesContext.getViewRoot();
                    if (null != uIViewRoot) {
                        uIViewRoot.setRenderKitId(string);
                    }
                }
                if ((renderKit = renderKitFactory.getRenderKit(facesContext, string)) == null) {
                    throw new FacesException("Unable to locate renderkit instance for render-kit-id " + string);
                }
            }
        }
        return renderKit.getResponseStateManager();
    }

    public static SelectItemsIterator<SelectItem> getSelectItems(FacesContext facesContext, UIComponent uIComponent) {
        Util.notNull("context", facesContext);
        Util.notNull("component", uIComponent);
        return new SelectItemsIterator<SelectItem>(facesContext, uIComponent);
    }

    public static void renderPassThruAttributes(FacesContext facesContext, ResponseWriter responseWriter, UIComponent uIComponent, Attribute[] attributeArray) throws IOException {
        assert (null != facesContext);
        assert (null != responseWriter);
        assert (null != uIComponent);
        Map<String, List<ClientBehavior>> map = null;
        if (uIComponent instanceof ClientBehaviorHolder) {
            map = ((ClientBehaviorHolder)((Object)uIComponent)).getClientBehaviors();
        }
        if (null != map && map.size() > 0 && Util.componentIsDisabled(uIComponent)) {
            map = null;
        }
        RenderKitUtils.renderPassThruAttributes(facesContext, responseWriter, uIComponent, attributeArray, map);
    }

    public static void renderPassThruAttributes(FacesContext facesContext, ResponseWriter responseWriter, UIComponent uIComponent, Attribute[] attributeArray, Map<String, List<ClientBehavior>> map) throws IOException {
        assert (null != responseWriter);
        assert (null != uIComponent);
        if (map == null) {
            map = Collections.emptyMap();
        }
        if (RenderKitUtils.canBeOptimized(uIComponent, map)) {
            List list = (List)uIComponent.getAttributes().get(ATTRIBUTES_THAT_ARE_SET_KEY);
            if (list != null) {
                RenderKitUtils.renderPassThruAttributesOptimized(facesContext, responseWriter, uIComponent, attributeArray, list, map);
            }
        } else {
            RenderKitUtils.renderPassThruAttributesUnoptimized(facesContext, responseWriter, uIComponent, attributeArray, map);
        }
    }

    public static void renderOnchange(FacesContext facesContext, UIComponent uIComponent, boolean bl) throws IOException {
        LinkedList<ClientBehaviorContext.Parameter> linkedList;
        Object object = uIComponent.getAttributes().get("onchange");
        String string = "valueChange";
        if (uIComponent instanceof ClientBehaviorHolder && null != (linkedList = ((ClientBehaviorHolder)((Object)uIComponent)).getClientBehaviors()) && linkedList.containsKey("change")) {
            string = "change";
        }
        if (!bl) {
            linkedList = Collections.emptyList();
        } else {
            linkedList = new LinkedList<ClientBehaviorContext.Parameter>();
            linkedList.add(new ClientBehaviorContext.Parameter("incExec", true));
        }
        RenderKitUtils.renderHandler(facesContext, uIComponent, linkedList, "onchange", object, string, null, false, bl);
    }

    public static void renderSelectOnclick(FacesContext facesContext, UIComponent uIComponent, boolean bl) throws IOException {
        LinkedList<ClientBehaviorContext.Parameter> linkedList;
        Object object = uIComponent.getAttributes().get("onclick");
        String string = "valueChange";
        if (uIComponent instanceof ClientBehaviorHolder && null != (linkedList = ((ClientBehaviorHolder)((Object)uIComponent)).getClientBehaviors()) && linkedList.containsKey("click")) {
            string = "click";
        }
        if (!bl) {
            linkedList = Collections.emptyList();
        } else {
            linkedList = new LinkedList<ClientBehaviorContext.Parameter>();
            linkedList.add(new ClientBehaviorContext.Parameter("incExec", true));
        }
        RenderKitUtils.renderHandler(facesContext, uIComponent, linkedList, "onclick", object, string, null, false, bl);
    }

    public static void renderOnclick(FacesContext facesContext, UIComponent uIComponent, Collection<ClientBehaviorContext.Parameter> collection, String string, boolean bl) throws IOException {
        Map<String, List<ClientBehavior>> map;
        Object object = uIComponent.getAttributes().get("onclick");
        String string2 = "action";
        if (uIComponent instanceof ClientBehaviorHolder && null != (map = ((ClientBehaviorHolder)((Object)uIComponent)).getClientBehaviors()) && map.containsKey("click")) {
            string2 = "click";
        }
        RenderKitUtils.renderHandler(facesContext, uIComponent, collection, "onclick", object, string2, string, bl, false);
    }

    public static String prefixAttribute(String string, ResponseWriter responseWriter) {
        return RenderKitUtils.prefixAttribute(string, "application/xhtml+xml".equals(responseWriter.getContentType()));
    }

    public static String prefixAttribute(String string, boolean bl) {
        if (bl) {
            if (Arrays.binarySearch(XHTML_PREFIX_ATTRIBUTES, string) > -1) {
                return XHTML_ATTR_PREFIX + string;
            }
            return string;
        }
        return string;
    }

    public static void renderXHTMLStyleBooleanAttributes(ResponseWriter responseWriter, UIComponent uIComponent) throws IOException {
        assert (responseWriter != null);
        assert (uIComponent != null);
        List list = null;
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(responseWriter, uIComponent, list);
    }

    public static void renderXHTMLStyleBooleanAttributes(ResponseWriter responseWriter, UIComponent uIComponent, List list) throws IOException {
        assert (responseWriter != null);
        assert (uIComponent != null);
        Map<String, Object> map = uIComponent.getAttributes();
        for (String string : BOOLEAN_ATTRIBUTES) {
            Object object;
            if (RenderKitUtils.isExcludedAttribute(string, list) || (object = map.get(string)) == null || !Boolean.valueOf(object.toString()).booleanValue()) continue;
            responseWriter.writeAttribute(string, true, string);
        }
    }

    public static String determineContentType(String string, String string2, String string3) {
        String[][] stringArray;
        String[][] stringArray2;
        String string4 = null;
        if (null == string || null == string2) {
            return string4;
        }
        String[][] stringArray3 = RenderKitUtils.buildTypeArrayFromString(string);
        String[][] stringArray4 = RenderKitUtils.findMatch(stringArray3, stringArray2 = RenderKitUtils.buildTypeArrayFromString(string2), stringArray = RenderKitUtils.buildTypeArrayFromString(string3));
        if (stringArray4[0][1] != null && !stringArray4[0][2].equals("*")) {
            string4 = stringArray4[0][1] + CONTENT_TYPE_SUBTYPE_DELIMITER + stringArray4[0][2];
        }
        return string4;
    }

    public static boolean isXml(String string) {
        return "application/xhtml+xml".equals(string) || "application/xml".equals(string) || "text/xml".equals(string);
    }

    private static boolean canBeOptimized(UIComponent uIComponent, Map<String, List<ClientBehavior>> map) {
        assert (uIComponent != null);
        assert (map != null);
        String string = uIComponent.getClass().getName();
        if (string != null && string.startsWith(OPTIMIZED_PACKAGE)) {
            return map.size() < 2;
        }
        return false;
    }

    private static void renderPassThruAttributesOptimized(FacesContext facesContext, ResponseWriter responseWriter, UIComponent uIComponent, Attribute[] attributeArray, List<String> list, Map<String, List<ClientBehavior>> map) throws IOException {
        assert (map != null && map.size() < 2);
        String string = RenderKitUtils.getSingleBehaviorEventName(map);
        boolean bl = false;
        Collections.sort(list);
        boolean bl2 = "application/xhtml+xml".equals(responseWriter.getContentType());
        Map<String, Object> map2 = uIComponent.getAttributes();
        for (String object : list) {
            Object object2;
            int n = Arrays.binarySearch(attributeArray, Attribute.attr(object));
            if (n < 0 || (object2 = map2.get(object)) == null || !RenderKitUtils.shouldRenderAttribute(object2)) continue;
            Attribute attribute = attributeArray[n];
            if (RenderKitUtils.isBehaviorEventAttribute(attribute, string)) {
                RenderKitUtils.renderHandler(facesContext, uIComponent, null, object, object2, string, null, false, false);
                bl = true;
                continue;
            }
            responseWriter.writeAttribute(RenderKitUtils.prefixAttribute(object, bl2), object2, object);
        }
        if (string != null && !bl) {
            for (int i = 0; i < attributeArray.length; ++i) {
                Attribute attribute = attributeArray[i];
                String[] stringArray = attribute.getEvents();
                if (stringArray == null || stringArray.length <= 0 || !string.equals(stringArray[0])) continue;
                RenderKitUtils.renderHandler(facesContext, uIComponent, null, attribute.getName(), null, string, null, false, false);
            }
        }
    }

    private static void renderPassThruAttributesUnoptimized(FacesContext facesContext, ResponseWriter responseWriter, UIComponent uIComponent, Attribute[] attributeArray, Map<String, List<ClientBehavior>> map) throws IOException {
        boolean bl = "application/xhtml+xml".equals(responseWriter.getContentType());
        Map<String, Object> map2 = uIComponent.getAttributes();
        for (Attribute attribute : attributeArray) {
            String string = attribute.getName();
            String[] stringArray = attribute.getEvents();
            boolean bl2 = stringArray != null && stringArray.length > 0 && map.containsKey(stringArray[0]);
            Object object = map2.get(string);
            if (object != null && RenderKitUtils.shouldRenderAttribute(object) && !bl2) {
                responseWriter.writeAttribute(RenderKitUtils.prefixAttribute(string, bl), object, string);
                continue;
            }
            if (!bl2) continue;
            RenderKitUtils.renderHandler(facesContext, uIComponent, null, string, object, stringArray[0], null, false, false);
        }
    }

    private static boolean shouldRenderAttribute(Object object) {
        if (object instanceof String) {
            return true;
        }
        if (object instanceof Boolean && Boolean.FALSE.equals(object)) {
            return false;
        }
        if (object instanceof Integer && (Integer)object == Integer.MIN_VALUE) {
            return false;
        }
        if (object instanceof Double && (Double)object == Double.MIN_VALUE) {
            return false;
        }
        if (object instanceof Character && ((Character)object).charValue() == '\u0000') {
            return false;
        }
        if (object instanceof Float && ((Float)object).floatValue() == Float.MIN_VALUE) {
            return false;
        }
        if (object instanceof Short && (Short)object == Short.MIN_VALUE) {
            return false;
        }
        if (object instanceof Byte && (Byte)object == -128) {
            return false;
        }
        return !(object instanceof Long) || (Long)object != Long.MIN_VALUE;
    }

    private static boolean isExcludedAttribute(String string, List list) {
        if (null == list) {
            return false;
        }
        return list.contains(string);
    }

    private static String[][] buildTypeArrayFromString(String string) {
        if (string == null || string.length() == 0) {
            return new String[0][0];
        }
        String string2 = null;
        String string3 = null;
        Map<String, Object> map = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
        String[] stringArray = Util.split(map, string, CONTENT_TYPE_DELIMITER);
        String[][] stringArray2 = new String[stringArray.length][4];
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            String string4;
            String string5;
            StringBuilder stringBuilder;
            String[] stringArray3;
            String string6 = stringArray[i].trim();
            ++n;
            if (string6.contains(";")) {
                stringArray3 = Util.split(map, string6, ";");
                stringBuilder = new StringBuilder(stringArray3[0].trim());
                for (int j = 1; j < stringArray3.length; ++j) {
                    String[] stringArray4;
                    string3 = "not set";
                    string6 = stringArray3[j].trim();
                    if (string6.contains("level")) {
                        stringBuilder.append(';').append(string6);
                        stringArray4 = Util.split(map, string6, "=");
                        string2 = stringArray4[0].trim();
                        if (!string2.equalsIgnoreCase("level")) continue;
                        string2 = stringArray4[1].trim();
                        continue;
                    }
                    string3 = string6;
                    stringArray4 = Util.split(map, string3, "=");
                    if ((string3 = stringArray4[0].trim()).equalsIgnoreCase("q")) {
                        string3 = stringArray4[1].trim();
                        break;
                    }
                    string3 = "not set";
                }
            } else {
                stringBuilder = new StringBuilder(string6);
                string3 = "not set";
            }
            if (stringBuilder.indexOf(CONTENT_TYPE_SUBTYPE_DELIMITER) >= 0) {
                stringArray3 = Util.split(map, stringBuilder.toString(), CONTENT_TYPE_SUBTYPE_DELIMITER);
                if (stringArray3.length == 1) {
                    string5 = stringArray3[0].trim();
                    string4 = "*";
                } else {
                    string5 = stringArray3[0].trim();
                    string4 = stringArray3[1].trim();
                }
            } else {
                string5 = stringBuilder.toString();
                string4 = "";
            }
            if ("not set".equals(string3)) {
                string3 = string5.equals("*") && string4.equals("*") ? "0.01" : (!string5.equals("*") && string4.equals("*") ? "0.02" : (string5.equals("*") && string4.length() == 0 ? "0.01" : "1"));
            }
            stringArray2[n][0] = string3;
            stringArray2[n][1] = string5;
            stringArray2[n][2] = string4;
            stringArray2[n][3] = string2;
        }
        return stringArray2;
    }

    private static String[][] findMatch(String[][] stringArray, String[][] stringArray2, String[][] stringArray3) {
        int n;
        ArrayList<String[]> arrayList = new ArrayList<String[]>(stringArray2.length);
        double d = 0.0;
        int n2 = 0;
        int n3 = stringArray2.length;
        for (int i = 0; i < n3; ++i) {
            String string = stringArray2[i][1];
            if (string == null) continue;
            int n4 = stringArray.length;
            for (n = 0; n < n4; ++n) {
                String string2 = stringArray[n][1];
                if (string2 == null || !string2.equalsIgnoreCase(string) && !string2.equals("*") || !stringArray[n][2].equalsIgnoreCase(stringArray2[i][2]) && !stringArray[n][2].equals("*")) continue;
                double d2 = 0.0;
                double d3 = 0.0;
                if (stringArray[n][3] != null) {
                    d2 = Double.parseDouble(stringArray[n][3]) * 0.1;
                }
                if (stringArray2[i][3] != null) {
                    d3 = Double.parseDouble(stringArray2[i][3]) * 0.1;
                }
                double d4 = Double.parseDouble(stringArray[n][0]) + d2;
                double d5 = Double.parseDouble(stringArray2[i][0]) + d3;
                double d6 = d4 * d5;
                String[] stringArray4 = new String[4];
                arrayList.add(stringArray4);
                stringArray4[0] = String.valueOf(d6);
                if (stringArray[n][2].equals("*")) {
                    stringArray4[1] = stringArray[n][1];
                    stringArray4[2] = stringArray[n][2];
                } else {
                    stringArray4[1] = stringArray2[i][1];
                    stringArray4[2] = stringArray2[i][2];
                    stringArray4[3] = stringArray2[i][3];
                }
                if (!(d6 > d)) continue;
                n2 = arrayList.size() - 1;
                d = d6;
            }
        }
        String[][] stringArray5 = new String[1][3];
        if (stringArray3.length != 0 && stringArray3[0][0] != null) {
            BigDecimal bigDecimal = BigDecimal.valueOf(d);
            n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String[] stringArray6 = (String[])arrayList.get(i);
                if (BigDecimal.valueOf(Double.parseDouble(stringArray6[0])).compareTo(bigDecimal) != 0 || !stringArray6[1].equals(stringArray3[0][1]) || !stringArray6[2].equals(stringArray3[0][2])) continue;
                stringArray5[0][0] = stringArray6[0];
                stringArray5[0][1] = stringArray6[1];
                stringArray5[0][2] = stringArray6[2];
                return stringArray5;
            }
        }
        if (!arrayList.isEmpty()) {
            String[] stringArray7 = (String[])arrayList.get(n2);
            stringArray5[0][0] = stringArray7[0];
            stringArray5[0][1] = stringArray7[1];
            stringArray5[0][2] = stringArray7[2];
        }
        return stringArray5;
    }

    public static String createValidECMAIdentifier(String string) {
        return string.replace("-", "$_");
    }

    public static void renderJsfJs(FacesContext facesContext) throws IOException {
        if (RenderKitUtils.hasScriptBeenRendered(facesContext)) {
            return;
        }
        if (RenderKitUtils.hasResourceBeenInstalled(facesContext, "jsf.js", "javax.faces")) {
            RenderKitUtils.setScriptAsRendered(facesContext);
            return;
        }
        ResourceHandler resourceHandler = facesContext.getApplication().getResourceHandler();
        Resource resource = resourceHandler.createResource("jsf.js", "javax.faces");
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.write(10);
        responseWriter.startElement("script", null);
        responseWriter.writeAttribute("type", "text/javascript", null);
        responseWriter.writeAttribute("src", resource != null ? resource.getRequestPath() : "", null);
        responseWriter.endElement("script");
        responseWriter.append('\r');
        responseWriter.append('\n');
        RenderKitUtils.setScriptAsRendered(facesContext);
    }

    public static boolean hasResourceBeenInstalled(FacesContext facesContext, String string, String string2) {
        String string3;
        String string4;
        UIComponent uIComponent;
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        ListIterator<UIComponent> listIterator = uIViewRoot.getComponentResources(facesContext, "head").listIterator();
        while (listIterator.hasNext()) {
            uIComponent = listIterator.next();
            string4 = (String)uIComponent.getAttributes().get("name");
            string3 = (String)uIComponent.getAttributes().get("library");
            if (!string.equals(string4) || !string2.equals(string3)) continue;
            return true;
        }
        listIterator = uIViewRoot.getComponentResources(facesContext, "body").listIterator();
        while (listIterator.hasNext()) {
            uIComponent = listIterator.next();
            string4 = (String)uIComponent.getAttributes().get("name");
            string3 = (String)uIComponent.getAttributes().get("library");
            if (!string.equals(string4) || !string2.equals(string3)) continue;
            return true;
        }
        listIterator = uIViewRoot.getComponentResources(facesContext, "form").listIterator();
        while (listIterator.hasNext()) {
            uIComponent = listIterator.next();
            string4 = (String)uIComponent.getAttributes().get("name");
            string3 = (String)uIComponent.getAttributes().get("library");
            if (!string.equals(string4) || !string2.equals(string3)) continue;
            return true;
        }
        return false;
    }

    public static void renderUnhandledMessages(FacesContext facesContext) {
        if (facesContext.isProjectStage(ProjectStage.Development)) {
            Application application = facesContext.getApplication();
            HtmlMessages htmlMessages = (HtmlMessages)application.createComponent("javax.faces.HtmlMessages");
            htmlMessages.setId("javax_faces_developmentstage_messages");
            Renderer renderer = facesContext.getRenderKit().getRenderer("javax.faces.Messages", "javax.faces.Messages");
            htmlMessages.setErrorStyle("Color: red");
            htmlMessages.setWarnStyle("Color: orange");
            htmlMessages.setInfoStyle("Color: blue");
            htmlMessages.setFatalStyle("Color: red");
            htmlMessages.setTooltip(true);
            htmlMessages.setTitle("Project Stage[Development]: Unhandled Messages");
            htmlMessages.setRedisplay(false);
            try {
                renderer.encodeBegin(facesContext, htmlMessages);
                renderer.encodeEnd(facesContext, htmlMessages);
            }
            catch (IOException iOException) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, iOException.toString(), iOException);
                }
            }
        } else {
            Iterator<String> iterator = facesContext.getClientIdsWithMessages();
            int n = 0;
            if (iterator.hasNext()) {
                StringBuilder stringBuilder = new StringBuilder();
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    Iterator<FacesMessage> iterator2 = facesContext.getMessages(string);
                    while (iterator2.hasNext()) {
                        FacesMessage facesMessage = iterator2.next();
                        if (facesMessage.isRendered()) continue;
                        ++n;
                        stringBuilder.append("\n");
                        stringBuilder.append("sourceId=").append(string);
                        stringBuilder.append("[severity=(").append(facesMessage.getSeverity());
                        stringBuilder.append("), summary=(").append(facesMessage.getSummary());
                        stringBuilder.append("), detail=(").append(facesMessage.getDetail()).append(")]");
                    }
                }
                if (n > 0 && LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "jsf.non_displayed_message", stringBuilder.toString());
                }
            }
        }
    }

    public static void renderHtmlErrorPage(FacesContext facesContext, FacesException facesException) {
        ExternalContext externalContext = facesContext.getExternalContext();
        if (!externalContext.isResponseCommitted()) {
            block8: {
                externalContext.setResponseContentType("text/html; charset=UTF-8");
                try {
                    Writer writer = externalContext.getResponseOutputWriter();
                    if (facesContext.isProjectStage(ProjectStage.Development)) {
                        DevTools.debugHtml(writer, facesContext, facesException.getCause());
                    } else {
                        writer.write("Please see your server log for the actual error");
                    }
                    writer.flush();
                }
                catch (IOException iOException) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block8;
                    LOGGER.log(Level.SEVERE, "Unable to generate Facelets error page.", iOException);
                }
            }
            facesContext.responseComplete();
        } else {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.facelets.error.page.response.committed");
            }
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, facesException.toString(), facesException);
            }
        }
    }

    public static boolean isPartialOrBehaviorAction(FacesContext facesContext, String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        Map<String, String> map = externalContext.getRequestParameterMap();
        String string2 = map.get("javax.faces.source");
        if (!string.equals(string2)) {
            return false;
        }
        String string3 = map.get("javax.faces.behavior.event");
        if (null != string3) {
            return "action".equals(string3);
        }
        String string4 = map.get("javax.faces.partial.event");
        return "click".equals(string4);
    }

    public static String getFormClientId(UIComponent uIComponent, FacesContext facesContext) {
        UIForm uIForm = RenderKitUtils.getForm(uIComponent, facesContext);
        if (uIForm != null) {
            return uIForm.getClientId(facesContext);
        }
        return null;
    }

    public static UIForm getForm(UIComponent uIComponent, FacesContext facesContext) {
        UIComponent uIComponent2;
        for (uIComponent2 = uIComponent.getParent(); uIComponent2 != null && !(uIComponent2 instanceof UIForm); uIComponent2 = uIComponent2.getParent()) {
        }
        UIForm uIForm = (UIForm)uIComponent2;
        if (uIForm != null) {
            return uIForm;
        }
        return null;
    }

    public static boolean hasScriptBeenRendered(FacesContext facesContext) {
        return RequestStateManager.containsKey(facesContext, "com.sun.faces.SCRIPT_STATE");
    }

    public static void setScriptAsRendered(FacesContext facesContext) {
        RequestStateManager.set(facesContext, "com.sun.faces.SCRIPT_STATE", Boolean.TRUE);
    }

    public static String getImageSource(FacesContext facesContext, UIComponent uIComponent, String string) {
        String string2 = (String)uIComponent.getAttributes().get("name");
        ResourceHandler resourceHandler = facesContext.getApplication().getResourceHandler();
        if (string2 != null) {
            String string3 = (String)uIComponent.getAttributes().get("library");
            WebConfiguration webConfiguration = WebConfiguration.getInstance();
            if (string3 == null && string2.startsWith(webConfiguration.getOptionValue(WebConfiguration.WebContextInitParameter.WebAppContractsDirectory))) {
                if (facesContext.isProjectStage(ProjectStage.Development)) {
                    String string4 = "Illegal path, direct contract references are not allowed: " + string2;
                    facesContext.addMessage(uIComponent.getClientId(facesContext), new FacesMessage(FacesMessage.SEVERITY_ERROR, string4, string4));
                }
                return "RES_NOT_FOUND";
            }
            Resource resource = resourceHandler.createResource(string2, string3);
            if (resource == null) {
                if (facesContext.isProjectStage(ProjectStage.Development)) {
                    String string5 = "Unable to find resource " + (string3 == null ? "" : string3 + ", ") + string2;
                    facesContext.addMessage(uIComponent.getClientId(facesContext), new FacesMessage(FacesMessage.SEVERITY_ERROR, string5, string5));
                }
                return "RES_NOT_FOUND";
            }
            String string6 = resource.getRequestPath();
            return facesContext.getExternalContext().encodeResourceURL(string6);
        }
        String string7 = (String)uIComponent.getAttributes().get(string);
        if (string7 == null || string7.length() == 0) {
            return "";
        }
        WebConfiguration webConfiguration = WebConfiguration.getInstance();
        if (string7.startsWith(webConfiguration.getOptionValue(WebConfiguration.WebContextInitParameter.WebAppContractsDirectory))) {
            if (facesContext.isProjectStage(ProjectStage.Development)) {
                String string8 = "Illegal path, direct contract references are not allowed: " + string7;
                facesContext.addMessage(uIComponent.getClientId(facesContext), new FacesMessage(FacesMessage.SEVERITY_ERROR, string8, string8));
            }
            return "RES_NOT_FOUND";
        }
        if (resourceHandler.isResourceURL(string7)) {
            return string7;
        }
        string7 = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, string7);
        return facesContext.getExternalContext().encodeResourceURL(string7);
    }

    private static void appendScriptToChain(StringBuilder stringBuilder, String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("jsf.util.chain(this,event,");
        }
        if (stringBuilder.charAt(stringBuilder.length() - 1) != ',') {
            stringBuilder.append(',');
        }
        RenderKitUtils.appendQuotedValue(stringBuilder, string);
    }

    public static void appendProperty(StringBuilder stringBuilder, String string, Object object) {
        RenderKitUtils.appendProperty(stringBuilder, string, object, true);
    }

    public static void appendProperty(StringBuilder stringBuilder, String string, Object object, boolean bl) {
        if (null == string || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        char c = stringBuilder.charAt(stringBuilder.length() - 1);
        if (c != ',' && c != '{') {
            stringBuilder.append(',');
        }
        RenderKitUtils.appendQuotedValue(stringBuilder, string);
        stringBuilder.append(":");
        if (object == null) {
            stringBuilder.append("''");
        } else if (bl) {
            RenderKitUtils.appendQuotedValue(stringBuilder, object.toString());
        } else {
            stringBuilder.append(object.toString());
        }
    }

    private static void appendQuotedValue(StringBuilder stringBuilder, String string) {
        stringBuilder.append("'");
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\'' || c == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        stringBuilder.append("'");
    }

    private static boolean appendBehaviorsToChain(StringBuilder stringBuilder, FacesContext facesContext, UIComponent uIComponent, List<ClientBehavior> list, String string, Collection<ClientBehaviorContext.Parameter> collection) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        ClientBehaviorContext clientBehaviorContext = RenderKitUtils.createClientBehaviorContext(facesContext, uIComponent, string, collection);
        boolean bl = false;
        for (ClientBehavior clientBehavior : list) {
            String string2 = clientBehavior.getScript(clientBehaviorContext);
            if (string2 == null || string2.length() <= 0) continue;
            RenderKitUtils.appendScriptToChain(stringBuilder, string2);
            if (!RenderKitUtils.isSubmitting(clientBehavior)) continue;
            bl = true;
        }
        return bl;
    }

    private static String getSingleBehaviorEventName(Map<String, List<ClientBehavior>> map) {
        assert (map != null);
        int n = map.size();
        if (n == 0) {
            return null;
        }
        assert (n == 1);
        Iterator<String> iterator = map.keySet().iterator();
        assert (iterator.hasNext());
        return iterator.next();
    }

    private static boolean isBehaviorEventAttribute(Attribute attribute, String string) {
        String[] stringArray = attribute.getEvents();
        return string != null && stringArray != null && stringArray.length > 0 && string.equals(stringArray[0]);
    }

    private static String getNonEmptyUserHandler(Object object) {
        String string = null;
        if (null != object) {
            string = object.toString();
            if ((string = string.trim()).length() == 0) {
                string = null;
            }
        }
        return string;
    }

    private static List<ClientBehavior> getClientBehaviors(UIComponent uIComponent, String string) {
        ClientBehaviorHolder clientBehaviorHolder;
        Map<String, List<ClientBehavior>> map;
        if (uIComponent instanceof ClientBehaviorHolder && null != (map = (clientBehaviorHolder = (ClientBehaviorHolder)((Object)uIComponent)).getClientBehaviors())) {
            return map.get(string);
        }
        return null;
    }

    private static String getSubmitHandler(FacesContext facesContext, UIComponent uIComponent, Collection<ClientBehaviorContext.Parameter> collection, String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(256);
        String string2 = RenderKitUtils.getFormClientId(uIComponent, facesContext);
        String string3 = uIComponent.getClientId(facesContext);
        stringBuilder.append("mojarra.jsfcljs(document.getElementById('");
        stringBuilder.append(string2);
        stringBuilder.append("'),{");
        RenderKitUtils.appendProperty(stringBuilder, string3, string3);
        if (null != collection && !collection.isEmpty()) {
            for (ClientBehaviorContext.Parameter parameter : collection) {
                RenderKitUtils.appendProperty(stringBuilder, parameter.getName(), parameter.getValue());
            }
        }
        stringBuilder.append("},'");
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append("')");
        if (bl) {
            stringBuilder.append(";return false");
        }
        return stringBuilder.toString();
    }

    private static String getChainedHandler(FacesContext facesContext, UIComponent uIComponent, List<ClientBehavior> list, Collection<ClientBehaviorContext.Parameter> collection, String string, String string2, String string3, boolean bl) {
        boolean bl2;
        StringBuilder stringBuilder = new StringBuilder(100);
        RenderKitUtils.appendScriptToChain(stringBuilder, string2);
        boolean bl3 = RenderKitUtils.appendBehaviorsToChain(stringBuilder, facesContext, uIComponent, list, string, collection);
        boolean bl4 = bl2 = null != collection && !collection.isEmpty();
        if (!bl3 && (bl2 || bl)) {
            String string4 = RenderKitUtils.getSubmitHandler(facesContext, uIComponent, collection, string3, false);
            RenderKitUtils.appendScriptToChain(stringBuilder, string4);
            bl3 = true;
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        stringBuilder.append(")");
        if (bl3 && ("action".equals(string) || "click".equals(string))) {
            stringBuilder.append(";return false");
        }
        return stringBuilder.toString();
    }

    private static String getSingleBehaviorHandler(FacesContext facesContext, UIComponent uIComponent, ClientBehavior clientBehavior, Collection<ClientBehaviorContext.Parameter> collection, String string, String string2, boolean bl) {
        boolean bl2;
        ClientBehaviorContext clientBehaviorContext = RenderKitUtils.createClientBehaviorContext(facesContext, uIComponent, string, collection);
        String string3 = clientBehavior.getScript(clientBehaviorContext);
        boolean bl3 = bl2 = !(!bl && !RenderKitUtils.isSubmitting(clientBehavior) || !(uIComponent instanceof ActionSource) && !(uIComponent instanceof ActionSource2));
        if (string3 == null) {
            if (bl) {
                string3 = RenderKitUtils.getSubmitHandler(facesContext, uIComponent, collection, string2, bl2);
            }
        } else if (bl2) {
            string3 = string3 + ";return false";
        }
        return string3;
    }

    private static ClientBehaviorContext createClientBehaviorContext(FacesContext facesContext, UIComponent uIComponent, String string, Collection<ClientBehaviorContext.Parameter> collection) {
        return ClientBehaviorContext.createClientBehaviorContext(facesContext, uIComponent, string, null, collection);
    }

    private static boolean isSubmitting(ClientBehavior clientBehavior) {
        return clientBehavior.getHints().contains((Object)ClientBehaviorHint.SUBMITTING);
    }

    private static void renderHandler(FacesContext facesContext, UIComponent uIComponent, Collection<ClientBehaviorContext.Parameter> collection, String string, Object object, String string2, String string3, boolean bl, boolean bl2) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        String string4 = RenderKitUtils.getNonEmptyUserHandler(object);
        List<ClientBehavior> list = RenderKitUtils.getClientBehaviors(uIComponent, string2);
        if (null != list && list.size() > 0 && Util.componentIsDisabled(uIComponent)) {
            list = null;
        }
        if (collection == null) {
            collection = Collections.emptyList();
        }
        String string5 = null;
        switch (RenderKitUtils.getHandlerType(list, collection, string4, bl, bl2)) {
            case USER_HANDLER_ONLY: {
                string5 = string4;
                break;
            }
            case SINGLE_BEHAVIOR_ONLY: {
                string5 = RenderKitUtils.getSingleBehaviorHandler(facesContext, uIComponent, list.get(0), collection, string2, string3, bl);
                break;
            }
            case SUBMIT_ONLY: {
                string5 = RenderKitUtils.getSubmitHandler(facesContext, uIComponent, collection, string3, true);
                break;
            }
            case CHAIN: {
                string5 = RenderKitUtils.getChainedHandler(facesContext, uIComponent, list, collection, string2, string4, string3, bl);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        responseWriter.writeAttribute(string, string5, null);
    }

    private static HandlerType getHandlerType(List<ClientBehavior> list, Collection<ClientBehaviorContext.Parameter> collection, String string, boolean bl, boolean bl2) {
        ClientBehavior clientBehavior;
        if (list == null || list.isEmpty()) {
            if (collection.isEmpty() && !bl || bl2) {
                return HandlerType.USER_HANDLER_ONLY;
            }
            return string == null ? HandlerType.SUBMIT_ONLY : HandlerType.CHAIN;
        }
        if (list.size() == 1 && string == null && (RenderKitUtils.isSubmitting(clientBehavior = list.get(0)) || collection.isEmpty() && !bl)) {
            return HandlerType.SINGLE_BEHAVIOR_ONLY;
        }
        return HandlerType.CHAIN;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum HandlerType {
        USER_HANDLER_ONLY,
        SINGLE_BEHAVIOR_ONLY,
        SUBMIT_ONLY,
        CHAIN;

    }
}

