/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.Timer;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Phase {
    private static final Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPhase(FacesContext facesContext, Lifecycle lifecycle, ListIterator<PhaseListener> listIterator) {
        Timer timer;
        facesContext.setCurrentPhaseId(this.getId());
        PhaseEvent phaseEvent = null;
        if (listIterator.hasNext()) {
            phaseEvent = new PhaseEvent(facesContext, this.getId(), lifecycle);
        }
        if ((timer = Timer.getInstance()) != null) {
            timer.startTiming();
        }
        try {
            this.handleBeforePhase(facesContext, listIterator, phaseEvent);
            if (!this.shouldSkip(facesContext)) {
                this.execute(facesContext);
            }
        }
        catch (Throwable throwable) {
            this.queueException(facesContext, throwable);
        }
        finally {
            try {
                this.handleAfterPhase(facesContext, listIterator, phaseEvent);
            }
            catch (Throwable throwable) {
                this.queueException(facesContext, throwable);
            }
            if (timer != null) {
                timer.stopTiming();
                timer.logResult("Execution time for phase (including any PhaseListeners) -> " + this.getId().toString());
            }
            facesContext.getExceptionHandler().handle();
        }
    }

    public abstract void execute(FacesContext var1) throws FacesException;

    public abstract PhaseId getId();

    protected void queueException(FacesContext facesContext, Throwable throwable) {
        this.queueException(facesContext, throwable, null);
    }

    protected void queueException(FacesContext facesContext, Throwable throwable, String string) {
        ExceptionQueuedEventContext exceptionQueuedEventContext = new ExceptionQueuedEventContext(facesContext, throwable);
        if (string != null) {
            exceptionQueuedEventContext.getAttributes().put(string, Boolean.TRUE);
        }
        facesContext.getApplication().publishEvent(facesContext, ExceptionQueuedEvent.class, exceptionQueuedEventContext);
    }

    protected void handleAfterPhase(FacesContext facesContext, ListIterator<PhaseListener> listIterator, PhaseEvent phaseEvent) {
        Object object;
        block5: {
            try {
                object = facesContext.getExternalContext().getFlash();
                ((Flash)object).doPostPhaseActions(facesContext);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (!LOGGER.isLoggable(Level.FINE)) break block5;
                LOGGER.fine("ExternalContext.getFlash() throw UnsupportedOperationException -> Flash unavailable");
            }
        }
        while (listIterator.hasPrevious()) {
            object = listIterator.previous();
            if (!this.getId().equals(object.getPhaseId()) && !PhaseId.ANY_PHASE.equals(object.getPhaseId())) continue;
            try {
                object.afterPhase(phaseEvent);
            }
            catch (Exception exception) {
                this.queueException(facesContext, exception, ExceptionQueuedEventContext.IN_AFTER_PHASE_KEY);
                return;
            }
        }
    }

    protected void handleBeforePhase(FacesContext facesContext, ListIterator<PhaseListener> listIterator, PhaseEvent phaseEvent) {
        Object object;
        block6: {
            try {
                object = facesContext.getExternalContext().getFlash();
                ((Flash)object).doPrePhaseActions(facesContext);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (!LOGGER.isLoggable(Level.FINE)) break block6;
                LOGGER.fine("ExternalContext.getFlash() throw UnsupportedOperationException -> Flash unavailable");
            }
        }
        RequestStateManager.clearAttributesForPhase(facesContext, facesContext.getCurrentPhaseId());
        while (listIterator.hasNext()) {
            object = listIterator.next();
            if (!this.getId().equals(object.getPhaseId()) && !PhaseId.ANY_PHASE.equals(object.getPhaseId())) continue;
            try {
                object.beforePhase(phaseEvent);
            }
            catch (Exception exception) {
                this.queueException(facesContext, exception, ExceptionQueuedEventContext.IN_BEFORE_PHASE_KEY);
                if (listIterator.hasPrevious()) {
                    listIterator.previous();
                }
                return;
            }
        }
    }

    private boolean shouldSkip(FacesContext facesContext) {
        if (facesContext.getResponseComplete()) {
            return true;
        }
        return facesContext.getRenderResponse() && !PhaseId.RENDER_RESPONSE.equals(this.getId());
    }
}

