/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.flow;

import com.sun.faces.facelets.util.ReflectionUtil;
import com.sun.faces.util.FacesLogger;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.flow.MethodCallNode;
import javax.faces.flow.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodCallNodeImpl
extends MethodCallNode
implements Serializable {
    private static final long serialVersionUID = -5400138716176841428L;
    private final String id;
    private static final Logger LOGGER = FacesLogger.FLOW.getLogger();
    private MethodExpression methodExpression;
    private ValueExpression outcome;
    private List<Parameter> _parameters;
    private List<Parameter> parameters;

    public MethodCallNodeImpl(String string) {
        this.id = string;
        this._parameters = new CopyOnWriteArrayList<Parameter>();
    }

    public MethodCallNodeImpl(FacesContext facesContext, String string, String string2, String string3, List<Parameter> list) {
        this(string);
        if (null != list) {
            this._parameters.addAll(list);
        }
        this.parameters = Collections.unmodifiableList(this._parameters);
        ExpressionFactory expressionFactory = facesContext.getApplication().getExpressionFactory();
        Class[] classArray = new Class[]{};
        if (0 < this.parameters.size()) {
            classArray = new Class[this.parameters.size()];
            int n = 0;
            for (Parameter parameter : this.parameters) {
                if (null != parameter.getName()) {
                    try {
                        classArray[n] = ReflectionUtil.forName(parameter.getName());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, "parameter " + parameter.getName() + "incorrect type", classNotFoundException);
                        }
                        classArray[n] = null;
                    }
                } else {
                    classArray[n] = String.class;
                }
                ++n;
            }
        }
        ELContext eLContext = facesContext.getELContext();
        this.methodExpression = expressionFactory.createMethodExpression(eLContext, string2, null, classArray);
        if (null != string3) {
            this.outcome = expressionFactory.createValueExpression(eLContext, string3, Object.class);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public List<Parameter> _getParameters() {
        if (null == this.parameters) {
            this.parameters = Collections.unmodifiableList(this._parameters);
        }
        return this._parameters;
    }

    @Override
    public MethodExpression getMethodExpression() {
        return this.methodExpression;
    }

    public void setMethodExpression(MethodExpression methodExpression) {
        this.methodExpression = methodExpression;
    }

    @Override
    public ValueExpression getOutcome() {
        return this.outcome;
    }

    public void setOutcome(ValueExpression valueExpression) {
        this.outcome = valueExpression;
    }
}

