/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.util;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.facelets.util.ResourceResolverProxy;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.Util;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.faces.view.facelets.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtil {
    private static final String[] PRIMITIVE_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};
    private static final Class[] PRIMITIVES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};

    private ReflectionUtil() {
    }

    public static Class forName(String string) throws ClassNotFoundException {
        if (null == string || "".equals(string)) {
            return null;
        }
        Class<?> clazz = ReflectionUtil.forNamePrimitive(string);
        if (clazz == null) {
            if (string.endsWith("[]")) {
                String string2 = string.substring(0, string.length() - 2);
                clazz = Class.forName(string2, false, Thread.currentThread().getContextClassLoader());
                clazz = Array.newInstance(clazz, 0).getClass();
            } else {
                clazz = Class.forName(string, false, Thread.currentThread().getContextClassLoader());
            }
        }
        return clazz;
    }

    protected static Class forNamePrimitive(String string) {
        int n;
        if (string.length() <= 8 && (n = Arrays.binarySearch(PRIMITIVE_NAMES, string)) >= 0) {
            return PRIMITIVES[n];
        }
        return null;
    }

    public static Class[] toTypeArray(String[] stringArray) throws ClassNotFoundException {
        if (stringArray == null) {
            return null;
        }
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = ReflectionUtil.forName(stringArray[i]);
        }
        return classArray;
    }

    public static String[] toTypeNameArray(Class[] classArray) {
        if (classArray == null) {
            return null;
        }
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        return stringArray;
    }

    protected static final String paramString(Class[] classArray) {
        if (classArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < classArray.length; ++i) {
                stringBuffer.append(classArray[i].getName()).append(", ");
            }
            if (stringBuffer.length() > 2) {
                stringBuffer.setLength(stringBuffer.length() - 2);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public static Object decorateInstance(Class clazz, Class clazz2, Object object) {
        Object object2 = null;
        try {
            Object object3;
            if (ReflectionUtil.isDevModeEnabled() && (object3 = clazz.getInterfaces()) != null) {
                for (Class<?> clazz3 : object3) {
                    if (!"groovy.lang.GroovyObject".equals(clazz3.getName())) continue;
                    object2 = ReflectionUtil.createScriptProxy(clazz2, clazz.getName(), object);
                    break;
                }
            }
            if (object2 == null && clazz2 != null && object != null && (object3 = ReflectionUtils.lookupConstructor(clazz, clazz2)) != null) {
                object2 = ((Constructor)object3).newInstance(object);
            }
            if (clazz != null && object2 == null) {
                object2 = clazz.newInstance();
            }
        }
        catch (Exception exception) {
            throw new ConfigurationException(ReflectionUtil.buildMessage(MessageFormat.format("Unable to create a new instance of ''{0}'': {1}", clazz.getName(), exception.toString())), exception);
        }
        return object2;
    }

    public static Object decorateInstance(String string, Class clazz, Object object) {
        Object object2 = null;
        if (string != null) {
            try {
                Class<?> clazz2 = ReflectionUtil.loadClass(string, object2, null);
                if (clazz2 != null) {
                    object2 = ReflectionUtil.decorateInstance(clazz2, clazz, object);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ConfigurationException(ReflectionUtil.buildMessage(MessageFormat.format("Unable to find class ''{0}''", string)));
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw new ConfigurationException(ReflectionUtil.buildMessage(MessageFormat.format("Class ''{0}'' is missing a runtime dependency: {1}", string, noClassDefFoundError.toString())));
            }
            catch (ClassCastException classCastException) {
                throw new ConfigurationException(ReflectionUtil.buildMessage(MessageFormat.format("Class ''{0}'' is not an instance of ''{1}''", string, clazz)));
            }
            catch (Exception exception) {
                throw new ConfigurationException(ReflectionUtil.buildMessage(MessageFormat.format("Unable to create a new instance of ''{0}'': {1}", string, exception.toString())), exception);
            }
        }
        return object2;
    }

    private static String buildMessage(String string) {
        return MessageFormat.format("\n  Source Document: {0}\n  Cause: {1}", "web.xml", string);
    }

    private static Class<?> loadClass(String string, Object object, Class<?> clazz) throws ClassNotFoundException {
        Class clazz2 = Util.loadClass(string, object);
        if (clazz != null && !clazz.isAssignableFrom(clazz2)) {
            throw new ClassCastException();
        }
        return clazz2;
    }

    private static boolean isDevModeEnabled() {
        WebConfiguration webConfiguration = WebConfiguration.getInstance();
        return webConfiguration != null && "Development".equals(webConfiguration.getOptionValue(WebConfiguration.WebContextInitParameter.JavaxFacesProjectStage));
    }

    private static Object createScriptProxy(Class<?> clazz, String string, Object object) {
        if (ResourceResolver.class.equals(clazz)) {
            return new ResourceResolverProxy(string, (ResourceResolver)object);
        }
        return null;
    }
}

