/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.util;

import java.io.IOException;
import java.io.Writer;

public final class FastWriter
extends Writer {
    private char[] buff;
    private int size;

    public FastWriter() {
        this(1024);
    }

    public FastWriter(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Initial Size cannot be less than 0");
        }
        this.buff = new char[n];
    }

    public void close() throws IOException {
    }

    public void flush() throws IOException {
    }

    private void overflow(int n) {
        if (this.size + n > this.buff.length) {
            char[] cArray = new char[(this.size + n) * 2];
            System.arraycopy(this.buff, 0, cArray, 0, this.size);
            this.buff = cArray;
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.overflow(n2);
        System.arraycopy(cArray, n, this.buff, this.size, n2);
        this.size += n2;
    }

    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    public void write(int n) throws IOException {
        this.overflow(1);
        this.buff[this.size] = (char)n;
        ++this.size;
    }

    public void write(String string, int n, int n2) throws IOException {
        this.write(string.toCharArray(), n, n2);
    }

    public void write(String string) throws IOException {
        this.write(string.toCharArray(), 0, string.length());
    }

    public void reset() {
        this.size = 0;
    }

    public String toString() {
        return new String(this.buff, 0, this.size);
    }
}

