/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.ui;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.facelets.el.VariableMapperWrapper;
import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.util.FacesLogger;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.VariableMapper;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;

public final class IncludeHandler
extends TagHandlerImpl {
    private static final Logger log = FacesLogger.FACELETS_INCLUDE.getLogger();
    private final TagAttribute src;

    public IncludeHandler(TagConfig tagConfig) {
        super(tagConfig);
        TagAttribute tagAttribute = null;
        tagAttribute = this.getAttribute("src");
        if (null == tagAttribute) {
            tagAttribute = this.getAttribute("file");
        }
        if (null == tagAttribute) {
            tagAttribute = this.getAttribute("page");
        }
        if (null == tagAttribute) {
            throw new TagException(this.tag, "Attribute 'src', 'file' or 'page' is required");
        }
        this.src = tagAttribute;
    }

    public void apply(FaceletContext faceletContext, UIComponent uIComponent) throws IOException {
        String string = this.src.getValue(faceletContext);
        if (string == null || string.length() == 0) {
            return;
        }
        VariableMapper variableMapper = faceletContext.getVariableMapper();
        faceletContext.setVariableMapper(new VariableMapperWrapper(variableMapper));
        try {
            this.nextHandler.apply(faceletContext, null);
            WebConfiguration webConfiguration = WebConfiguration.getInstance();
            if (string.startsWith(webConfiguration.getOptionValue(WebConfiguration.WebContextInitParameter.WebAppContractsDirectory))) {
                throw new TagAttributeException(this.tag, this.src, "Invalid src, contract resources cannot be accessed this way : " + string);
            }
            faceletContext.includeFacelet(uIComponent, string);
        }
        catch (IOException iOException) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, iOException.toString(), iOException);
            }
            throw new TagAttributeException(this.tag, this.src, "Invalid path : " + string);
        }
        finally {
            faceletContext.setVariableMapper(variableMapper);
        }
    }
}

