/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf.core;

import com.sun.faces.component.behavior.AjaxBehaviors;
import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.facelets.tag.jsf.CompositeComponentTagHandler;
import com.sun.faces.facelets.tag.jsf.core.AjaxBehaviorListenerImpl;
import com.sun.faces.renderkit.RenderKitUtils;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.view.AttachedObjectTarget;
import javax.faces.view.BehaviorHolderAttachedObjectHandler;
import javax.faces.view.BehaviorHolderAttachedObjectTarget;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.CompositeFaceletHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AjaxHandler
extends TagHandlerImpl
implements BehaviorHolderAttachedObjectHandler {
    private final TagAttribute event = this.getAttribute("event");
    private final TagAttribute execute = this.getAttribute("execute");
    private final TagAttribute render = this.getAttribute("render");
    private final TagAttribute onevent = this.getAttribute("onevent");
    private final TagAttribute onerror = this.getAttribute("onerror");
    private final TagAttribute disabled = this.getAttribute("disabled");
    private final TagAttribute immediate = this.getAttribute("immediate");
    private final TagAttribute resetValues = this.getAttribute("resetValues");
    private final TagAttribute listener = this.getAttribute("listener");
    private final TagAttribute delay = this.getAttribute("delay");
    private final boolean wrapping = this.isWrapping();

    public AjaxHandler(TagConfig tagConfig) {
        super(tagConfig);
    }

    @Override
    public void apply(FaceletContext faceletContext, UIComponent uIComponent) throws IOException {
        String string = this.getEventName();
        if (this.wrapping) {
            this.applyWrapping(faceletContext, uIComponent, string);
        } else {
            this.applyNested(faceletContext, uIComponent, string);
        }
    }

    @Override
    public void applyAttachedObject(FacesContext facesContext, UIComponent uIComponent) {
        FaceletContext faceletContext = (FaceletContext)((Object)facesContext.getAttributes().get("javax.faces.FACELET_CONTEXT"));
        this.applyAttachedObject(faceletContext, uIComponent, this.getEventName());
    }

    @Override
    public String getFor() {
        return null;
    }

    @Override
    public String getEventName() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        FaceletContext faceletContext = (FaceletContext)((Object)facesContext.getAttributes().get("javax.faces.FACELET_CONTEXT"));
        return this.event != null ? this.event.getValue(faceletContext) : null;
    }

    private boolean isWrapping() {
        return this.nextHandler instanceof TagHandler || this.nextHandler instanceof CompositeFaceletHandler;
    }

    private void applyWrapping(FaceletContext faceletContext, UIComponent uIComponent, String string) throws IOException {
        this.installAjaxResourceIfNecessary();
        AjaxBehavior ajaxBehavior = this.createAjaxBehavior(faceletContext, string);
        FacesContext facesContext = faceletContext.getFacesContext();
        AjaxBehaviors ajaxBehaviors = AjaxBehaviors.getAjaxBehaviors(facesContext, true);
        ajaxBehaviors.pushBehavior(facesContext, ajaxBehavior, string);
        this.nextHandler.apply(faceletContext, uIComponent);
        ajaxBehaviors.popBehavior();
    }

    private void applyNested(FaceletContext faceletContext, UIComponent uIComponent, String string) {
        if (!ComponentHandler.isNew(uIComponent)) {
            return;
        }
        if (UIComponent.isCompositeComponent(uIComponent)) {
            BeanInfo beanInfo;
            boolean bl = false;
            if (uIComponent instanceof ClientBehaviorHolder) {
                this.applyAttachedObject(faceletContext, uIComponent, string);
                bl = true;
            }
            if (null == (beanInfo = (BeanInfo)uIComponent.getAttributes().get("javax.faces.component.BEANINFO_KEY"))) {
                throw new TagException(this.tag, "Error: enclosing composite component does not have BeanInfo attribute");
            }
            BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
            if (null == beanDescriptor) {
                throw new TagException(this.tag, "Error: enclosing composite component BeanInfo does not have BeanDescriptor");
            }
            List list = (List)beanDescriptor.getValue("javax.faces.view.AttachedObjectTargets");
            if (null == list && !bl) {
                throw new TagException(this.tag, "Error: enclosing composite component does not support behavior events");
            }
            boolean bl2 = false;
            for (AttachedObjectTarget attachedObjectTarget : list) {
                if (!(attachedObjectTarget instanceof BehaviorHolderAttachedObjectTarget)) continue;
                BehaviorHolderAttachedObjectTarget behaviorHolderAttachedObjectTarget = (BehaviorHolderAttachedObjectTarget)attachedObjectTarget;
                if ((null == string || !string.equals(behaviorHolderAttachedObjectTarget.getName())) && (null != string || !behaviorHolderAttachedObjectTarget.isDefaultEvent())) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                CompositeComponentTagHandler.getAttachedObjectHandlers(uIComponent).add(this);
            } else if (!bl) {
                throw new TagException(this.tag, "Error: enclosing composite component does not support event " + string);
            }
        } else if (uIComponent instanceof ClientBehaviorHolder) {
            this.applyAttachedObject(faceletContext, uIComponent, string);
        } else {
            throw new TagException(this.tag, "Unable to attach <f:ajax> to non-ClientBehaviorHolder parent");
        }
    }

    private void applyAttachedObject(FaceletContext faceletContext, UIComponent uIComponent, String string) {
        Collection<String> collection;
        ClientBehaviorHolder clientBehaviorHolder = (ClientBehaviorHolder)((Object)uIComponent);
        if (null == string) {
            string = clientBehaviorHolder.getDefaultEventName();
            if (null == string) {
                throw new TagException(this.tag, "Event attribute could not be determined: " + string);
            }
        } else {
            collection = clientBehaviorHolder.getEventNames();
            if (!collection.contains(string)) {
                throw new TagException(this.tag, this.getUnsupportedEventMessage(string, collection, uIComponent));
            }
        }
        collection = this.createAjaxBehavior(faceletContext, string);
        clientBehaviorHolder.addClientBehavior(string, (ClientBehavior)((Object)collection));
        this.installAjaxResourceIfNecessary();
    }

    private AjaxBehavior createAjaxBehavior(FaceletContext faceletContext, String string) {
        Application application = faceletContext.getFacesContext().getApplication();
        AjaxBehavior ajaxBehavior = (AjaxBehavior)application.createBehavior("javax.faces.behavior.Ajax");
        this.setBehaviorAttribute(faceletContext, ajaxBehavior, this.onevent, String.class);
        this.setBehaviorAttribute(faceletContext, ajaxBehavior, this.onerror, String.class);
        this.setBehaviorAttribute(faceletContext, ajaxBehavior, this.disabled, Boolean.class);
        this.setBehaviorAttribute(faceletContext, ajaxBehavior, this.immediate, Boolean.class);
        this.setBehaviorAttribute(faceletContext, ajaxBehavior, this.resetValues, Boolean.class);
        this.setBehaviorAttribute(faceletContext, ajaxBehavior, this.execute, Object.class);
        this.setBehaviorAttribute(faceletContext, ajaxBehavior, this.render, Object.class);
        this.setBehaviorAttribute(faceletContext, ajaxBehavior, this.delay, String.class);
        if (null != this.listener) {
            ajaxBehavior.addAjaxBehaviorListener(new AjaxBehaviorListenerImpl(this.listener.getMethodExpression(faceletContext, Object.class, new Class[]{AjaxBehaviorEvent.class}), this.listener.getMethodExpression(faceletContext, Object.class, new Class[0])));
        }
        return ajaxBehavior;
    }

    private void setBehaviorAttribute(FaceletContext faceletContext, AjaxBehavior ajaxBehavior, TagAttribute tagAttribute, Class clazz) {
        if (tagAttribute != null) {
            ajaxBehavior.setValueExpression(tagAttribute.getLocalName(), tagAttribute.getValueExpression(faceletContext, clazz));
        }
    }

    private void installAjaxResourceIfNecessary() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (RenderKitUtils.hasScriptBeenRendered(facesContext)) {
            return;
        }
        if (RenderKitUtils.hasResourceBeenInstalled(facesContext, "jsf.js", "javax.faces")) {
            RenderKitUtils.setScriptAsRendered(facesContext);
            return;
        }
        UIOutput uIOutput = new UIOutput();
        uIOutput.setRendererType("javax.faces.resource.Script");
        uIOutput.getAttributes().put("name", "jsf.js");
        uIOutput.getAttributes().put("library", "javax.faces");
        facesContext.getViewRoot().addComponentResource(facesContext, uIOutput, "head");
        RenderKitUtils.setScriptAsRendered(facesContext);
    }

    private String getUnsupportedEventMessage(String string, Collection<String> collection, UIComponent uIComponent) {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("'");
        stringBuilder.append(string);
        stringBuilder.append("' is not a supported event for ");
        stringBuilder.append(uIComponent.getClass().getSimpleName());
        stringBuilder.append(".  Please specify one of these supported event names: ");
        TreeSet<String> treeSet = new TreeSet<String>(collection);
        Iterator iterator = treeSet.iterator();
        boolean bl = iterator.hasNext();
        while (bl) {
            stringBuilder.append((String)iterator.next());
            bl = iterator.hasNext();
            if (!bl) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(".");
        return stringBuilder.toString();
    }
}

