/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.composite;

import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.facelets.tag.composite.RelocateListener;
import com.sun.faces.util.FacesLogger;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.view.Location;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;

public class InsertFacetHandler
extends TagHandlerImpl {
    private final Logger LOGGER = FacesLogger.TAGLIB.getLogger();
    private static final String NAME_ATTRIBUTE = "name";
    private static final String REQUIRED_ATTRIBUTE = "required";
    private TagAttribute name = this.getRequiredAttribute("name");
    private TagAttribute required = this.getAttribute("required");

    public InsertFacetHandler(TagConfig tagConfig) {
        super(tagConfig);
    }

    public void apply(FaceletContext faceletContext, UIComponent uIComponent) throws IOException {
        UIComponent uIComponent2 = UIComponent.getCurrentCompositeComponent(faceletContext.getFacesContext());
        if (uIComponent2 != null) {
            uIComponent2.subscribeToEvent(PostAddToViewEvent.class, new RelocateFacetListener(faceletContext, uIComponent, this.tag.getLocation()));
        }
    }

    private class RelocateFacetListener
    extends RelocateListener {
        private FaceletContext ctx;
        private UIComponent component;
        private Location location;

        RelocateFacetListener(FaceletContext faceletContext, UIComponent uIComponent, Location location) {
            this.ctx = faceletContext;
            this.component = uIComponent;
            this.location = location;
        }

        public void processEvent(ComponentSystemEvent componentSystemEvent) throws AbortProcessingException {
            Map<String, UIComponent> map;
            UIComponent uIComponent;
            UIComponent uIComponent2 = componentSystemEvent.getComponent();
            if (uIComponent2 == null) {
                return;
            }
            Resource resource = this.getBackingResource(uIComponent2);
            while (uIComponent2 != null && !this.resourcesMatch(resource, this.location)) {
                if ((uIComponent2 = UIComponent.getCompositeComponentParent(uIComponent2)) == null) continue;
                resource = this.getBackingResource(uIComponent2);
            }
            if (uIComponent2 == null) {
                if (InsertFacetHandler.this.LOGGER.isLoggable(Level.WARNING)) {
                    InsertFacetHandler.this.LOGGER.log(Level.WARNING, "jsf.composite.component.insertfacet.missing.template", this.location.toString());
                }
                return;
            }
            boolean bl = this.isRequired();
            String string = InsertFacetHandler.this.name.getValue(this.ctx);
            if (uIComponent2.getFacetCount() == 0 && bl) {
                this.throwRequiredException(this.ctx, string, uIComponent2);
            }
            if ((uIComponent = (map = uIComponent2.getFacets()).remove(string)) == null) {
                uIComponent = uIComponent2.getParent().getFacets().remove(string);
            }
            if (uIComponent != null) {
                this.component.getFacets().put(string, uIComponent);
                String string2 = (String)uIComponent.getAttributes().get("com.sun.faces.facelets.MARK_ID");
                String string3 = this.component.getId();
                if (string2 != null && string3 != null) {
                    uIComponent2.getAttributes().put(string2, string3);
                }
            } else if (bl && this.component.getFacets().get(string) == null) {
                this.throwRequiredException(this.ctx, string, uIComponent2);
            }
        }

        private void throwRequiredException(FaceletContext faceletContext, String string, UIComponent uIComponent) {
            throw new TagException(InsertFacetHandler.this.tag, "Unable to find facet named '" + string + "' in parent composite component with id '" + uIComponent.getClientId(faceletContext.getFacesContext()) + '\'');
        }

        private boolean isRequired() {
            return InsertFacetHandler.this.required != null && InsertFacetHandler.this.required.getBoolean(this.ctx);
        }
    }
}

