/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag;

import com.sun.faces.facelets.tag.BeanPropertyTagRule;
import com.sun.faces.facelets.tag.MetadataImpl;
import com.sun.faces.facelets.tag.MetadataTargetImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.beans.IntrospectionException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaRulesetImpl
extends MetaRuleset {
    private static final Logger LOGGER = FacesLogger.FACELETS_META.getLogger();
    private static final Map<Class, WeakReference<MetadataTarget>> metadata = Collections.synchronizedMap(new WeakHashMap());
    private final Tag tag;
    private final Class type;
    private final Map<String, TagAttribute> attributes;
    private final List<Metadata> mappers;
    private final List<MetaRule> rules;
    private static final Metadata NONE = new Metadata(){

        public void applyMetadata(FaceletContext faceletContext, Object object) {
        }
    };

    public MetaRulesetImpl(Tag tag, Class<?> clazz) {
        this.tag = tag;
        this.type = clazz;
        this.attributes = new HashMap<String, TagAttribute>();
        this.mappers = new ArrayList<Metadata>();
        this.rules = new ArrayList<MetaRule>();
        TagAttribute[] tagAttributeArray = this.tag.getAttributes().getAll();
        for (int i = 0; i < tagAttributeArray.length; ++i) {
            if (tagAttributeArray[i].getLocalName().equals("class")) {
                this.attributes.put("styleClass", tagAttributeArray[i]);
                continue;
            }
            this.attributes.put(tagAttributeArray[i].getLocalName(), tagAttributeArray[i]);
        }
        this.rules.add(BeanPropertyTagRule.Instance);
    }

    @Override
    public MetaRuleset ignore(String string) {
        Util.notNull("attribute", string);
        this.attributes.remove(string);
        return this;
    }

    @Override
    public MetaRuleset alias(String string, String string2) {
        Util.notNull("attribute", string);
        Util.notNull("property", string2);
        TagAttribute tagAttribute = this.attributes.remove(string);
        if (tagAttribute != null) {
            this.attributes.put(string2, tagAttribute);
        }
        return this;
    }

    @Override
    public MetaRuleset add(Metadata metadata) {
        Util.notNull("mapper", metadata);
        if (!this.mappers.contains(metadata)) {
            this.mappers.add(metadata);
        }
        return this;
    }

    @Override
    public MetaRuleset addRule(MetaRule metaRule) {
        Util.notNull("rule", metaRule);
        this.rules.add(metaRule);
        return this;
    }

    @Override
    public Metadata finish() {
        if (!this.attributes.isEmpty()) {
            if (this.rules.isEmpty()) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    Iterator<TagAttribute> iterator = this.attributes.values().iterator();
                    while (iterator.hasNext()) {
                        LOGGER.severe(iterator.next() + " Unhandled by MetaTagHandler for type " + this.type.getName());
                    }
                }
            } else {
                MetadataTarget metadataTarget = this.getMetadataTarget();
                int n = this.rules.size() - 1;
                for (Map.Entry<String, TagAttribute> entry : this.attributes.entrySet()) {
                    Metadata metadata = null;
                    for (int i = n; metadata == null && i >= 0; --i) {
                        MetaRule metaRule = this.rules.get(i);
                        metadata = metaRule.applyRule(entry.getKey(), entry.getValue(), metadataTarget);
                    }
                    if (metadata == null) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                        LOGGER.severe(entry.getValue() + " Unhandled by MetaTagHandler for type " + this.type.getName());
                        continue;
                    }
                    this.mappers.add(metadata);
                }
            }
        }
        if (this.mappers.isEmpty()) {
            return NONE;
        }
        return new MetadataImpl(this.mappers.toArray(new Metadata[this.mappers.size()]));
    }

    @Override
    public MetaRuleset ignoreAll() {
        this.attributes.clear();
        return this;
    }

    protected MetadataTarget getMetadataTarget() {
        MetadataTarget metadataTarget;
        WeakReference<MetadataTarget> weakReference = metadata.get(this.type);
        MetadataTarget metadataTarget2 = metadataTarget = weakReference == null ? null : (MetadataTarget)weakReference.get();
        if (metadataTarget == null) {
            try {
                metadataTarget = new MetadataTargetImpl(this.type);
            }
            catch (IntrospectionException introspectionException) {
                throw new TagException(this.tag, "Error Creating TargetMetadata", introspectionException);
            }
            metadata.put(this.type, new WeakReference<MetadataTarget>(metadataTarget));
        }
        return metadataTarget;
    }
}

