/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.impl;

import com.sun.faces.facelets.FaceletContextImplBase;
import com.sun.faces.facelets.TemplateClient;
import com.sun.faces.facelets.el.DefaultVariableMapper;
import com.sun.faces.facelets.impl.DefaultFacelet;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.Facelet;
import javax.faces.view.facelets.FaceletContext;

final class DefaultFaceletContext
extends FaceletContextImplBase {
    private final FacesContext faces;
    private final ELContext ctx;
    private final DefaultFacelet facelet;
    private final List<Facelet> faceletHierarchy;
    private VariableMapper varMapper;
    private FunctionMapper fnMapper;
    private final Map<String, Integer> ids;
    private final Map<Integer, Integer> prefixes;
    private String prefix;
    private final StringBuilder uniqueIdBuilder = new StringBuilder(30);
    private final List<TemplateManager> clients;

    public DefaultFaceletContext(DefaultFaceletContext defaultFaceletContext, DefaultFacelet defaultFacelet) {
        this.ctx = defaultFaceletContext.ctx;
        this.clients = defaultFaceletContext.clients;
        this.faces = defaultFaceletContext.faces;
        this.fnMapper = defaultFaceletContext.fnMapper;
        this.ids = defaultFaceletContext.ids;
        this.prefixes = defaultFaceletContext.prefixes;
        this.varMapper = defaultFaceletContext.varMapper;
        this.faceletHierarchy = new ArrayList<Facelet>(defaultFaceletContext.faceletHierarchy.size() + 1);
        this.faceletHierarchy.addAll(defaultFaceletContext.faceletHierarchy);
        this.faceletHierarchy.add(defaultFacelet);
        this.facelet = defaultFacelet;
        this.faces.getAttributes().put("javax.faces.FACELET_CONTEXT", (Object)this);
    }

    public DefaultFaceletContext(FacesContext facesContext, DefaultFacelet defaultFacelet) {
        this.ctx = facesContext.getELContext();
        this.ids = new HashMap<String, Integer>();
        this.prefixes = new HashMap<Integer, Integer>();
        this.clients = new ArrayList<TemplateManager>(5);
        this.faces = facesContext;
        this.faceletHierarchy = new ArrayList<Facelet>(1);
        this.faceletHierarchy.add(defaultFacelet);
        this.facelet = defaultFacelet;
        this.varMapper = this.ctx.getVariableMapper();
        if (this.varMapper == null) {
            this.varMapper = new DefaultVariableMapper();
        }
        this.fnMapper = this.ctx.getFunctionMapper();
        this.faces.getAttributes().put("javax.faces.FACELET_CONTEXT", (Object)this);
    }

    public FacesContext getFacesContext() {
        return this.faces;
    }

    public ExpressionFactory getExpressionFactory() {
        return this.facelet.getExpressionFactory();
    }

    public void setVariableMapper(VariableMapper variableMapper) {
        this.varMapper = variableMapper;
    }

    public void setFunctionMapper(FunctionMapper functionMapper) {
        this.fnMapper = functionMapper;
    }

    public void includeFacelet(UIComponent uIComponent, String string) throws IOException, FacesException, ELException {
        this.facelet.include(this, uIComponent, string);
    }

    public FunctionMapper getFunctionMapper() {
        return this.fnMapper;
    }

    public VariableMapper getVariableMapper() {
        return this.varMapper;
    }

    public Object getContext(Class clazz) {
        return this.ctx.getContext(clazz);
    }

    public void putContext(Class clazz, Object object) {
        this.ctx.putContext(clazz, object);
    }

    public String generateUniqueId(String string) {
        Comparable<Integer> comparable;
        if (this.prefix == null) {
            Object object;
            comparable = new StringBuilder(this.faceletHierarchy.size() * 30);
            for (int i = 0; i < this.faceletHierarchy.size(); ++i) {
                object = (DefaultFacelet)this.faceletHierarchy.get(i);
                ((StringBuilder)comparable).append(((DefaultFacelet)object).getAlias());
            }
            Integer n = ((StringBuilder)comparable).toString().hashCode();
            object = this.prefixes.get(n);
            if (object == null) {
                this.prefixes.put(n, 0);
                this.prefix = n.toString();
            } else {
                int n2 = (Integer)object + 1;
                this.prefixes.put(n, n2);
                this.prefix = n + "_" + n2;
            }
        }
        if ((comparable = this.ids.get(string)) == null) {
            this.ids.put(string, 0);
            this.uniqueIdBuilder.delete(0, this.uniqueIdBuilder.length());
            this.uniqueIdBuilder.append(this.prefix);
            this.uniqueIdBuilder.append("_");
            this.uniqueIdBuilder.append(string);
            return this.uniqueIdBuilder.toString();
        }
        int n = (Integer)comparable + 1;
        this.ids.put(string, n);
        this.uniqueIdBuilder.delete(0, this.uniqueIdBuilder.length());
        this.uniqueIdBuilder.append(this.prefix);
        this.uniqueIdBuilder.append("_");
        this.uniqueIdBuilder.append(string);
        this.uniqueIdBuilder.append("_");
        this.uniqueIdBuilder.append(n);
        return this.uniqueIdBuilder.toString();
    }

    public Object getAttribute(String string) {
        ValueExpression valueExpression;
        if (this.varMapper != null && (valueExpression = this.varMapper.resolveVariable(string)) != null) {
            return valueExpression.getValue((ELContext)this);
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        if (this.varMapper != null) {
            if (object == null) {
                this.varMapper.setVariable(string, null);
            } else {
                this.varMapper.setVariable(string, this.facelet.getExpressionFactory().createValueExpression(object, Object.class));
            }
        }
    }

    public void includeFacelet(UIComponent uIComponent, URL uRL) throws IOException, FacesException, ELException {
        this.facelet.include(this, uIComponent, uRL);
    }

    public ELResolver getELResolver() {
        return this.ctx.getELResolver();
    }

    public void popClient(TemplateClient templateClient) {
        if (!this.clients.isEmpty()) {
            Iterator<TemplateManager> iterator = this.clients.iterator();
            while (iterator.hasNext()) {
                if (!((Object)iterator.next()).equals(templateClient)) continue;
                iterator.remove();
                return;
            }
        }
        throw new IllegalStateException(templateClient + " not found");
    }

    public void pushClient(TemplateClient templateClient) {
        this.clients.add(0, new TemplateManager(this.facelet, templateClient, true));
    }

    public void extendClient(TemplateClient templateClient) {
        this.clients.add(new TemplateManager(this.facelet, templateClient, false));
    }

    public boolean includeDefinition(UIComponent uIComponent, String string) throws IOException {
        boolean bl = false;
        int n = this.clients.size();
        for (int i = 0; i < n && !bl; ++i) {
            TemplateManager templateManager = this.clients.get(i);
            if (templateManager.equals(this.facelet)) continue;
            bl = templateManager.apply(this, uIComponent, string);
        }
        return bl;
    }

    public boolean isPropertyResolved() {
        return this.ctx.isPropertyResolved();
    }

    public void setPropertyResolved(boolean bl) {
        this.ctx.setPropertyResolved(bl);
    }

    private static final class TemplateManager
    implements TemplateClient {
        private final DefaultFacelet owner;
        private final TemplateClient target;
        private final boolean root;
        private final Set<String> names = new HashSet<String>();

        public TemplateManager(DefaultFacelet defaultFacelet, TemplateClient templateClient, boolean bl) {
            this.owner = defaultFacelet;
            this.target = templateClient;
            this.root = bl;
        }

        public boolean apply(FaceletContext faceletContext, UIComponent uIComponent, String string) throws IOException {
            String string2;
            String string3 = string2 = string != null ? string : "facelets._NULL_DEF_";
            if (this.names.contains(string2)) {
                return false;
            }
            this.names.add(string2);
            boolean bl = this.target.apply(new DefaultFaceletContext((DefaultFaceletContext)faceletContext, this.owner), uIComponent, string);
            this.names.remove(string2);
            return bl;
        }

        public boolean equals(Object object) {
            return this.owner == object || this.target == object;
        }

        public boolean isRoot() {
            return this.root;
        }
    }
}

