/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.impl;

import com.sun.faces.facelets.impl.DefaultFaceletContext;
import com.sun.faces.facelets.impl.DefaultFaceletFactory;
import com.sun.faces.facelets.impl.IdMapper;
import com.sun.faces.facelets.impl.XMLFrontMatterSaver;
import com.sun.faces.facelets.tag.jsf.ComponentSupport;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ExpressionFactory;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.Facelet;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;

final class DefaultFacelet
extends Facelet
implements XMLFrontMatterSaver {
    private static final Logger log = FacesLogger.FACELETS_FACELET.getLogger();
    private static final String APPLIED_KEY = "com.sun.faces.facelets.APPLIED";
    private static final String JAVAX_FACES_ERROR_XHTML = "javax.faces.error.xhtml";
    private final String alias;
    private final ExpressionFactory elFactory;
    private final DefaultFaceletFactory factory;
    private final long createTime;
    private final long refreshPeriod;
    private final FaceletHandler root;
    private final URL src;
    private IdMapper mapper;
    private String savedDoctype;
    private String savedXMLDecl;

    public DefaultFacelet(DefaultFaceletFactory defaultFaceletFactory, ExpressionFactory expressionFactory, URL uRL, String string, FaceletHandler faceletHandler) {
        String string2;
        this.factory = defaultFaceletFactory;
        this.elFactory = expressionFactory;
        this.src = uRL;
        this.root = faceletHandler;
        this.alias = string;
        this.mapper = defaultFaceletFactory.idMappers.get(string);
        this.createTime = System.currentTimeMillis();
        this.refreshPeriod = this.factory.getRefreshPeriod();
        String string3 = Util.getDOCTYPEFromFacesContextAttributes(FacesContext.getCurrentInstance());
        if (null != string3) {
            this.setSavedDoctype(string3);
        }
        if (null != (string2 = Util.getXMLDECLFromFacesContextAttributes(FacesContext.getCurrentInstance()))) {
            this.setSavedXMLDecl(string2);
        }
    }

    public void apply(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        IdMapper idMapper = IdMapper.getMapper(facesContext);
        boolean bl = false;
        if (idMapper == null) {
            IdMapper.setMapper(facesContext, this.mapper);
            bl = true;
        }
        DefaultFaceletContext defaultFaceletContext = new DefaultFaceletContext(facesContext, this);
        this.refresh(uIComponent);
        ComponentSupport.markForDeletion(uIComponent);
        this.root.apply(defaultFaceletContext, uIComponent);
        ComponentSupport.finalizeForDeletion(uIComponent);
        this.markApplied(uIComponent);
        if (bl) {
            IdMapper.setMapper(facesContext, null);
        }
    }

    private void refresh(UIComponent uIComponent) {
        if (this.refreshPeriod > 0L) {
            Object object;
            Object object2;
            Object object3;
            Collection<UIComponent> collection;
            int n = uIComponent.getChildCount();
            if (n > 0) {
                collection = uIComponent.getChildren();
                while (--n >= 0) {
                    object3 = collection.get(n);
                    if (object3.isTransient() || (object2 = (ApplyToken)((UIComponent)object3).getAttributes().get(APPLIED_KEY)) == null || ((ApplyToken)object2).time >= this.createTime || !((ApplyToken)object2).alias.equals(this.alias)) continue;
                    if (log.isLoggable(Level.INFO)) {
                        object = SimpleDateFormat.getTimeInstance();
                        log.info("Facelet[" + this.alias + "] was modified @ " + ((DateFormat)object).format(new Date(this.createTime)) + ", flushing component applied @ " + ((DateFormat)object).format(new Date(((ApplyToken)object2).time)));
                    }
                    collection.remove(n);
                }
            }
            if (uIComponent.getFacets().size() > 0) {
                collection = uIComponent.getFacets().values();
                object = collection.iterator();
                while (object.hasNext()) {
                    object2 = object.next();
                    if (object2.isTransient() || (object3 = (ApplyToken)((UIComponent)object2).getAttributes().get(APPLIED_KEY)) == null || ((ApplyToken)object3).time >= this.createTime || !((ApplyToken)object3).alias.equals(this.alias)) continue;
                    if (log.isLoggable(Level.INFO)) {
                        DateFormat dateFormat = SimpleDateFormat.getTimeInstance();
                        log.info("Facelet[" + this.alias + "] was modified @ " + dateFormat.format(new Date(this.createTime)) + ", flushing component applied @ " + dateFormat.format(new Date(((ApplyToken)object3).time)));
                    }
                    object.remove();
                }
            }
        }
    }

    private void markApplied(UIComponent uIComponent) {
        if (this.refreshPeriod > 0L) {
            Iterator<UIComponent> iterator = uIComponent.getFacetsAndChildren();
            ApplyToken applyToken = new ApplyToken(this.alias, System.currentTimeMillis() + this.refreshPeriod);
            while (iterator.hasNext()) {
                Map<String, Object> map;
                UIComponent uIComponent2 = iterator.next();
                if (uIComponent2.isTransient() || (map = uIComponent2.getAttributes()).containsKey(APPLIED_KEY)) continue;
                map.put(APPLIED_KEY, applyToken);
            }
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public ExpressionFactory getExpressionFactory() {
        return this.elFactory;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    private URL getRelativePath(String string) throws IOException {
        return this.factory.resolveURL(this.src, string);
    }

    public URL getSource() {
        return this.src;
    }

    private void include(DefaultFaceletContext defaultFaceletContext, UIComponent uIComponent) throws IOException {
        this.refresh(uIComponent);
        this.root.apply(new DefaultFaceletContext(defaultFaceletContext, this), uIComponent);
        this.markApplied(uIComponent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void include(DefaultFaceletContext defaultFaceletContext, UIComponent uIComponent, String string) throws IOException {
        URL uRL;
        if (string.equals(JAVAX_FACES_ERROR_XHTML)) {
            if (!this.isDevelopment(defaultFaceletContext)) return;
            uRL = this.getErrorFacelet(DefaultFacelet.class.getClassLoader());
            if (uRL == null) {
                uRL = this.getErrorFacelet(Util.getCurrentLoader(this));
            }
        } else {
            uRL = this.getRelativePath(string);
        }
        this.include(defaultFaceletContext, uIComponent, uRL);
    }

    public void include(DefaultFaceletContext defaultFaceletContext, UIComponent uIComponent, URL uRL) throws IOException {
        DefaultFacelet defaultFacelet = (DefaultFacelet)this.factory.getFacelet(defaultFaceletContext.getFacesContext(), uRL);
        defaultFacelet.include(defaultFaceletContext, uIComponent);
    }

    public String toString() {
        return this.alias;
    }

    public String getSavedDoctype() {
        return this.savedDoctype;
    }

    public void setSavedDoctype(String string) {
        this.savedDoctype = string;
    }

    public String getSavedXMLDecl() {
        return this.savedXMLDecl;
    }

    public void setSavedXMLDecl(String string) {
        this.savedXMLDecl = string;
    }

    private boolean isDevelopment(FaceletContext faceletContext) {
        return faceletContext.getFacesContext().isProjectStage(ProjectStage.Development);
    }

    private URL getErrorFacelet(ClassLoader classLoader) {
        return classLoader.getResource("META-INF/error-include.xhtml");
    }

    private static class ApplyToken
    implements Externalizable {
        public String alias;
        public long time;

        public ApplyToken() {
        }

        public ApplyToken(String string, long l) {
            this.alias = string;
            this.time = l;
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.alias = objectInput.readUTF();
            this.time = objectInput.readLong();
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeUTF(this.alias);
            objectOutput.writeLong(this.time);
        }
    }
}

