/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.el;

import com.sun.faces.component.CompositeComponentStackManager;
import com.sun.faces.facelets.el.ContextualCompositeValueExpression;
import com.sun.faces.facelets.el.TagValueExpression;
import com.sun.faces.util.FacesLogger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.validator.ValidatorException;
import javax.faces.view.Location;

public class ContextualCompositeMethodExpression
extends MethodExpression {
    private static final long serialVersionUID = -6281398928485392830L;
    private static final Logger LOGGER = FacesLogger.FACELETS_EL.getLogger();
    private final MethodExpression delegate;
    private final ValueExpression source;
    private final Location location;
    private String ccClientId;

    public ContextualCompositeMethodExpression(ValueExpression valueExpression, MethodExpression methodExpression) {
        this.delegate = methodExpression;
        this.source = valueExpression;
        this.location = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIComponent uIComponent = UIComponent.getCurrentCompositeComponent(facesContext);
        uIComponent.subscribeToEvent(PostAddToViewEvent.class, new SetClientIdListener(this));
    }

    public ContextualCompositeMethodExpression(Location location, MethodExpression methodExpression) {
        this.delegate = methodExpression;
        this.location = location;
        this.source = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIComponent uIComponent = UIComponent.getCurrentCompositeComponent(facesContext);
        uIComponent.subscribeToEvent(PostAddToViewEvent.class, new SetClientIdListener(this));
    }

    public MethodInfo getMethodInfo(ELContext eLContext) {
        return this.delegate.getMethodInfo(eLContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(ELContext eLContext, Object[] objectArray) {
        FacesContext facesContext = (FacesContext)eLContext.getContext(FacesContext.class);
        boolean bl = this.pushCompositeComponent(facesContext);
        try {
            Object object = this.delegate.invoke(eLContext, objectArray);
            if (bl) {
                this.popCompositeComponent(facesContext);
            }
            return object;
        }
        catch (Throwable throwable) {
            try {
                if (bl) {
                    this.popCompositeComponent(facesContext);
                }
                throw throwable;
            }
            catch (ELException eLException) {
                block14: {
                    if (eLException.getCause() != null && eLException.getCause() instanceof ValidatorException) {
                        throw (ValidatorException)eLException.getCause();
                    }
                    if (this.source != null && eLException instanceof MethodNotFoundException) {
                        try {
                            Object object = this.source.getValue(eLContext);
                            if (object != null && object instanceof MethodExpression) {
                                return ((MethodExpression)object).invoke(eLContext, objectArray);
                            }
                        }
                        catch (ELException eLException2) {
                            if (eLException2.getCause() != null && eLException2.getCause() instanceof ValidatorException) {
                                throw (ValidatorException)eLException2.getCause();
                            }
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, eLException.toString());
                                LOGGER.log(Level.WARNING, "jsf.facelets.el.method.expression.invoke.error: {0} {1}", new Object[]{eLException2.toString(), this.source.getExpressionString()});
                            }
                            if (eLException2 instanceof MethodNotFoundException) break block14;
                            throw eLException2;
                        }
                    }
                }
                throw eLException;
            }
        }
    }

    public String getExpressionString() {
        return this.delegate.getExpressionString();
    }

    public boolean equals(Object object) {
        return this.delegate.equals(object);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean isLiteralText() {
        return this.delegate.isLiteralText();
    }

    private boolean pushCompositeComponent(FacesContext facesContext) {
        ValueExpression valueExpression;
        CompositeComponentStackManager compositeComponentStackManager = CompositeComponentStackManager.getManager(facesContext);
        UIComponent uIComponent = null;
        if (this.location != null) {
            uIComponent = compositeComponentStackManager.findCompositeComponentUsingLocation(facesContext, this.location);
        } else if (this.source instanceof TagValueExpression && (valueExpression = ((TagValueExpression)this.source).getWrapped()) instanceof ContextualCompositeValueExpression) {
            uIComponent = compositeComponentStackManager.findCompositeComponentUsingLocation(facesContext, ((ContextualCompositeValueExpression)valueExpression).getLocation());
        }
        if (null == uIComponent) {
            uIComponent = facesContext.getViewRoot().findComponent(this.ccClientId);
        }
        return compositeComponentStackManager.push(uIComponent);
    }

    private void popCompositeComponent(FacesContext facesContext) {
        CompositeComponentStackManager compositeComponentStackManager = CompositeComponentStackManager.getManager(facesContext);
        compositeComponentStackManager.pop();
    }

    private class SetClientIdListener
    implements ComponentSystemEventListener {
        private ContextualCompositeMethodExpression ccME;

        public SetClientIdListener() {
        }

        public SetClientIdListener(ContextualCompositeMethodExpression contextualCompositeMethodExpression2) {
            this.ccME = contextualCompositeMethodExpression2;
        }

        public void processEvent(ComponentSystemEvent componentSystemEvent) throws AbortProcessingException {
            this.ccME.ccClientId = componentSystemEvent.getComponent().getClientId();
            componentSystemEvent.getComponent().unsubscribeFromEvent(PostAddToViewEvent.class, this);
        }
    }
}

