/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.compiler;

import com.sun.faces.config.FaceletsConfiguration;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.facelets.compiler.CompilationManager;
import com.sun.faces.facelets.compiler.Compiler;
import com.sun.faces.facelets.compiler.EncodingHandler;
import com.sun.faces.facelets.tag.TagAttributeImpl;
import com.sun.faces.facelets.tag.TagAttributesImpl;
import com.sun.faces.util.Util;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.view.Location;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class SAXCompiler
extends Compiler {
    private static final Pattern XmlDeclaration = Pattern.compile("^<\\?xml.+?version=['\"](.+?)['\"](.+?encoding=['\"]((.+?))['\"])?.*?\\?>");

    public FaceletHandler doCompile(URL uRL, String string) throws IOException {
        CompilationManager compilationManager = new CompilationManager(string, this);
        CompilationHandler compilationHandler = new CompilationHandler(compilationManager, string);
        return this.doCompile(compilationManager, compilationHandler, uRL, string);
    }

    public FaceletHandler doMetadataCompile(URL uRL, String string) throws IOException {
        CompilationManager compilationManager = new CompilationManager("metadata/" + string, this);
        MetadataCompilationHandler metadataCompilationHandler = new MetadataCompilationHandler(compilationManager, string);
        return this.doCompile(compilationManager, metadataCompilationHandler, uRL, string);
    }

    protected FaceletHandler doCompile(CompilationManager compilationManager, CompilationHandler compilationHandler, URL uRL, String string) throws IOException {
        Object object;
        InputStream inputStream = null;
        String string2 = this.getEncoding();
        try {
            inputStream = new BufferedInputStream(uRL.openStream(), 1024);
            SAXCompiler.writeXmlDecl(inputStream, string2, compilationManager);
            object = this.createSAXParser(compilationHandler);
            ((SAXParser)object).parse(inputStream, (DefaultHandler)compilationHandler);
        }
        catch (SAXException sAXException) {
            throw new FaceletException("Error Parsing " + string + ": " + sAXException.getMessage(), sAXException.getCause());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new FaceletException("Error Configuring Parser " + string + ": " + parserConfigurationException.getMessage(), parserConfigurationException.getCause());
        }
        catch (FaceletException faceletException) {
            throw faceletException;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        object = new EncodingHandler(compilationManager.createFaceletHandler(), string2, compilationManager.getCompilationMessageHolder());
        compilationManager.setCompilationMessageHolder(null);
        return object;
    }

    private String getEncoding() {
        String string = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (null != facesContext) {
            ExternalContext externalContext = facesContext.getExternalContext();
            string = externalContext.getRequestCharacterEncoding();
        }
        String string2 = null != string ? string : "UTF-8";
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeXmlDecl(InputStream inputStream, String string, CompilationManager compilationManager) throws IOException {
        inputStream.mark(128);
        try {
            WebConfiguration webConfiguration;
            FaceletsConfiguration faceletsConfiguration;
            boolean bl;
            String string2;
            Matcher matcher;
            byte[] byArray = new byte[128];
            if (inputStream.read(byArray) > 0 && (matcher = XmlDeclaration.matcher(string2 = new String(byArray, string))).find() && (bl = (faceletsConfiguration = (webConfiguration = compilationManager.getWebConfiguration()).getFaceletsConfiguration()).isProcessCurrentDocumentAsFaceletsXhtml(compilationManager.getAlias()))) {
                Util.saveXMLDECLToFacesContextAttributes(matcher.group(0) + "\n");
            }
        }
        finally {
            inputStream.reset();
        }
    }

    private SAXParser createSAXParser(CompilationHandler compilationHandler) throws SAXException, ParserConfigurationException {
        SAXParserFactory sAXParserFactory = Util.createSAXParserFactory();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        sAXParserFactory.setFeature("http://xml.org/sax/features/validation", this.isValidating());
        sAXParserFactory.setValidating(this.isValidating());
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        XMLReader xMLReader = sAXParser.getXMLReader();
        xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", compilationHandler);
        xMLReader.setErrorHandler(compilationHandler);
        xMLReader.setEntityResolver(compilationHandler);
        return sAXParser;
    }

    private static class MetadataCompilationHandler
    extends CompilationHandler {
        private static final String METADATA_HANDLER = "metadata";
        private boolean processingMetadata = false;
        private boolean metadataProcessed = false;

        public MetadataCompilationHandler(CompilationManager compilationManager, String string) {
            super(compilationManager, string);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (!this.metadataProcessed && this.processingMetadata) {
                this.unit.writeText(new String(cArray, n, n2));
            }
        }

        public void comment(char[] cArray, int n, int n2) throws SAXException {
        }

        public void endCDATA() throws SAXException {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void startDTD(String string, String string2, String string3) throws SAXException {
        }

        public void startEntity(String string) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!this.metadataProcessed) {
                if (!this.processingMetadata && ("http://java.sun.com/jsf/core".equals(string) || "http://xmlns.jcp.org/jsf/core".equals(string)) && METADATA_HANDLER.equals(string2)) {
                    this.processingMetadata = true;
                }
                if (this.processingMetadata) {
                    super.startElement(string, string2, string3, attributes);
                }
            }
            if (string2.equals("view") && ("http://java.sun.com/jsf/core".equals(string) || "http://xmlns.jcp.org/jsf/core".equals(string))) {
                super.startElement(string, string2, string3, attributes);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (!this.metadataProcessed) {
                if (this.processingMetadata) {
                    super.endElement(string, string2, string3);
                }
                if (this.processingMetadata && ("http://java.sun.com/jsf/core".equals(string) || "http://xmlns.jcp.org/jsf/core".equals(string)) && METADATA_HANDLER.equals(string2)) {
                    this.processingMetadata = false;
                    this.metadataProcessed = true;
                }
            }
            if (string2.equals("view") && ("http://java.sun.com/jsf/core".equals(string) || "http://xmlns.jcp.org/jsf/core".equals(string))) {
                super.endElement(string, string2, string3);
            }
        }
    }

    private static class CompilationHandler
    extends DefaultHandler
    implements LexicalHandler {
        protected final String alias;
        protected boolean inDocument = false;
        protected Locator locator;
        protected final CompilationManager unit;

        public CompilationHandler(CompilationManager compilationManager, String string) {
            this.unit = compilationManager;
            this.alias = string;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.inDocument) {
                this.unit.writeText(new String(cArray, n, n2));
            }
        }

        public void comment(char[] cArray, int n, int n2) throws SAXException {
            if (this.inDocument && !this.unit.getWebConfiguration().getFaceletsConfiguration().isConsumeComments(this.alias)) {
                this.unit.writeComment(new String(cArray, n, n2));
            }
        }

        protected TagAttributesImpl createAttributes(Attributes attributes) {
            int n = attributes.getLength();
            TagAttribute[] tagAttributeArray = new TagAttributeImpl[n];
            for (int i = 0; i < n; ++i) {
                tagAttributeArray[i] = new TagAttributeImpl(this.createLocation(), attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getValue(i));
            }
            return new TagAttributesImpl(tagAttributeArray);
        }

        protected Location createLocation() {
            Location location = null;
            if (null != this.locator) {
                location = new Location(this.alias, this.locator.getLineNumber(), this.locator.getColumnNumber());
            } else if (Compiler.log.isLoggable(Level.SEVERE)) {
                Compiler.log.log(Level.SEVERE, "Unable to create Location due to null locator instance variable.");
            }
            return location;
        }

        public void endCDATA() throws SAXException {
            if (this.inDocument && !this.unit.getWebConfiguration().getFaceletsConfiguration().isConsumeCDATA(this.alias)) {
                this.unit.writeInstruction("]]>");
            }
        }

        public void endDocument() throws SAXException {
            super.endDocument();
        }

        public void endDTD() throws SAXException {
            this.inDocument = true;
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            this.unit.popTag();
        }

        public void endEntity(String string) throws SAXException {
        }

        public void endPrefixMapping(String string) throws SAXException {
            this.unit.popNamespace(string);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            if (this.locator != null) {
                throw new SAXException("Error Traced[line: " + this.locator.getLineNumber() + "] " + sAXParseException.getMessage());
            }
            throw sAXParseException;
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            if (this.inDocument) {
                this.unit.writeWhitespace(new String(cArray, n, n2));
            }
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            String string3 = "com/sun/faces/xhtml/default.dtd";
            URL uRL = this.getClass().getClassLoader().getResource(string3);
            return new InputSource(uRL.toString());
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startCDATA() throws SAXException {
            if (this.inDocument && !this.unit.getWebConfiguration().getFaceletsConfiguration().isConsumeCDATA(this.alias)) {
                this.unit.writeInstruction("<![CDATA[");
            }
        }

        public void startDocument() throws SAXException {
            this.inDocument = true;
        }

        public void startDTD(String string, String string2, String string3) throws SAXException {
            FaceletsConfiguration faceletsConfiguration = this.unit.getWebConfiguration().getFaceletsConfiguration();
            boolean bl = faceletsConfiguration.isProcessCurrentDocumentAsFaceletsXhtml(this.alias);
            if (this.inDocument && (bl || faceletsConfiguration.isOutputHtml5Doctype(this.alias))) {
                boolean bl2 = faceletsConfiguration.isOutputHtml5Doctype(this.alias);
                StringBuffer stringBuffer = new StringBuffer(64);
                stringBuffer.append("<!DOCTYPE ").append(string);
                if (!bl2 && string2 != null) {
                    stringBuffer.append(" PUBLIC \"").append(string2).append("\"");
                    if (string3 != null) {
                        stringBuffer.append(" \"").append(string3).append("\"");
                    }
                } else if (!bl2 && string3 != null) {
                    stringBuffer.append(" SYSTEM \"").append(string3).append("\"");
                }
                stringBuffer.append(">\n");
                Util.saveDOCTYPEToFacesContextAttributes(stringBuffer.toString());
            }
            this.inDocument = false;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            TagAttributesImpl tagAttributesImpl = this.createAttributes(attributes);
            Tag tag = new Tag(this.createLocation(), string, string2, string3, tagAttributesImpl);
            ((TagAttributes)tagAttributesImpl).setTag(tag);
            this.unit.pushTag(tag);
        }

        public void startEntity(String string) throws SAXException {
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
            this.unit.pushNamespace(string, string2);
        }

        public void processingInstruction(String string, String string2) throws SAXException {
            boolean bl;
            if (this.inDocument && (bl = this.unit.getWebConfiguration().getFaceletsConfiguration().isProcessCurrentDocumentAsFaceletsXhtml(this.alias))) {
                StringBuffer stringBuffer = new StringBuffer(64);
                stringBuffer.append("<?").append(string).append(' ').append(string2).append("?>\n");
                this.unit.writeInstruction(stringBuffer.toString());
            }
        }
    }
}

