/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.compiler;

import com.sun.faces.facelets.compiler.Instruction;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.MessageUtils;
import java.io.IOException;
import java.util.List;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

final class EndElementInstruction
implements Instruction {
    private static final String HEAD_ELEMENT = "head";
    private static final String BODY_ELEMENT = "body";
    private final String element;

    public EndElementInstruction(String string) {
        this.element = string;
    }

    public void write(FacesContext facesContext) throws IOException {
        if (HEAD_ELEMENT.equalsIgnoreCase(this.element)) {
            this.warnUnhandledResources(facesContext, HEAD_ELEMENT);
        }
        if (BODY_ELEMENT.equalsIgnoreCase(this.element)) {
            this.warnUnhandledResources(facesContext, BODY_ELEMENT);
            RenderKitUtils.renderUnhandledMessages(facesContext);
        }
        facesContext.getResponseWriter().endElement(this.element);
    }

    public Instruction apply(ExpressionFactory expressionFactory, ELContext eLContext) {
        return this;
    }

    public boolean isLiteral() {
        return true;
    }

    private void warnUnhandledResources(FacesContext facesContext, String string) {
        List<UIComponent> list;
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        if (uIViewRoot != null && (list = uIViewRoot.getComponentResources(facesContext, string)) != null && !list.isEmpty()) {
            FacesMessage facesMessage = MessageUtils.getExceptionMessage("com.sun.faces.RESOURCE_TARGET_NOT_AVAILABLE", string);
            facesContext.addMessage(null, facesMessage);
        }
    }
}

