/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el;

import com.sun.faces.util.MessageUtils;
import java.lang.reflect.Array;
import java.util.List;
import javax.el.ELException;
import javax.el.PropertyNotWritableException;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;

public class PropertyResolverImpl
extends PropertyResolver {
    private PropertyResolver delegate;

    public Class getType(Object object, int n) throws EvaluationException, PropertyNotFoundException {
        PropertyResolverImpl.assertInput(object, n);
        if (this.delegate != null) {
            return this.delegate.getType(object, n);
        }
        Class<?> clazz = object.getClass();
        try {
            if (clazz.isArray()) {
                Array.get(object, n);
                return clazz.getComponentType();
            }
            if (object instanceof List) {
                Object e = ((List)object).get(n);
                return e != null ? e.getClass() : null;
            }
            throw new PropertyNotFoundException(MessageUtils.getExceptionMessageString("com.sun.faces.PROPERTY_TYPE_ERROR", object));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new PropertyNotFoundException(MessageUtils.getExceptionMessageString("com.sun.faces.SIZE_OUT_OF_BOUNDS_ERROR", object, n, Array.getLength(object)));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new PropertyNotFoundException(MessageUtils.getExceptionMessageString("com.sun.faces.SIZE_OUT_OF_BOUNDS_ERROR", object, n, ((List)object).size()));
        }
    }

    public Class getType(Object object, Object object2) {
        PropertyResolverImpl.assertInput(object, object2);
        if (this.delegate != null) {
            return this.delegate.getType(object, object2);
        }
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            return facesContext.getApplication().getELResolver().getType(facesContext.getELContext(), object, object2);
        }
        catch (javax.el.PropertyNotFoundException propertyNotFoundException) {
            throw new PropertyNotFoundException(propertyNotFoundException);
        }
        catch (ELException eLException) {
            throw new EvaluationException(eLException);
        }
    }

    public Object getValue(Object object, int n) {
        if (object == null) {
            return null;
        }
        if (this.delegate != null) {
            return this.delegate.getValue(object, n);
        }
        if (object.getClass().isArray()) {
            try {
                return Array.get(object, n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }
        if (object instanceof List) {
            try {
                return ((List)object).get(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }
        throw new PropertyNotFoundException(MessageUtils.getExceptionMessageString("com.sun.faces.PROPERTY_TYPE_ERROR", object));
    }

    public Object getValue(Object object, Object object2) {
        if (this.delegate != null) {
            return this.delegate.getValue(object, object2);
        }
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            return facesContext.getApplication().getELResolver().getValue(facesContext.getELContext(), object, object2);
        }
        catch (javax.el.PropertyNotFoundException propertyNotFoundException) {
            throw new PropertyNotFoundException(propertyNotFoundException);
        }
        catch (ELException eLException) {
            throw new EvaluationException(eLException);
        }
    }

    public boolean isReadOnly(Object object, int n) {
        PropertyResolverImpl.assertInput(object, n);
        if (this.delegate != null) {
            return this.delegate.isReadOnly(object, n);
        }
        if (object instanceof List || object.getClass().isArray()) {
            return false;
        }
        throw new PropertyNotFoundException(MessageUtils.getExceptionMessageString("com.sun.faces.PROPERTY_TYPE_ERROR", object));
    }

    public boolean isReadOnly(Object object, Object object2) {
        if (this.delegate != null) {
            return this.delegate.isReadOnly(object, object2);
        }
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            return facesContext.getApplication().getELResolver().isReadOnly(facesContext.getELContext(), object, object2);
        }
        catch (ELException eLException) {
            throw new EvaluationException(eLException);
        }
    }

    public void setValue(Object object, int n, Object object2) {
        PropertyResolverImpl.assertInput(object, n);
        if (this.delegate != null) {
            this.delegate.setValue(object, n, object2);
            return;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            try {
                Array.set(object, n, facesContext.getApplication().getExpressionFactory().coerceToType(object2, clazz.getComponentType()));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new PropertyNotFoundException(MessageUtils.getExceptionMessageString("com.sun.faces.SIZE_OUT_OF_BOUNDS_ERROR", object, n, Array.getLength(object)));
            }
        } else if (object instanceof List) {
            try {
                ((List)object).set(n, object2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new PropertyNotFoundException(MessageUtils.getExceptionMessageString("com.sun.faces.SIZE_OUT_OF_BOUNDS_ERROR", object, n, ((List)object).size()));
            }
        } else {
            throw new PropertyNotFoundException(MessageUtils.getExceptionMessageString("com.sun.faces.PROPERTY_TYPE_ERROR", object));
        }
    }

    public void setValue(Object object, Object object2, Object object3) {
        if (this.delegate != null) {
            this.delegate.setValue(object, object2, object3);
            return;
        }
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            facesContext.getApplication().getELResolver().setValue(facesContext.getELContext(), object, object2, object3);
        }
        catch (javax.el.PropertyNotFoundException propertyNotFoundException) {
            throw new PropertyNotFoundException(propertyNotFoundException);
        }
        catch (PropertyNotWritableException propertyNotWritableException) {
            throw new PropertyNotFoundException(propertyNotWritableException);
        }
        catch (ELException eLException) {
            throw new EvaluationException(eLException);
        }
    }

    public void setDelegate(PropertyResolver propertyResolver) {
        this.delegate = propertyResolver;
    }

    protected static void assertInput(Object object, Object object2) throws PropertyNotFoundException {
        if (object == null) {
            String string = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "base");
            throw new PropertyNotFoundException(string);
        }
        if (object2 == null) {
            String string = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "property");
            throw new PropertyNotFoundException(string);
        }
    }

    protected static void assertInput(Object object, int n) throws PropertyNotFoundException {
        if (object == null) {
            String string = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "base");
            throw new PropertyNotFoundException(string);
        }
        if (n < 0) {
            throw new PropertyNotFoundException(MessageUtils.getExceptionMessageString("com.sun.faces.OUT_OF_BOUNDS_ERROR", object, n));
        }
    }
}

