/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context.flash;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.context.flash.SessionHelper;
import com.sun.faces.facelets.tag.ui.UIDebug;
import com.sun.faces.util.ByteArrayGuardAESCTR;
import com.sun.faces.util.FacesLogger;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.faces.event.PhaseId;
import javax.faces.event.PostKeepFlashValueEvent;
import javax.faces.event.PostPutFlashValueEvent;
import javax.faces.event.PreClearFlashEvent;
import javax.faces.event.PreRemoveFlashValueEvent;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELFlash
extends Flash {
    private Map<String, Map<String, Object>> flashInnerMap;
    private final AtomicLong sequenceNumber;
    private int numberOfConcurentFlashUsers;
    private long numberOfFlashesBetweenFlashReapings;
    private final boolean distributable;
    private ByteArrayGuardAESCTR guard;
    private static final String ELEMENT_TYPE_MISMATCH = "element-type-mismatch";
    private static final Logger LOGGER = FacesLogger.FLASH.getLogger();
    static final String PREFIX = "csfcf";
    static final String FLASH_ATTRIBUTE_NAME = "csfcff";
    static final String FLASH_COOKIE_NAME = "csfcfc";
    static final String FLASH_NOW_REQUEST_KEY = "csfcffn";
    public static final String ACT_AS_DO_LAST_PHASE_ACTIONS = ELFlash.class.getPackage().getName() + ".ACT_AS_DO_LAST_PHASE_ACTIONS";

    private ELFlash(ExternalContext externalContext) {
        WebConfiguration webConfiguration;
        block5: {
            String string;
            block4: {
                this.flashInnerMap = null;
                this.sequenceNumber = new AtomicLong(0L);
                this.numberOfConcurentFlashUsers = Integer.parseInt(WebConfiguration.WebContextInitParameter.NumberOfConcurrentFlashUsers.getDefaultValue());
                this.numberOfFlashesBetweenFlashReapings = Long.parseLong(WebConfiguration.WebContextInitParameter.NumberOfFlashesBetweenFlashReapings.getDefaultValue());
                this.flashInnerMap = new ConcurrentHashMap<String, Map<String, Object>>();
                webConfiguration = WebConfiguration.getInstance(externalContext);
                try {
                    string = webConfiguration.getOptionValue(WebConfiguration.WebContextInitParameter.NumberOfConcurrentFlashUsers);
                    this.numberOfConcurentFlashUsers = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                    LOGGER.log(Level.WARNING, "Unable to set number of concurrent flash users.  Defaulting to {0}", this.numberOfConcurentFlashUsers);
                }
            }
            try {
                string = webConfiguration.getOptionValue(WebConfiguration.WebContextInitParameter.NumberOfFlashesBetweenFlashReapings);
                this.numberOfFlashesBetweenFlashReapings = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block5;
                LOGGER.log(Level.WARNING, "Unable to set number flashes between flash repaings.  Defaulting to {0}", this.numberOfFlashesBetweenFlashReapings);
            }
        }
        this.distributable = webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableDistributable);
        this.guard = new ByteArrayGuardAESCTR();
    }

    public static Map<String, Object> getFlash() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return ELFlash.getFlash(facesContext.getExternalContext(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ELFlash getFlash(ExternalContext externalContext, boolean bl) {
        Object object;
        Map<String, Object> map = externalContext.getApplicationMap();
        ELFlash eLFlash = (ELFlash)map.get(FLASH_ATTRIBUTE_NAME);
        if (null == eLFlash && bl) {
            object = externalContext.getContext();
            synchronized (object) {
                eLFlash = (ELFlash)map.get(FLASH_ATTRIBUTE_NAME);
                if (null == eLFlash) {
                    eLFlash = new ELFlash(externalContext);
                    map.put(FLASH_ATTRIBUTE_NAME, eLFlash);
                }
            }
        }
        if (null != map.get(WebConfiguration.BooleanWebContextInitParameter.EnableDistributable.getQualifiedName())) {
            object = externalContext.getContext();
            synchronized (object) {
                SessionHelper sessionHelper = SessionHelper.getInstance(externalContext);
                if (null == sessionHelper) {
                    sessionHelper = new SessionHelper();
                }
                sessionHelper.update(externalContext, eLFlash);
            }
        }
        return eLFlash;
    }

    @Override
    public boolean isKeepMessages() {
        boolean bl = false;
        Map<String, Object> map = this.loggingGetPhaseMapForReading(false);
        if (null != map) {
            Object object = map.get(CONSTANTS.KeepAllMessagesAttributeName.toString());
            bl = null != object ? (Boolean)object : false;
        }
        return bl;
    }

    @Override
    public void setKeepMessages(boolean bl) {
        this.loggingGetPhaseMapForWriting(false).put(CONSTANTS.KeepAllMessagesAttributeName.toString(), bl);
    }

    @Override
    public boolean isRedirect() {
        boolean bl = false;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map<Object, Object> map = facesContext.getAttributes();
        PreviousNextFlashInfoManager previousNextFlashInfoManager = this.getCurrentFlashManager(map, false);
        if (null != previousNextFlashInfoManager) {
            bl = previousNextFlashInfoManager.getPreviousRequestFlashInfo().isIsRedirect();
        }
        return bl;
    }

    @Override
    public void setRedirect(boolean bl) {
    }

    @Override
    public Object get(Object object) {
        Object object2 = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (null != object) {
            if (object.equals("keepMessages")) {
                object2 = this.isKeepMessages();
            } else if (object.equals("redirect")) {
                object2 = this.isRedirect();
            } else if (this.isKeepFlagSet(facesContext)) {
                object2 = this.getPhaseMapForReading().get(object);
                this.keep(object.toString());
                this.clearKeepFlag(facesContext);
                return object2;
            }
        }
        if (null == object2) {
            object2 = this.getPhaseMapForReading().get(object);
        }
        if (this.distributable) {
            SessionHelper sessionHelper = SessionHelper.getInstance(facesContext.getExternalContext());
            assert (null != sessionHelper);
            sessionHelper.update(facesContext.getExternalContext(), this);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "get({0}) = {1}", new Object[]{object, object2});
        }
        return object2;
    }

    @Override
    public Object put(String string, Object object) {
        Boolean bl = null;
        Boolean bl2 = null;
        boolean bl3 = false;
        if (null != string) {
            if (string.equals("keepMessages")) {
                bl = Boolean.parseBoolean((String)object);
                this.setKeepMessages(bl);
                bl3 = true;
            }
            if (string.equals("redirect")) {
                bl = Boolean.parseBoolean((String)object);
                this.setRedirect(bl);
                bl3 = true;
            }
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!bl3) {
            Boolean bl4 = bl2 = null == bl ? this.getPhaseMapForWriting().put(string, object) : bl;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "put({0},{1})", new Object[]{string, object});
            }
            facesContext.getApplication().publishEvent(facesContext, PostPutFlashValueEvent.class, string);
        }
        if (this.distributable) {
            SessionHelper sessionHelper = SessionHelper.getInstance(facesContext.getExternalContext());
            assert (null != sessionHelper);
            sessionHelper.update(facesContext.getExternalContext(), this);
        }
        return bl2;
    }

    @Override
    public Object remove(Object object) {
        Object object2 = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        facesContext.getApplication().publishEvent(facesContext, PreRemoveFlashValueEvent.class, object);
        object2 = this.getPhaseMapForWriting().remove(object);
        return object2;
    }

    @Override
    public boolean containsKey(Object object) {
        boolean bl = false;
        bl = this.getPhaseMapForReading().containsKey(object);
        return bl;
    }

    @Override
    public boolean containsValue(Object object) {
        boolean bl = false;
        bl = this.getPhaseMapForReading().containsValue(object);
        return bl;
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        this.getPhaseMapForWriting().putAll(map);
    }

    @Override
    public Collection<Object> values() {
        Collection<Object> collection = null;
        collection = this.getPhaseMapForReading().values();
        return collection;
    }

    @Override
    public int size() {
        int n = 0;
        n = this.getPhaseMapForReading().size();
        return n;
    }

    @Override
    public void clear() {
        this.getPhaseMapForWriting().clear();
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        Set<Map.Entry<String, Object>> set = this.getPhaseMapForReading().entrySet();
        Set<Map.Entry<String, Object>> set2 = this.getPhaseMapForWriting().entrySet();
        HashSet<Map.Entry<String, Object>> hashSet = null;
        hashSet = new HashSet<Map.Entry<String, Object>>();
        hashSet.addAll(set);
        hashSet.addAll(set2);
        return hashSet;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.getPhaseMapForReading().isEmpty();
        boolean bl2 = this.getPhaseMapForWriting().isEmpty();
        boolean bl3 = false;
        bl3 = bl && bl2;
        return bl3;
    }

    @Override
    public Set<String> keySet() {
        Set<String> set = this.getPhaseMapForReading().keySet();
        Set<String> set2 = this.getPhaseMapForWriting().keySet();
        HashSet<String> hashSet = null;
        hashSet = new HashSet<String>();
        hashSet.addAll(set);
        hashSet.addAll(set2);
        return hashSet;
    }

    @Override
    public void keep(String string) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map<String, Object> map = facesContext.getExternalContext().getRequestMap();
        Map<Object, Object> map2 = facesContext.getAttributes();
        PreviousNextFlashInfoManager previousNextFlashInfoManager = this.getCurrentFlashManager(map2, true);
        if (null != previousNextFlashInfoManager) {
            Object object = map.remove(string);
            if (null == object) {
                FlashInfo flashInfo = null;
                flashInfo = previousNextFlashInfoManager.getPreviousRequestFlashInfo();
                if (null != flashInfo) {
                    object = flashInfo.getFlashMap().remove(string);
                }
            }
            if (null != object) {
                this.getPhaseMapForWriting().put(string, object);
                facesContext.getApplication().publishEvent(facesContext, PostKeepFlashValueEvent.class, string);
            }
        }
    }

    @Override
    public void putNow(String string, Object object) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map<Object, Object> map = facesContext.getAttributes();
        PreviousNextFlashInfoManager previousNextFlashInfoManager = this.getCurrentFlashManager(map, true);
        if (null != previousNextFlashInfoManager) {
            FlashInfo flashInfo = null;
            flashInfo = previousNextFlashInfoManager.getPreviousRequestFlashInfo();
            if (null != flashInfo) {
                flashInfo.getFlashMap().put(string, object);
            }
        }
    }

    @Override
    public void doPrePhaseActions(FacesContext facesContext) {
        PhaseId phaseId = facesContext.getCurrentPhaseId();
        Map<Object, Object> map = facesContext.getAttributes();
        map.put((Object)CONSTANTS.SavedResponseCompleteFlagValue, facesContext.getResponseComplete());
        if (phaseId.equals(PhaseId.RESTORE_VIEW)) {
            Cookie cookie = null;
            cookie = this.getCookie(facesContext.getExternalContext());
            if (null != cookie) {
                this.getCurrentFlashManager(facesContext, map, cookie);
            }
            if (this.isKeepMessages()) {
                this.restoreAllMessages(facesContext);
            }
        }
    }

    @Override
    public void doPostPhaseActions(FacesContext facesContext) {
        boolean bl;
        if (facesContext.getAttributes().containsKey(ACT_AS_DO_LAST_PHASE_ACTIONS)) {
            Boolean bl2 = (Boolean)facesContext.getAttributes().get(ACT_AS_DO_LAST_PHASE_ACTIONS);
            this.doLastPhaseActions(facesContext, bl2);
            return;
        }
        PhaseId phaseId = facesContext.getCurrentPhaseId();
        Map<Object, Object> map = facesContext.getAttributes();
        boolean bl3 = this.responseCompleteWasJustSetTrue(facesContext, map);
        boolean bl4 = bl = bl3 || phaseId == PhaseId.RENDER_RESPONSE;
        if (bl) {
            this.doLastPhaseActions(facesContext, false);
        }
    }

    public void doLastPhaseActions(FacesContext facesContext, boolean bl) {
        Map<Object, Object> map = facesContext.getAttributes();
        PreviousNextFlashInfoManager previousNextFlashInfoManager = this.getCurrentFlashManager(map, false);
        if (null == previousNextFlashInfoManager) {
            return;
        }
        if (this.isKeepMessages()) {
            this.saveAllMessages(facesContext);
        }
        this.releaseCurrentFlashManager(map);
        if (bl) {
            FlashInfo flashInfo = previousNextFlashInfoManager.getPreviousRequestFlashInfo();
            flashInfo.setIsRedirect(true);
            previousNextFlashInfoManager.expireNext_MovePreviousToNext();
        } else {
            FlashInfo flashInfo = previousNextFlashInfoManager.getPreviousRequestFlashInfo();
            if (null != flashInfo && flashInfo.getLifetimeMarker() == LifetimeMarker.SecondTimeThru) {
                previousNextFlashInfoManager.expirePrevious();
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "---------------------------------------");
        }
        this.setCookie(facesContext, previousNextFlashInfoManager, previousNextFlashInfoManager.encode());
    }

    void setFlashInnerMap(Map<String, Map<String, Object>> map) {
        this.flashInnerMap = map;
    }

    Map<String, Map<String, Object>> getFlashInnerMap() {
        return this.flashInnerMap;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[\n");
        for (Map.Entry<String, Object> entry : this.entrySet()) {
            stringBuilder.append("{").append(entry.getKey()).append(", ").append(entry.getValue()).append("}\n");
        }
        stringBuilder.append("]\n");
        return stringBuilder.toString();
    }

    private void maybeWriteCookie(FacesContext facesContext, PreviousNextFlashInfoManager previousNextFlashInfoManager) {
        FlashInfo flashInfo = previousNextFlashInfoManager.getPreviousRequestFlashInfo();
        if (null != flashInfo && flashInfo.getLifetimeMarker() == LifetimeMarker.SecondTimeThru) {
            PreviousNextFlashInfoManager previousNextFlashInfoManager2 = previousNextFlashInfoManager.copyWithoutInnerMap();
            previousNextFlashInfoManager2.expirePrevious();
            this.setCookie(facesContext, previousNextFlashInfoManager, previousNextFlashInfoManager2.encode());
        }
    }

    static void setKeepFlag(FacesContext facesContext) {
        facesContext.getAttributes().put((Object)CONSTANTS.KeepFlagAttributeName, Boolean.TRUE);
    }

    void clearKeepFlag(FacesContext facesContext) {
        facesContext.getAttributes().remove((Object)CONSTANTS.KeepFlagAttributeName);
    }

    boolean isKeepFlagSet(FacesContext facesContext) {
        return Boolean.TRUE == facesContext.getAttributes().get((Object)CONSTANTS.KeepFlagAttributeName);
    }

    private long getNewSequenceNumber() {
        long l = this.sequenceNumber.incrementAndGet();
        if (0L == l % this.numberOfFlashesBetweenFlashReapings) {
            this.reapFlashes();
        }
        if (l == Long.MAX_VALUE) {
            l = 1L;
            this.sequenceNumber.set(1L);
        }
        return l;
    }

    private void reapFlashes() {
        Object object;
        if (this.flashInnerMap.size() < this.numberOfConcurentFlashUsers) {
            return;
        }
        Set<String> set = this.flashInnerMap.keySet();
        long l = this.sequenceNumber.get();
        Object object2 = set.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            long l2 = Long.parseLong((String)object);
            if ((long)this.numberOfConcurentFlashUsers >= l - l2) continue;
            Map<String, Object> map = this.flashInnerMap.get(object);
            if (null != map) {
                map.clear();
            }
            this.flashInnerMap.remove(object);
        }
        if (this.distributable && null != (object = SessionHelper.getInstance((ExternalContext)(object2 = FacesContext.getCurrentInstance().getExternalContext())))) {
            ((SessionHelper)object).remove((ExternalContext)object2);
            object = new SessionHelper();
            ((SessionHelper)object).update((ExternalContext)object2, this);
        }
    }

    private boolean responseCompleteWasJustSetTrue(FacesContext facesContext, Map<Object, Object> map) {
        boolean bl = false;
        bl = Boolean.FALSE == map.get((Object)CONSTANTS.SavedResponseCompleteFlagValue) && facesContext.getResponseComplete();
        return bl;
    }

    private static String getLogPrefix(FacesContext facesContext) {
        String string;
        UIViewRoot uIViewRoot;
        StringBuilder stringBuilder = new StringBuilder();
        ExternalContext externalContext = facesContext.getExternalContext();
        Object object = externalContext.getRequest();
        if (object instanceof HttpServletRequest) {
            stringBuilder.append(((HttpServletRequest)object).getMethod()).append(" ");
        }
        if (null != (uIViewRoot = facesContext.getViewRoot()) && null != (string = uIViewRoot.getViewId())) {
            stringBuilder.append(string).append(" ");
        }
        return stringBuilder.toString();
    }

    private Map<String, Object> loggingGetPhaseMapForWriting(boolean bl) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map<String, Object> map = null;
        PhaseId phaseId = facesContext.getCurrentPhaseId();
        Map<Object, Object> map2 = facesContext.getAttributes();
        PreviousNextFlashInfoManager previousNextFlashInfoManager = this.getCurrentFlashManager(map2, true);
        if (null != previousNextFlashInfoManager) {
            FlashInfo flashInfo;
            boolean bl2;
            boolean bl3 = bl2 = bl && LOGGER.isLoggable(Level.FINEST);
            if (phaseId.getOrdinal() < PhaseId.RENDER_RESPONSE.getOrdinal()) {
                flashInfo = previousNextFlashInfoManager.getPreviousRequestFlashInfo();
                if (bl2) {
                    LOGGER.log(Level.FINEST, "{0}previous[{1}]", new Object[]{ELFlash.getLogPrefix(facesContext), flashInfo.getSequenceNumber()});
                }
            } else {
                flashInfo = previousNextFlashInfoManager.getNextRequestFlashInfo(this, true);
                if (bl2) {
                    LOGGER.log(Level.FINEST, "{0}next[{1}]", new Object[]{ELFlash.getLogPrefix(facesContext), flashInfo.getSequenceNumber()});
                }
                this.maybeWriteCookie(facesContext, previousNextFlashInfoManager);
            }
            map = flashInfo.getFlashMap();
        }
        return map;
    }

    private Map<String, Object> getPhaseMapForWriting() {
        return this.loggingGetPhaseMapForWriting(true);
    }

    private Map<String, Object> loggingGetPhaseMapForReading(boolean bl) {
        FlashInfo flashInfo;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map<String, Object> map = Collections.emptyMap();
        Map<Object, Object> map2 = facesContext.getAttributes();
        PreviousNextFlashInfoManager previousNextFlashInfoManager = this.getCurrentFlashManager(map2, false);
        if (null != previousNextFlashInfoManager && null != (flashInfo = previousNextFlashInfoManager.getPreviousRequestFlashInfo())) {
            boolean bl2;
            boolean bl3 = bl2 = bl && LOGGER.isLoggable(Level.FINEST);
            if (bl2) {
                LOGGER.log(Level.FINEST, "{0}previous[{1}]", new Object[]{ELFlash.getLogPrefix(facesContext), flashInfo.getSequenceNumber()});
            }
            map = flashInfo.getFlashMap();
        }
        return map;
    }

    private Map<String, Object> getPhaseMapForReading() {
        return this.loggingGetPhaseMapForReading(true);
    }

    void saveAllMessages(FacesContext facesContext) {
        ArrayList<FacesMessage> arrayList;
        Iterator<FacesMessage> iterator;
        Map<Object, Object> map = facesContext.getAttributes();
        PreviousNextFlashInfoManager previousNextFlashInfoManager = this.getCurrentFlashManager(map, true);
        if (null == previousNextFlashInfoManager) {
            return;
        }
        if (previousNextFlashInfoManager.getPreviousRequestFlashInfo().isIsRedirect()) {
            return;
        }
        Iterator<String> iterator2 = facesContext.getClientIdsWithMessages();
        HashMap hashMap = null;
        while (iterator2.hasNext()) {
            String string = iterator2.next();
            iterator = facesContext.getMessages(string);
            arrayList = new ArrayList();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            if (null == hashMap) {
                hashMap = new HashMap();
            }
            hashMap.put(string, arrayList);
        }
        arrayList = null;
        iterator = facesContext.getMessages(null);
        arrayList = new ArrayList<FacesMessage>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        if (null != arrayList) {
            if (null == hashMap) {
                hashMap = new HashMap();
            }
            hashMap.put(null, arrayList);
        }
        this.getPhaseMapForWriting().put(CONSTANTS.FacesMessageAttributeName.toString(), hashMap);
    }

    void restoreAllMessages(FacesContext facesContext) {
        Map<String, Object> map = this.getPhaseMapForReading();
        Map map2 = (Map)map.get(CONSTANTS.FacesMessageAttributeName.toString());
        if (null != map2) {
            for (Map.Entry entry : map2.entrySet()) {
                List list = (List)map2.get(entry.getKey());
                if (null == list) continue;
                for (FacesMessage facesMessage : list) {
                    facesContext.addMessage((String)entry.getKey(), facesMessage);
                }
            }
            map.remove(CONSTANTS.FacesMessageAttributeName.toString());
        }
    }

    private Cookie getCookie(ExternalContext externalContext) {
        Cookie cookie = null;
        cookie = (Cookie)externalContext.getRequestCookieMap().get(FLASH_COOKIE_NAME);
        return cookie;
    }

    private void setCookie(FacesContext facesContext, PreviousNextFlashInfoManager previousNextFlashInfoManager, Cookie cookie) {
        Map<Object, Object> map = facesContext.getAttributes();
        ExternalContext externalContext = facesContext.getExternalContext();
        if (map.containsKey((Object)CONSTANTS.DidWriteCookieAttributeName)) {
            return;
        }
        FlashInfo flashInfo = previousNextFlashInfoManager.getNextRequestFlashInfo();
        FlashInfo flashInfo2 = previousNextFlashInfoManager.getPreviousRequestFlashInfo();
        if (facesContext.getAttributes().containsKey((Object)CONSTANTS.ForceSetMaxAgeZero)) {
            this.removeCookie(externalContext, cookie);
            return;
        }
        if (null != flashInfo && !flashInfo.getFlashMap().isEmpty() || null != flashInfo2 && !flashInfo2.getFlashMap().isEmpty()) {
            if (externalContext.isResponseCommitted()) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.externalcontext.flash.response.already.committed");
                }
            } else {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                Object object = cookie.getComment();
                if (null != object) {
                    hashMap.put("comment", object);
                }
                if (null != (object = cookie.getDomain())) {
                    hashMap.put("domain", object);
                }
                if (null != (object = Integer.valueOf(cookie.getMaxAge()))) {
                    hashMap.put("maxAge", object);
                }
                if (externalContext.isSecure()) {
                    hashMap.put("secure", Boolean.TRUE);
                } else {
                    object = cookie.getSecure();
                    if (null != object) {
                        hashMap.put("secure", object);
                    }
                }
                object = cookie.getPath();
                if (null != object) {
                    hashMap.put("path", object);
                }
                hashMap.put("httpOnly", Boolean.TRUE);
                externalContext.addResponseCookie(cookie.getName(), cookie.getValue(), !hashMap.isEmpty() ? hashMap : null);
                hashMap = null;
            }
            map.put((Object)CONSTANTS.DidWriteCookieAttributeName, Boolean.TRUE);
        } else {
            this.removeCookie(externalContext, cookie);
        }
    }

    private void removeCookie(ExternalContext externalContext, Cookie cookie) {
        if (externalContext.isResponseCommitted()) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        cookie.setMaxAge(0);
        Object object = cookie.getComment();
        if (null != object) {
            hashMap.put("comment", object);
        }
        if (null != (object = cookie.getDomain())) {
            hashMap.put("domain", object);
        }
        if (null != (object = Integer.valueOf(cookie.getMaxAge()))) {
            hashMap.put("maxAge", object);
        }
        if (externalContext.isSecure()) {
            hashMap.put("secure", Boolean.TRUE);
        } else {
            object = cookie.getSecure();
            if (null != object) {
                hashMap.put("secure", object);
            }
        }
        object = cookie.getPath();
        if (null != object) {
            hashMap.put("path", object);
        }
        hashMap.put("httpOnly", Boolean.TRUE);
        externalContext.addResponseCookie(cookie.getName(), cookie.getValue(), !hashMap.isEmpty() ? hashMap : null);
        hashMap = null;
    }

    private void releaseCurrentFlashManager(Map<Object, Object> map) {
        map.remove((Object)CONSTANTS.RequestFlashManager);
    }

    private PreviousNextFlashInfoManager getCurrentFlashManager(Map<Object, Object> map, boolean bl) {
        PreviousNextFlashInfoManager previousNextFlashInfoManager = (PreviousNextFlashInfoManager)map.get((Object)CONSTANTS.RequestFlashManager);
        if (null == previousNextFlashInfoManager && bl) {
            previousNextFlashInfoManager = new PreviousNextFlashInfoManager(this.guard, this.flashInnerMap);
            previousNextFlashInfoManager.initializeBaseCase(this);
            map.put((Object)CONSTANTS.RequestFlashManager, previousNextFlashInfoManager);
        }
        return previousNextFlashInfoManager;
    }

    private PreviousNextFlashInfoManager getCurrentFlashManager(FacesContext facesContext, Map<Object, Object> map, Cookie cookie) {
        PreviousNextFlashInfoManager previousNextFlashInfoManager;
        block3: {
            previousNextFlashInfoManager = (PreviousNextFlashInfoManager)map.get((Object)CONSTANTS.RequestFlashManager);
            if (null == previousNextFlashInfoManager) {
                previousNextFlashInfoManager = new PreviousNextFlashInfoManager(this.guard, this.flashInnerMap);
                try {
                    previousNextFlashInfoManager.decode(facesContext, this, cookie);
                    map.put((Object)CONSTANTS.RequestFlashManager, previousNextFlashInfoManager);
                }
                catch (InvalidKeyException invalidKeyException) {
                    map.put((Object)CONSTANTS.ForceSetMaxAgeZero, Boolean.TRUE);
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                    previousNextFlashInfoManager = this.getCurrentFlashManager(map, true);
                    LOGGER.log(Level.SEVERE, "jsf.externalcontext.flash.bad.cookie", new Object[]{invalidKeyException.getMessage()});
                }
            }
        }
        return previousNextFlashInfoManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FlashInfo {
        private boolean isRedirect;
        private LifetimeMarker lifetimeMarker;
        private long sequenceNumber;
        private Map<String, Object> flashMap;

        private FlashInfo() {
        }

        FlashInfo(long l, LifetimeMarker lifetimeMarker, boolean bl) {
            this.setSequenceNumber(l);
            this.setLifetimeMarker(lifetimeMarker);
            this.setIsRedirect(bl);
        }

        FlashInfo copyWithoutInnerMap() {
            FlashInfo flashInfo = new FlashInfo(this.sequenceNumber, this.lifetimeMarker, this.isRedirect);
            return flashInfo;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FlashInfo flashInfo = (FlashInfo)object;
            if (this.isRedirect != flashInfo.isRedirect) {
                return false;
            }
            if (!(this.lifetimeMarker == flashInfo.lifetimeMarker || this.lifetimeMarker != null && this.lifetimeMarker.equals((Object)flashInfo.lifetimeMarker))) {
                return false;
            }
            return this.sequenceNumber == flashInfo.sequenceNumber;
        }

        public int hashCode() {
            int n = 7;
            n = 71 * n + (this.isRedirect ? 1 : 0);
            n = 71 * n + (this.lifetimeMarker != null ? this.lifetimeMarker.hashCode() : 0);
            n = 71 * n + (int)(this.sequenceNumber ^ this.sequenceNumber >>> 32);
            return n;
        }

        void decode(String string) {
            if (null == string || 0 == string.length()) {
                return;
            }
            int n = string.indexOf(88);
            this.setSequenceNumber(Long.parseLong(string.substring(0, n++)));
            this.setLifetimeMarker(LifetimeMarker.decode(string.charAt(n++)));
            this.setIsRedirect(LifetimeMarker.IsRedirect == LifetimeMarker.decode(string.charAt(n++)));
        }

        String encode() {
            String string = null;
            string = this.isIsRedirect() ? Long.toString(this.getSequenceNumber()) + "X" + this.getLifetimeMarker().encode() + LifetimeMarker.IsRedirect.encode() : Long.toString(this.getSequenceNumber()) + "X" + this.getLifetimeMarker().encode() + LifetimeMarker.IsNormal.encode();
            return string;
        }

        boolean isIsRedirect() {
            return this.isRedirect;
        }

        void setIsRedirect(boolean bl) {
            this.isRedirect = bl;
        }

        long getSequenceNumber() {
            return this.sequenceNumber;
        }

        void setSequenceNumber(long l) {
            this.sequenceNumber = l;
        }

        LifetimeMarker getLifetimeMarker() {
            return this.lifetimeMarker;
        }

        void setLifetimeMarker(LifetimeMarker lifetimeMarker) {
            this.lifetimeMarker = lifetimeMarker;
        }

        Map<String, Object> getFlashMap() {
            return this.flashMap;
        }

        void setFlashMap(Map<String, Object> map) {
            this.flashMap = map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PreviousNextFlashInfoManager {
        private FlashInfo previousRequestFlashInfo;
        private FlashInfo nextRequestFlashInfo;
        private boolean incomingCookieCameFromRedirect = false;
        private Map<String, Map<String, Object>> innerMap;
        private ByteArrayGuardAESCTR guard;

        private PreviousNextFlashInfoManager(ByteArrayGuardAESCTR byteArrayGuardAESCTR) {
            this.guard = byteArrayGuardAESCTR;
        }

        private PreviousNextFlashInfoManager(ByteArrayGuardAESCTR byteArrayGuardAESCTR, Map<String, Map<String, Object>> map) {
            this.guard = byteArrayGuardAESCTR;
            this.innerMap = map;
        }

        protected PreviousNextFlashInfoManager copyWithoutInnerMap() {
            PreviousNextFlashInfoManager previousNextFlashInfoManager = new PreviousNextFlashInfoManager(this.guard);
            previousNextFlashInfoManager.innerMap = Collections.emptyMap();
            if (null != this.previousRequestFlashInfo) {
                previousNextFlashInfoManager.previousRequestFlashInfo = this.previousRequestFlashInfo.copyWithoutInnerMap();
            }
            if (null != this.nextRequestFlashInfo) {
                previousNextFlashInfoManager.nextRequestFlashInfo = this.nextRequestFlashInfo.copyWithoutInnerMap();
            }
            previousNextFlashInfoManager.incomingCookieCameFromRedirect = this.incomingCookieCameFromRedirect;
            return previousNextFlashInfoManager;
        }

        public String toString() {
            String string = null;
            string = "previousRequestSequenceNumber: " + (null != this.previousRequestFlashInfo ? Long.valueOf(this.previousRequestFlashInfo.getSequenceNumber()) : "null") + " nextRequestSequenceNumber: " + (null != this.nextRequestFlashInfo ? Long.valueOf(this.nextRequestFlashInfo.getSequenceNumber()) : "null");
            return string;
        }

        void initializeBaseCase(ELFlash eLFlash) {
            HashMap<String, Object> hashMap = null;
            this.previousRequestFlashInfo = new FlashInfo(eLFlash.getNewSequenceNumber(), LifetimeMarker.FirstTimeThru, false);
            hashMap = new HashMap<String, Object>();
            this.innerMap.put(this.previousRequestFlashInfo.getSequenceNumber() + "", hashMap);
            this.previousRequestFlashInfo.setFlashMap(hashMap);
            this.nextRequestFlashInfo = new FlashInfo(eLFlash.getNewSequenceNumber(), LifetimeMarker.FirstTimeThru, false);
            hashMap = new HashMap();
            this.innerMap.put(this.nextRequestFlashInfo.getSequenceNumber() + "", hashMap);
            this.nextRequestFlashInfo.setFlashMap(hashMap);
        }

        void expirePrevious() {
            if (null != this.previousRequestFlashInfo) {
                Map<String, Object> map = this.previousRequestFlashInfo.getFlashMap();
                if (null != map) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "{0} expire previous[{1}]", new Object[]{ELFlash.getLogPrefix(FacesContext.getCurrentInstance()), this.previousRequestFlashInfo.getSequenceNumber()});
                    }
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    facesContext.getApplication().publishEvent(facesContext, PreClearFlashEvent.class, map);
                    map.clear();
                }
                this.innerMap.remove(this.previousRequestFlashInfo.getSequenceNumber() + "");
                this.previousRequestFlashInfo = null;
            }
        }

        void expireNext_MovePreviousToNext() {
            if (null != this.nextRequestFlashInfo) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "{0} expire next[{1}], move previous to next", new Object[]{ELFlash.getLogPrefix(FacesContext.getCurrentInstance()), this.nextRequestFlashInfo.getSequenceNumber()});
                }
                Map<String, Object> map = this.nextRequestFlashInfo.getFlashMap();
                FacesContext facesContext = FacesContext.getCurrentInstance();
                facesContext.getApplication().publishEvent(facesContext, PreClearFlashEvent.class, map);
                map.clear();
                this.innerMap.remove(this.nextRequestFlashInfo.getSequenceNumber() + "");
                this.nextRequestFlashInfo = null;
            }
            this.nextRequestFlashInfo = this.previousRequestFlashInfo;
            this.previousRequestFlashInfo = null;
        }

        void decode(FacesContext facesContext, ELFlash eLFlash, Cookie cookie) throws InvalidKeyException {
            block11: {
                String string = null;
                try {
                    string = URLDecoder.decode(cookie.getValue(), "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string = cookie.getValue();
                }
                String string2 = this.guard.decrypt(string);
                try {
                    int n = string2.indexOf("_");
                    String string3 = string2.substring(0, n++);
                    if (0 < string3.length()) {
                        this.nextRequestFlashInfo = new FlashInfo();
                        this.nextRequestFlashInfo.decode(string3);
                    }
                    this.previousRequestFlashInfo = new FlashInfo();
                    this.previousRequestFlashInfo.decode(string2.substring(n));
                    if (this.previousRequestFlashInfo.isIsRedirect()) {
                        this.setIncomingCookieCameFromRedirect(true);
                        this.previousRequestFlashInfo.setIsRedirect(false);
                    } else if (!UIDebug.debugRequest(facesContext)) {
                        this.previousRequestFlashInfo.setLifetimeMarker(LifetimeMarker.SecondTimeThru);
                        this.nextRequestFlashInfo = null;
                    }
                    Map<String, Object> map = this.innerMap.get(this.previousRequestFlashInfo.getSequenceNumber() + "");
                    if (null == map) {
                        this.previousRequestFlashInfo = new FlashInfo();
                        this.previousRequestFlashInfo.setSequenceNumber(eLFlash.getNewSequenceNumber());
                        this.previousRequestFlashInfo.setLifetimeMarker(LifetimeMarker.FirstTimeThru);
                        this.previousRequestFlashInfo.setIsRedirect(false);
                        map = new HashMap<String, Object>();
                        this.innerMap.put(this.previousRequestFlashInfo.getSequenceNumber() + "", map);
                    }
                    this.previousRequestFlashInfo.setFlashMap(map);
                    if (null != this.nextRequestFlashInfo) {
                        map = this.innerMap.get(this.nextRequestFlashInfo.getSequenceNumber() + "");
                        if (null == map) {
                            this.nextRequestFlashInfo = new FlashInfo();
                            this.nextRequestFlashInfo.setSequenceNumber(eLFlash.getNewSequenceNumber());
                            this.nextRequestFlashInfo.setLifetimeMarker(LifetimeMarker.FirstTimeThru);
                            this.nextRequestFlashInfo.setIsRedirect(false);
                            map = new HashMap<String, Object>();
                            this.innerMap.put(this.nextRequestFlashInfo.getSequenceNumber() + "", map);
                        }
                        this.nextRequestFlashInfo.setFlashMap(map);
                    }
                }
                catch (Throwable throwable) {
                    facesContext.getAttributes().put((Object)CONSTANTS.ForceSetMaxAgeZero, Boolean.TRUE);
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block11;
                    LOGGER.log(Level.SEVERE, "jsf.externalcontext.flash.bad.cookie", new Object[]{string2});
                }
            }
        }

        Cookie encode() {
            String string;
            Cookie cookie = null;
            String string2 = (null != this.previousRequestFlashInfo ? this.previousRequestFlashInfo.encode() : "") + "_" + (null != this.nextRequestFlashInfo ? this.nextRequestFlashInfo.encode() : "");
            String string3 = this.guard.encrypt(string2);
            try {
                cookie = new Cookie(ELFlash.FLASH_COOKIE_NAME, URLEncoder.encode(string3, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                cookie = new Cookie(ELFlash.FLASH_COOKIE_NAME, string3);
            }
            if (1 == string2.length()) {
                cookie.setMaxAge(0);
            }
            if ((string = FacesContext.getCurrentInstance().getExternalContext().getRequestContextPath()).isEmpty()) {
                string = "/";
            }
            cookie.setPath(string);
            return cookie;
        }

        FlashInfo getPreviousRequestFlashInfo() {
            return this.previousRequestFlashInfo;
        }

        void setPreviousRequestFlashInfo(FlashInfo flashInfo) {
            this.previousRequestFlashInfo = flashInfo;
        }

        FlashInfo getNextRequestFlashInfo() {
            return this.nextRequestFlashInfo;
        }

        FlashInfo getNextRequestFlashInfo(ELFlash eLFlash, boolean bl) {
            if (bl && null == this.nextRequestFlashInfo) {
                this.nextRequestFlashInfo = new FlashInfo();
                this.nextRequestFlashInfo.setSequenceNumber(eLFlash.getNewSequenceNumber());
                this.nextRequestFlashInfo.setLifetimeMarker(LifetimeMarker.FirstTimeThru);
                this.nextRequestFlashInfo.setIsRedirect(false);
                HashMap<String, Object> hashMap = null;
                hashMap = new HashMap<String, Object>();
                this.innerMap.put(this.nextRequestFlashInfo.getSequenceNumber() + "", hashMap);
                this.nextRequestFlashInfo.setFlashMap(hashMap);
            }
            return this.nextRequestFlashInfo;
        }

        void setNextRequestFlashInfo(FlashInfo flashInfo) {
            this.nextRequestFlashInfo = flashInfo;
        }

        boolean isIncomingCookieCameFromRedirect() {
            return this.incomingCookieCameFromRedirect;
        }

        void setIncomingCookieCameFromRedirect(boolean bl) {
            this.incomingCookieCameFromRedirect = bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LifetimeMarker {
        FirstTimeThru("f"),
        SecondTimeThru("s"),
        IsRedirect("r"),
        IsNormal("n");

        private static char FIRST_TIME_THRU;
        private static char SECOND_TIME_THRU;
        private static char IS_REDIRECT;
        private static char IS_NORMAL;
        private String name;

        private LifetimeMarker(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }

        public char encode() {
            return this.name.charAt(0);
        }

        public static LifetimeMarker decode(char c) {
            LifetimeMarker lifetimeMarker = FirstTimeThru;
            if (FIRST_TIME_THRU == c) {
                lifetimeMarker = FirstTimeThru;
            } else if (SECOND_TIME_THRU == c) {
                lifetimeMarker = SecondTimeThru;
            } else if (IS_REDIRECT == c) {
                lifetimeMarker = IsRedirect;
            } else if (IS_NORMAL == c) {
                lifetimeMarker = IsNormal;
            } else {
                throw new IllegalStateException("class invariant failed: invalid lifetime marker");
            }
            return lifetimeMarker;
        }

        static {
            FIRST_TIME_THRU = (char)102;
            SECOND_TIME_THRU = (char)115;
            IS_REDIRECT = (char)114;
            IS_NORMAL = (char)110;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CONSTANTS {
        RequestFlashManager,
        SavedResponseCompleteFlagValue,
        FacesMessageAttributeName,
        KeepAllMessagesAttributeName,
        KeepFlagAttributeName,
        DidWriteCookieAttributeName,
        ForceSetMaxAgeZero;

    }
}

