/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.FacesFileNotFoundException;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.FacesLogger;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.PhaseId;
import javax.faces.event.SystemEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionHandlerImpl
extends ExceptionHandler {
    private static final Logger LOGGER = FacesLogger.CONTEXT.getLogger();
    private static final String LOG_BEFORE_KEY = "jsf.context.exception.handler.log_before";
    private static final String LOG_AFTER_KEY = "jsf.context.exception.handler.log_after";
    private static final String LOG_KEY = "jsf.context.exception.handler.log";
    public static final Level INCIDENT_ERROR = Level.parse(Integer.toString(Level.SEVERE.intValue() + 100));
    private LinkedList<ExceptionQueuedEvent> unhandledExceptions;
    private LinkedList<ExceptionQueuedEvent> handledExceptions;
    private ExceptionQueuedEvent handled;
    private boolean errorPagePresent;

    public ExceptionHandlerImpl() {
        this.errorPagePresent = true;
    }

    public ExceptionHandlerImpl(boolean bl) {
        this.errorPagePresent = bl;
    }

    @Override
    public ExceptionQueuedEvent getHandledExceptionQueuedEvent() {
        return this.handled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle() throws FacesException {
        Iterator<ExceptionQueuedEvent> iterator = this.getUnhandledExceptionQueuedEvents().iterator();
        while (iterator.hasNext()) {
            ExceptionQueuedEvent exceptionQueuedEvent = iterator.next();
            ExceptionQueuedEventContext exceptionQueuedEventContext = (ExceptionQueuedEventContext)exceptionQueuedEvent.getSource();
            try {
                Throwable throwable = exceptionQueuedEventContext.getException();
                if (this.isRethrown(throwable)) {
                    this.handled = exceptionQueuedEvent;
                    Throwable throwable2 = this.getRootCause(throwable);
                    if (throwable2 != null) {
                        this.throwIt(exceptionQueuedEventContext.getContext(), new FacesException(throwable2.getMessage(), throwable2));
                    } else if (throwable instanceof FacesException) {
                        this.throwIt(exceptionQueuedEventContext.getContext(), (FacesException)throwable);
                    } else {
                        this.throwIt(exceptionQueuedEventContext.getContext(), new FacesException(throwable.getMessage(), throwable));
                    }
                    if (!LOGGER.isLoggable(INCIDENT_ERROR)) continue;
                    this.log(exceptionQueuedEventContext);
                    continue;
                }
                this.log(exceptionQueuedEventContext);
            }
            finally {
                if (this.handledExceptions == null) {
                    this.handledExceptions = new LinkedList();
                }
                this.handledExceptions.add(exceptionQueuedEvent);
                iterator.remove();
            }
        }
    }

    @Override
    public boolean isListenerForSource(Object object) {
        return object instanceof ExceptionQueuedEventContext;
    }

    @Override
    public void processEvent(SystemEvent systemEvent) throws AbortProcessingException {
        if (systemEvent != null) {
            if (this.unhandledExceptions == null) {
                this.unhandledExceptions = new LinkedList();
            }
            this.unhandledExceptions.add((ExceptionQueuedEvent)systemEvent);
        }
    }

    @Override
    public Throwable getRootCause(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (this.shouldUnwrap(throwable.getClass())) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null) {
                Throwable throwable3 = this.getRootCause(throwable2);
                if (throwable3 == null) {
                    return throwable2;
                }
                return throwable3;
            }
            return throwable;
        }
        return throwable;
    }

    @Override
    public Iterable<ExceptionQueuedEvent> getUnhandledExceptionQueuedEvents() {
        return this.unhandledExceptions != null ? this.unhandledExceptions : Collections.emptyList();
    }

    @Override
    public Iterable<ExceptionQueuedEvent> getHandledExceptionQueuedEvents() {
        return this.handledExceptions != null ? this.handledExceptions : Collections.emptyList();
    }

    private void throwIt(FacesContext facesContext, FacesException facesException) {
        Throwable throwable;
        ExternalContext externalContext;
        boolean bl;
        block6: {
            bl = facesContext.isProjectStage(ProjectStage.Development);
            externalContext = facesContext.getExternalContext();
            throwable = facesException.getCause();
            try {
                externalContext.responseReset();
            }
            catch (Exception exception) {
                if (!LOGGER.isLoggable(Level.INFO)) break block6;
                LOGGER.log(Level.INFO, "Exception when handling error trying to reset the response.", throwable);
            }
        }
        if (null != throwable && throwable instanceof FacesFileNotFoundException) {
            externalContext.setResponseStatus(404);
        } else {
            externalContext.setResponseStatus(500);
        }
        if (!bl || this.errorPagePresent) {
            if (bl) {
                facesContext.getExternalContext().getRequestMap().put("com.sun.faces.error.view", facesContext.getViewRoot());
            }
            throw facesException;
        }
        RenderKitUtils.renderHtmlErrorPage(facesContext, facesException);
    }

    private boolean shouldUnwrap(Class<? extends Throwable> clazz) {
        return FacesException.class.equals(clazz) || ELException.class.equals(clazz);
    }

    private boolean isRethrown(Throwable throwable) {
        return !(throwable instanceof AbortProcessingException);
    }

    private void log(ExceptionQueuedEventContext exceptionQueuedEventContext) {
        Level level;
        UIComponent uIComponent = exceptionQueuedEventContext.getComponent();
        boolean bl = exceptionQueuedEventContext.inBeforePhase();
        boolean bl2 = exceptionQueuedEventContext.inAfterPhase();
        PhaseId phaseId = exceptionQueuedEventContext.getPhaseId();
        Throwable throwable = exceptionQueuedEventContext.getException();
        String string = this.getLoggingKey(bl, bl2);
        Level level2 = level = LOGGER.isLoggable(INCIDENT_ERROR) && LOGGER.isLoggable(Level.SEVERE) ? INCIDENT_ERROR : Level.SEVERE;
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, string, new Object[]{throwable.getClass().getName(), phaseId.toString(), uIComponent != null ? uIComponent.getClientId(exceptionQueuedEventContext.getContext()) : "", throwable.getMessage()});
            if (throwable.getMessage() != null) {
                LOGGER.log(level, throwable.getMessage(), throwable);
            } else {
                LOGGER.log(level, "No associated message", throwable);
            }
        }
    }

    private String getLoggingKey(boolean bl, boolean bl2) {
        if (bl) {
            return LOG_BEFORE_KEY;
        }
        if (bl2) {
            return LOG_AFTER_KEY;
        }
        return LOG_KEY;
    }
}

