/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.BaseContextMap;
import com.sun.faces.util.Util;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationMap
extends BaseContextMap<Object> {
    private final ServletContext servletContext;

    public ApplicationMap(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public Object getContext() {
        return this.servletContext;
    }

    @Override
    public void clear() {
        Enumeration enumeration = this.servletContext.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            this.servletContext.removeAttribute((String)enumeration.nextElement());
        }
    }

    @Override
    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.servletContext.setAttribute((String)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object get(Object object) {
        Util.notNull("key", object);
        return this.servletContext.getAttribute(object.toString());
    }

    @Override
    public Object put(String string, Object object) {
        Util.notNull("key", string);
        Object object2 = this.servletContext.getAttribute(string);
        this.servletContext.setAttribute(string, object);
        return object2;
    }

    @Override
    public Object remove(Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString();
        Object object2 = this.servletContext.getAttribute(string);
        this.servletContext.removeAttribute(string);
        return object2;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.servletContext.getAttribute(object.toString()) != null;
    }

    @Override
    public boolean equals(Object object) {
        return object != null && object instanceof ApplicationMap && super.equals(object);
    }

    @Override
    public int hashCode() {
        int n = 7 * this.servletContext.hashCode();
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            n += iterator.next().hashCode();
        }
        return n;
    }

    @Override
    protected Iterator<Map.Entry<String, Object>> getEntryIterator() {
        return new BaseContextMap.EntryIterator(this.servletContext.getAttributeNames());
    }

    @Override
    protected Iterator<String> getKeyIterator() {
        return new BaseContextMap.KeyIterator(this.servletContext.getAttributeNames());
    }

    @Override
    protected Iterator<Object> getValueIterator() {
        return new BaseContextMap.ValueIterator(this.servletContext.getAttributeNames());
    }
}

