/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.config.processor.FacesConfigNamespaceContext;
import com.sun.faces.util.FacesLogger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLibraryContractsConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String RESOURCE_LIBRARY_CONTRACTS = "resource-library-contracts";

    @Override
    public void process(ServletContext servletContext, DocumentInfo[] documentInfoArray) throws Exception {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (int i = 0; i < documentInfoArray.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing factory elements for document: ''{0}''", documentInfoArray[i].getSourceURI()));
            }
            Document document = documentInfoArray[i].getDocument();
            String string = document.getDocumentElement().getNamespaceURI();
            NodeList nodeList = document.getDocumentElement().getElementsByTagNameNS(string, RESOURCE_LIBRARY_CONTRACTS);
            if (nodeList == null || nodeList.getLength() <= 0) continue;
            this.processResourceLibraryContracts(nodeList, hashMap);
        }
        if (!hashMap.isEmpty()) {
            ApplicationAssociate applicationAssociate = ApplicationAssociate.getCurrentInstance();
            applicationAssociate.setResourceLibraryContracts(hashMap);
        }
        this.invokeNext(servletContext, documentInfoArray);
    }

    private void processResourceLibraryContracts(NodeList nodeList, HashMap<String, List<String>> hashMap) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(new FacesConfigNamespaceContext());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            try {
                NodeList nodeList2 = (NodeList)xPath.evaluate(".//ns1:contract-mapping", node, XPathConstants.NODESET);
                if (nodeList2 == null) continue;
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = nodeList2.item(j);
                    NodeList nodeList3 = (NodeList)xPath.evaluate(".//ns1:url-pattern/text()", node2, XPathConstants.NODESET);
                    if (nodeList3 == null) continue;
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        String string = nodeList3.item(k).getNodeValue().trim();
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.log(Level.INFO, "Processing resource library contract mapping for url-pattern: {0}", string);
                        }
                        if (!hashMap.containsKey(string)) {
                            ArrayList<String> arrayList = new ArrayList<String>();
                            NodeList nodeList4 = (NodeList)xPath.evaluate(".//ns1:contracts/text()", node2, XPathConstants.NODESET);
                            if (nodeList4 != null && nodeList4.getLength() > 0) {
                                for (int i2 = 0; i2 < nodeList4.getLength(); ++i2) {
                                    String[] stringArray = nodeList4.item(i2).getNodeValue().trim().split(",");
                                    for (int i3 = 0; i3 < stringArray.length; ++i3) {
                                        if (!arrayList.contains(stringArray[i3])) {
                                            if (LOGGER.isLoggable(Level.INFO)) {
                                                LOGGER.log(Level.INFO, "Added contract: {0} for url-pattern: {1}", new Object[]{stringArray[i3], string});
                                            }
                                            arrayList.add(stringArray[i3]);
                                            continue;
                                        }
                                        if (!LOGGER.isLoggable(Level.INFO)) continue;
                                        LOGGER.log(Level.INFO, "Duplicate contract: {0} found for url-pattern: {1}", new Object[]{stringArray[i3], string});
                                    }
                                }
                            }
                            if (!arrayList.isEmpty()) {
                                hashMap.put(string, arrayList);
                                continue;
                            }
                            if (!LOGGER.isLoggable(Level.INFO)) continue;
                            LOGGER.log(Level.INFO, "No contracts found for url-pattern: {0}", string);
                            continue;
                        }
                        if (!LOGGER.isLoggable(Level.INFO)) continue;
                        LOGGER.log(Level.INFO, "Duplicate url-patern found: {0}, ignoring it", string);
                    }
                }
                continue;
            }
            catch (XPathExpressionException xPathExpressionException) {
                if (!LOGGER.isLoggable(Level.FINEST)) continue;
                LOGGER.log(Level.FINEST, "Unable to parse XPath expression", xPathExpressionException);
            }
        }
    }
}

