/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.InjectionApplicationFactory;
import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.context.InjectionFacesContextFactory;
import com.sun.faces.util.FacesLogger;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FactoryConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String FACTORY = "factory";
    private static final String APPLICATION_FACTORY = "application-factory";
    private static final String EXCEPTION_HANDLER_FACTORY = "exception-handler-factory";
    private static final String FLASH_FACTORY = "flash-factory";
    private static final String VISIT_CONTEXT_FACTORY = "visit-context-factory";
    private static final String VIEW_DECLARATION_LANGUAGE_FACTORY = "view-declaration-language-factory";
    private static final String TAG_HANDLER_DELEGATE_FACTORY = "tag-handler-delegate-factory";
    private static final String FACELET_CACHE_FACTORY = "facelet-cache-factory";
    private static final String FACES_CONTEXT_FACTORY = "faces-context-factory";
    private static final String CLIENT_WINDOW_FACTORY = "client-window-factory";
    private static final String PARTIAL_VIEW_CONTEXT_FACTORY = "partial-view-context-factory";
    private static final String LIFECYCLE_FACTORY = "lifecycle-factory";
    private static final String RENDER_KIT_FACTORY = "render-kit-factory";
    private static final String EXTERNAL_CONTEXT_FACTORY = "external-context-factory";
    private static final String FLOW_HANDLER_FACTORY = "flow-handler-factory";
    private static final String[] FACTORY_NAMES = new String[]{"javax.faces.application.ApplicationFactory", "javax.faces.lifecycle.ClientWindowFactory", "javax.faces.context.ExceptionHandlerFactory", "javax.faces.context.ExternalContextFactory", "javax.faces.context.FacesContextFactory", "javax.faces.context.FlashFactory", "javax.faces.lifecycle.LifecycleFactory", "javax.faces.view.ViewDeclarationLanguageFactory", "javax.faces.context.PartialViewContextFactory", "javax.faces.render.RenderKitFactory", "javax.faces.component.visit.VisitContextFactory", "javax.faces.view.facelets.FaceletCacheFactory", "javax.faces.view.facelets.TagHandlerDelegateFactory", "javax.faces.flow.FlowHandlerFactory"};
    private boolean validateFactories = true;

    public FactoryConfigProcessor() {
    }

    public FactoryConfigProcessor(boolean bl) {
        this.validateFactories = bl;
    }

    public void process(ServletContext servletContext, DocumentInfo[] documentInfoArray) throws Exception {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        AtomicInteger atomicInteger2 = new AtomicInteger(0);
        for (int i = 0; i < documentInfoArray.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing factory elements for document: ''{0}''", documentInfoArray[i].getSourceURI()));
            }
            Document document = documentInfoArray[i].getDocument();
            String string = document.getDocumentElement().getNamespaceURI();
            NodeList nodeList = document.getDocumentElement().getElementsByTagNameNS(string, FACTORY);
            if (nodeList == null || nodeList.getLength() <= 0) continue;
            this.processFactories(nodeList, string, atomicInteger, atomicInteger2);
        }
        this.wrapFactories(atomicInteger2.get(), atomicInteger.get());
        this.verifyFactoriesExist();
        this.invokeNext(servletContext, documentInfoArray);
    }

    private void processFactories(NodeList nodeList, String string, AtomicInteger atomicInteger, AtomicInteger atomicInteger2) {
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            NodeList nodeList2 = ((Element)node).getElementsByTagNameNS(string, "*");
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                Node node2 = nodeList2.item(j);
                if (APPLICATION_FACTORY.equals(node2.getLocalName())) {
                    atomicInteger2.incrementAndGet();
                    FactoryConfigProcessor.setFactory("javax.faces.application.ApplicationFactory", this.getNodeText(node2));
                    continue;
                }
                if (EXCEPTION_HANDLER_FACTORY.equals(node2.getLocalName())) {
                    FactoryConfigProcessor.setFactory("javax.faces.context.ExceptionHandlerFactory", this.getNodeText(node2));
                    continue;
                }
                if (VISIT_CONTEXT_FACTORY.equals(node2.getLocalName())) {
                    FactoryConfigProcessor.setFactory("javax.faces.component.visit.VisitContextFactory", this.getNodeText(node2));
                    continue;
                }
                if (LIFECYCLE_FACTORY.equals(node2.getLocalName())) {
                    FactoryConfigProcessor.setFactory("javax.faces.lifecycle.LifecycleFactory", this.getNodeText(node2));
                    continue;
                }
                if (FLASH_FACTORY.equals(node2.getLocalName())) {
                    FactoryConfigProcessor.setFactory("javax.faces.context.FlashFactory", this.getNodeText(node2));
                    continue;
                }
                if (CLIENT_WINDOW_FACTORY.equals(node2.getLocalName())) {
                    FactoryConfigProcessor.setFactory("javax.faces.lifecycle.ClientWindowFactory", this.getNodeText(node2));
                    continue;
                }
                if (FACES_CONTEXT_FACTORY.equals(node2.getLocalName())) {
                    atomicInteger.incrementAndGet();
                    FactoryConfigProcessor.setFactory("javax.faces.context.FacesContextFactory", this.getNodeText(node2));
                    continue;
                }
                if (RENDER_KIT_FACTORY.equals(node2.getLocalName())) {
                    FactoryConfigProcessor.setFactory("javax.faces.render.RenderKitFactory", this.getNodeText(node2));
                    continue;
                }
                if (VIEW_DECLARATION_LANGUAGE_FACTORY.equals(node2.getLocalName())) {
                    FactoryConfigProcessor.setFactory("javax.faces.view.ViewDeclarationLanguageFactory", this.getNodeText(node2));
                    continue;
                }
                if (TAG_HANDLER_DELEGATE_FACTORY.equals(node2.getLocalName())) {
                    FactoryConfigProcessor.setFactory("javax.faces.view.facelets.TagHandlerDelegateFactory", this.getNodeText(node2));
                    continue;
                }
                if (FACELET_CACHE_FACTORY.equals(node2.getLocalName())) {
                    FactoryConfigProcessor.setFactory("javax.faces.view.facelets.FaceletCacheFactory", this.getNodeText(node2));
                    continue;
                }
                if (EXTERNAL_CONTEXT_FACTORY.equals(node2.getLocalName())) {
                    FactoryConfigProcessor.setFactory("javax.faces.context.ExternalContextFactory", this.getNodeText(node2));
                    continue;
                }
                if (PARTIAL_VIEW_CONTEXT_FACTORY.equals(node2.getLocalName())) {
                    FactoryConfigProcessor.setFactory("javax.faces.context.PartialViewContextFactory", this.getNodeText(node2));
                    continue;
                }
                if (!FLOW_HANDLER_FACTORY.equals(node2.getLocalName())) continue;
                FactoryConfigProcessor.setFactory("javax.faces.flow.FlowHandlerFactory", this.getNodeText(node2));
            }
        }
    }

    private static void setFactory(String string, String string2) {
        if (string != null && string2 != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling FactoryFinder.setFactory({0}, {1})", string, string2));
            }
            FactoryFinder.setFactory(string, string2);
        }
    }

    private void verifyFactoriesExist() {
        if (this.validateFactories) {
            int n = FACTORY_NAMES.length;
            for (int i = 0; i < n; ++i) {
                try {
                    FactoryFinder.getFactory(FACTORY_NAMES[i]);
                    continue;
                }
                catch (Exception exception) {
                    throw new ConfigurationException(MessageFormat.format("Factory ''{0}'' was not configured properly.", FACTORY_NAMES[i]), exception);
                }
            }
        }
    }

    private void wrapFactories(int n, int n2) {
        if (n > 1) {
            this.addInjectionApplicationFactory();
        }
        if (n2 > 1) {
            this.addInjectionFacesContextFactory();
        }
    }

    private void addInjectionApplicationFactory() {
        FactoryFinder.setFactory("javax.faces.application.ApplicationFactory", InjectionApplicationFactory.class.getName());
    }

    private void addInjectionFacesContextFactory() {
        FactoryFinder.setFactory("javax.faces.context.FacesContextFactory", InjectionFacesContextFactory.class.getName());
    }
}

