/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.component.behavior;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.Application;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHint;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;

public class AjaxBehaviors
implements Serializable {
    private static final String AJAX_BEHAVIORS = "javax.faces.component.AjaxBehaviors";
    private ArrayDeque<BehaviorInfo> behaviorStack = new ArrayDeque();

    public static AjaxBehaviors getAjaxBehaviors(FacesContext facesContext, boolean bl) {
        Map<Object, Object> map = facesContext.getAttributes();
        AjaxBehaviors ajaxBehaviors = (AjaxBehaviors)map.get(AJAX_BEHAVIORS);
        if (ajaxBehaviors == null && bl) {
            ajaxBehaviors = new AjaxBehaviors();
            map.put(AJAX_BEHAVIORS, ajaxBehaviors);
        }
        return ajaxBehaviors;
    }

    public void addBehaviors(FacesContext facesContext, ClientBehaviorHolder clientBehaviorHolder) {
        if (this.behaviorStack == null || this.behaviorStack.isEmpty()) {
            return;
        }
        Iterator<BehaviorInfo> iterator = this.behaviorStack.descendingIterator();
        while (iterator.hasNext()) {
            iterator.next().addBehavior(facesContext, clientBehaviorHolder);
        }
    }

    public void pushBehavior(FacesContext facesContext, AjaxBehavior ajaxBehavior, String string) {
        this.behaviorStack.add(new BehaviorInfo(facesContext, ajaxBehavior, string));
    }

    public void popBehavior() {
        if (this.behaviorStack.size() > 0) {
            this.behaviorStack.removeLast();
        }
    }

    public static class BehaviorInfo
    implements Serializable {
        private String eventName;
        private Object behaviorState;
        private static final long serialVersionUID = -7679229822647712959L;

        public BehaviorInfo(FacesContext facesContext, AjaxBehavior ajaxBehavior, String string) {
            this.eventName = string;
            this.behaviorState = ajaxBehavior.saveState(facesContext);
        }

        public void addBehavior(FacesContext facesContext, ClientBehaviorHolder clientBehaviorHolder) {
            String string = this.eventName;
            if (string == null && (string = clientBehaviorHolder.getDefaultEventName()) == null) {
                return;
            }
            if (this.shouldAddBehavior(clientBehaviorHolder, string)) {
                ClientBehavior clientBehavior = this.createBehavior(facesContext);
                clientBehaviorHolder.addClientBehavior(string, clientBehavior);
            }
        }

        private boolean shouldAddBehavior(ClientBehaviorHolder clientBehaviorHolder, String string) {
            if (!clientBehaviorHolder.getEventNames().contains(string)) {
                return false;
            }
            Map<String, List<ClientBehavior>> map = clientBehaviorHolder.getClientBehaviors();
            List<ClientBehavior> list = map.get(string);
            if (list == null || list.isEmpty()) {
                return true;
            }
            for (ClientBehavior clientBehavior : list) {
                Set<ClientBehaviorHint> set = clientBehavior.getHints();
                if (!set.contains((Object)ClientBehaviorHint.SUBMITTING)) continue;
                return false;
            }
            return true;
        }

        private ClientBehavior createBehavior(FacesContext facesContext) {
            Application application = facesContext.getApplication();
            AjaxBehavior ajaxBehavior = (AjaxBehavior)application.createBehavior("javax.faces.behavior.Ajax");
            ajaxBehavior.restoreState(facesContext, this.behaviorState);
            return ajaxBehavior;
        }

        private BehaviorInfo() {
        }
    }
}

