/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.component;

import java.util.Stack;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.Location;

public class CompositeComponentStackManager {
    private static final String MANAGER_KEY = CompositeComponentStackManager.class.getName();
    private StackHandler treeCreation = new TreeCreationStackHandler();
    private StackHandler runtime = new RuntimeStackHandler();

    private CompositeComponentStackManager() {
    }

    public static CompositeComponentStackManager getManager(FacesContext facesContext) {
        CompositeComponentStackManager compositeComponentStackManager = (CompositeComponentStackManager)facesContext.getAttributes().get(MANAGER_KEY);
        if (compositeComponentStackManager == null) {
            compositeComponentStackManager = new CompositeComponentStackManager();
            facesContext.getAttributes().put(MANAGER_KEY, compositeComponentStackManager);
        }
        return compositeComponentStackManager;
    }

    public boolean push(UIComponent uIComponent) {
        return this.getStackHandler(StackType.Evaluation).push(uIComponent);
    }

    public boolean push(UIComponent uIComponent, StackType stackType) {
        return this.getStackHandler(stackType).push(uIComponent);
    }

    public boolean push() {
        return this.getStackHandler(StackType.Evaluation).push();
    }

    public boolean push(StackType stackType) {
        return this.getStackHandler(stackType).push();
    }

    public void pop(StackType stackType) {
        this.getStackHandler(stackType).pop();
    }

    public void pop() {
        this.getStackHandler(StackType.Evaluation).pop();
    }

    public UIComponent peek() {
        return this.getStackHandler(StackType.Evaluation).peek();
    }

    public UIComponent peek(StackType stackType) {
        return this.getStackHandler(stackType).peek();
    }

    public UIComponent getParentCompositeComponent(StackType stackType, FacesContext facesContext, UIComponent uIComponent) {
        return this.getStackHandler(stackType).getParentCompositeComponent(facesContext, uIComponent);
    }

    public UIComponent findCompositeComponentUsingLocation(FacesContext facesContext, Location location) {
        StackHandler stackHandler = this.getStackHandler(StackType.TreeCreation);
        Stack<UIComponent> stack = stackHandler.getStack(false);
        if (stack != null) {
            String string = location.getPath();
            for (int i = stack.size(); i > 0; --i) {
                UIComponent uIComponent = (UIComponent)stack.get(i - 1);
                Resource resource = (Resource)uIComponent.getAttributes().get("javax.faces.application.Resource.ComponentResource");
                if (!string.endsWith('/' + resource.getResourceName()) || !string.contains(resource.getLibraryName())) continue;
                return uIComponent;
            }
        } else {
            String string = location.getPath();
            UIComponent uIComponent = UIComponent.getCurrentCompositeComponent(facesContext);
            while (uIComponent != null) {
                Resource resource = (Resource)uIComponent.getAttributes().get("javax.faces.application.Resource.ComponentResource");
                if (string.endsWith('/' + resource.getResourceName()) && string.contains(resource.getLibraryName())) {
                    return uIComponent;
                }
                uIComponent = UIComponent.getCompositeComponentParent(uIComponent);
            }
        }
        return UIComponent.getCurrentCompositeComponent(facesContext);
    }

    private StackHandler getStackHandler(StackType stackType) {
        StackHandler stackHandler = null;
        switch (stackType) {
            case TreeCreation: {
                stackHandler = this.treeCreation;
                break;
            }
            case Evaluation: {
                stackHandler = this.runtime;
            }
        }
        return stackHandler;
    }

    private final class TreeCreationStackHandler
    extends BaseStackHandler {
        private TreeCreationStackHandler() {
        }

        public void pop() {
            Stack<UIComponent> stack = this.getStack(false);
            if (stack != null && !this.stack.isEmpty()) {
                this.stack.pop();
                if (this.stack.isEmpty()) {
                    this.delete();
                }
            }
        }

        public boolean push() {
            return false;
        }

        public boolean push(UIComponent uIComponent) {
            if (uIComponent != null) {
                assert (UIComponent.isCompositeComponent(uIComponent));
                Stack<UIComponent> stack = this.getStack(true);
                stack.push(uIComponent);
                return true;
            }
            return false;
        }

        public UIComponent getParentCompositeComponent(FacesContext facesContext, UIComponent uIComponent) {
            Stack<UIComponent> stack = this.getStack(false);
            if (stack == null) {
                return null;
            }
            int n = stack.indexOf(uIComponent);
            if (n == 0) {
                return null;
            }
            return (UIComponent)stack.get(n - 1);
        }
    }

    private final class RuntimeStackHandler
    extends BaseStackHandler {
        private RuntimeStackHandler() {
        }

        public void delete() {
            Stack<UIComponent> stack = this.getStack(false);
            if (stack != null) {
                stack.clear();
            }
        }

        public void pop() {
            Stack<UIComponent> stack = this.getStack(false);
            if (stack != null && !stack.isEmpty()) {
                stack.pop();
            }
        }

        public boolean push() {
            return this.push(null);
        }

        public boolean push(UIComponent uIComponent) {
            UIComponent uIComponent2;
            Stack<UIComponent> stack = CompositeComponentStackManager.this.treeCreation.getStack(false);
            Stack<UIComponent> stack2 = this.getStack(false);
            if (stack != null) {
                uIComponent2 = uIComponent;
            } else {
                stack2 = this.getStack(false);
                uIComponent2 = uIComponent == null ? (stack2 != null && !stack2.isEmpty() ? this.getCompositeParent(stack2.peek()) : this.getCompositeParent(UIComponent.getCurrentCompositeComponent(FacesContext.getCurrentInstance()))) : uIComponent;
            }
            if (uIComponent2 != null) {
                if (stack2 == null) {
                    stack2 = this.getStack(true);
                }
                stack2.push(uIComponent2);
                return true;
            }
            return false;
        }

        public UIComponent getParentCompositeComponent(FacesContext facesContext, UIComponent uIComponent) {
            return this.getCompositeParent(uIComponent);
        }

        private UIComponent getCompositeParent(UIComponent uIComponent) {
            return UIComponent.getCompositeComponentParent(uIComponent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BaseStackHandler
    implements StackHandler {
        protected Stack<UIComponent> stack;

        private BaseStackHandler() {
        }

        @Override
        public void delete() {
            this.stack = null;
        }

        @Override
        public Stack<UIComponent> getStack(boolean bl) {
            if (this.stack == null && bl) {
                this.stack = new Stack();
            }
            return this.stack;
        }

        @Override
        public UIComponent peek() {
            if (this.stack != null && !this.stack.isEmpty()) {
                return this.stack.peek();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface StackHandler {
        public boolean push(UIComponent var1);

        public boolean push();

        public void pop();

        public UIComponent peek();

        public UIComponent getParentCompositeComponent(FacesContext var1, UIComponent var2);

        public void delete();

        public Stack<UIComponent> getStack(boolean var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StackType {
        TreeCreation,
        Evaluation;

    }
}

