/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewDeclarationLanguage;

public abstract class ViewHandlingStrategy
extends ViewDeclarationLanguage {
    private static final Logger logger = FacesLogger.APPLICATION.getLogger();
    protected ApplicationAssociate associate;
    protected WebConfiguration webConfig;

    public ViewHandlingStrategy() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.webConfig = WebConfiguration.getInstance(facesContext.getExternalContext());
        this.associate = ApplicationAssociate.getInstance(facesContext.getExternalContext());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UIViewRoot restoreView(FacesContext facesContext, String string) {
        ExternalContext externalContext = facesContext.getExternalContext();
        String string2 = Util.getFacesMapping(facesContext);
        UIViewRoot uIViewRoot = null;
        if (externalContext.getRequestPathInfo() == null && string2 != null && Util.isPrefixMapped(string2)) {
            try {
                facesContext.responseComplete();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Response Complete for" + string);
                }
                if (externalContext.isResponseCommitted()) return uIViewRoot;
                externalContext.redirect(externalContext.getRequestContextPath());
                return uIViewRoot;
            }
            catch (IOException iOException) {
                throw new FacesException(iOException);
            }
        } else {
            ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
            String string3 = viewHandler.calculateRenderKitId(facesContext);
            return Util.getStateManager(facesContext).restoreView(facesContext, string, string3);
        }
    }

    public UIViewRoot createView(FacesContext facesContext, String string) {
        Util.notNull("context", facesContext);
        UIViewRoot uIViewRoot = (UIViewRoot)facesContext.getApplication().createComponent("javax.faces.ViewRoot");
        Locale locale = null;
        String string2 = null;
        if (facesContext.getViewRoot() != null) {
            locale = facesContext.getViewRoot().getLocale();
            string2 = facesContext.getViewRoot().getRenderKitId();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created new view for " + string);
        }
        if (locale == null) {
            locale = facesContext.getApplication().getViewHandler().calculateLocale(facesContext);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Locale for this view as determined by calculateLocale " + locale.toString());
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Using locale from previous view " + locale.toString());
        }
        if (string2 == null) {
            string2 = facesContext.getApplication().getViewHandler().calculateRenderKitId(facesContext);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("RenderKitId for this view as determined by calculateRenderKitId " + string2);
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Using renderKitId from previous view " + string2);
        }
        uIViewRoot.setLocale(locale);
        uIViewRoot.setRenderKitId(string2);
        uIViewRoot.setViewId(string);
        return uIViewRoot;
    }

    public abstract boolean handlesViewId(String var1);
}

