/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.StateManagementStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspStateManagementStrategy
extends StateManagementStrategy {
    private static final Logger LOGGER = FacesLogger.APPLICATION_VIEW.getLogger();
    private Map<String, Class<?>> classMap;
    private boolean isDevelopmentMode;

    public JspStateManagementStrategy() {
        this(FacesContext.getCurrentInstance());
    }

    public JspStateManagementStrategy(FacesContext facesContext) {
        this.isDevelopmentMode = facesContext.isProjectStage(ProjectStage.Development);
        this.classMap = new ConcurrentHashMap(32);
    }

    private void captureChild(List<TreeNode> list, int n, UIComponent uIComponent) {
        if (!uIComponent.isTransient()) {
            TreeNode treeNode = new TreeNode(n, uIComponent);
            int n2 = list.size();
            list.add(treeNode);
            this.captureRest(list, n2, uIComponent);
        }
    }

    private void captureFacet(List<TreeNode> list, int n, String string, UIComponent uIComponent) {
        if (!uIComponent.isTransient()) {
            FacetNode facetNode = new FacetNode(n, string, uIComponent);
            int n2 = list.size();
            list.add(facetNode);
            this.captureRest(list, n2, uIComponent);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void captureRest(List<TreeNode> list, int n, UIComponent uIComponent) {
        int n2 = uIComponent.getChildCount();
        if (n2 > 0) {
            void entry;
            List<UIComponent> list2 = uIComponent.getChildren();
            boolean i = false;
            while (entry < n2) {
                this.captureChild(list, n, (UIComponent)list2.get((int)entry));
                ++entry;
            }
        }
        if ((n2 = uIComponent.getFacetCount()) > 0) {
            for (Map.Entry entry : uIComponent.getFacets().entrySet()) {
                this.captureFacet(list, n, (String)entry.getKey(), (UIComponent)entry.getValue());
            }
        }
    }

    private UIComponent newInstance(TreeNode treeNode) throws FacesException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "newInstance", treeNode.componentType);
        }
        try {
            Class clazz;
            Class clazz2 = clazz = this.classMap != null ? this.classMap.get(treeNode.componentType) : null;
            if (clazz == null) {
                clazz = Util.loadClass(treeNode.componentType, treeNode);
                if (clazz != null && this.classMap != null) {
                    this.classMap.put(treeNode.componentType, clazz);
                } else if (!this.isDevelopmentMode) {
                    throw new NullPointerException();
                }
            }
            assert (clazz != null);
            UIComponent uIComponent = (UIComponent)clazz.newInstance();
            uIComponent.setId(treeNode.id);
            return uIComponent;
        }
        catch (Exception exception) {
            throw new FacesException(exception);
        }
    }

    private UIViewRoot restoreTree(FacesContext facesContext, String string, Object[] objectArray) throws FacesException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "restoreTree", string);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            UIComponent uIComponent;
            if (objectArray[i] instanceof FacetNode) {
                FacetNode facetNode = (FacetNode)objectArray[i];
                uIComponent = this.newInstance(facetNode);
                objectArray[i] = uIComponent;
                if (i == facetNode.parent) continue;
                ((UIComponent)objectArray[facetNode.parent]).getFacets().put(facetNode.facetName, uIComponent);
                continue;
            }
            TreeNode treeNode = (TreeNode)objectArray[i];
            uIComponent = this.newInstance(treeNode);
            objectArray[i] = uIComponent;
            if (i != treeNode.parent) {
                ((UIComponent)objectArray[treeNode.parent]).getChildren().add(uIComponent);
                continue;
            }
            assert (uIComponent instanceof UIViewRoot);
            UIViewRoot uIViewRoot = (UIViewRoot)uIComponent;
            facesContext.setViewRoot(uIViewRoot);
            uIViewRoot.setRenderKitId(string);
        }
        return (UIViewRoot)objectArray[0];
    }

    @Override
    public UIViewRoot restoreView(FacesContext facesContext, String string, String string2) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "restoreView", new Object[]{string, string2});
        }
        UIViewRoot uIViewRoot = null;
        ResponseStateManager responseStateManager = RenderKitUtils.getResponseStateManager(facesContext, string2);
        Object[] objectArray = (Object[])responseStateManager.getState(facesContext, string);
        if (objectArray != null && objectArray.length >= 2) {
            if (objectArray[0] != null) {
                uIViewRoot = this.restoreTree(facesContext, string2, (Object[])((Object[])objectArray[0]).clone());
                facesContext.setViewRoot(uIViewRoot);
            }
            if (uIViewRoot != null && objectArray[1] != null) {
                uIViewRoot.processRestoreState(facesContext, objectArray[1]);
            }
        }
        return uIViewRoot;
    }

    @Override
    public Object saveView(FacesContext facesContext) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("saveView");
        }
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        Util.checkIdUniqueness(facesContext, uIViewRoot, new HashSet<String>(uIViewRoot.getChildCount() << 1));
        Object object = uIViewRoot.processSaveState(facesContext);
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>(32);
        this.captureChild(arrayList, 0, uIViewRoot);
        Object[] objectArray = arrayList.toArray();
        Object[] objectArray2 = new Object[]{objectArray, object};
        return objectArray2;
    }

    private static class TreeNode
    implements Externalizable {
        private static final long serialVersionUID = -835775352718473281L;
        private static final String NULL_ID = "";
        public String componentType;
        public String id;
        public int parent;

        public TreeNode() {
        }

        public TreeNode(int n, UIComponent uIComponent) {
            this.parent = n;
            this.id = uIComponent.getId();
            this.componentType = uIComponent.getClass().getName();
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.parent = objectInput.readInt();
            this.componentType = objectInput.readUTF();
            this.id = objectInput.readUTF();
            if (this.id.length() == 0) {
                this.id = null;
            }
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.parent);
            objectOutput.writeUTF(this.componentType);
            if (this.id != null) {
                objectOutput.writeUTF(this.id);
            } else {
                objectOutput.writeUTF(NULL_ID);
            }
        }
    }

    private static final class FacetNode
    extends TreeNode {
        private static final long serialVersionUID = -3777170310958005106L;
        public String facetName;

        public FacetNode() {
        }

        public FacetNode(int n, String string, UIComponent uIComponent) {
            super(n, uIComponent);
            this.facetName = string;
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            super.readExternal(objectInput);
            this.facetName = objectInput.readUTF();
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            super.writeExternal(objectOutput);
            objectOutput.writeUTF(this.facetName);
        }
    }
}

