/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.util.MessageUtils;
import java.util.EnumSet;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.ActionSource;
import javax.faces.component.ActionSource2;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;

class FormOmittedChecker {
    private static String SKIP_ITERATION_HINT = "javax.faces.visit.SKIP_ITERATION";

    private FormOmittedChecker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void check(FacesContext facesContext) {
        final FacesContext facesContext2 = facesContext;
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        List<UIComponent> list = uIViewRoot.getChildren();
        for (UIComponent uIComponent : list) {
            try {
                facesContext.getAttributes().put(SKIP_ITERATION_HINT, true);
                EnumSet<VisitHint> enumSet = EnumSet.of(VisitHint.SKIP_ITERATION);
                VisitContext visitContext = VisitContext.createVisitContext(facesContext, null, enumSet);
                uIComponent.visitTree(visitContext, new VisitCallback(){

                    public VisitResult visit(VisitContext visitContext, UIComponent uIComponent) {
                        VisitResult visitResult = VisitResult.ACCEPT;
                        if (FormOmittedChecker.isForm(uIComponent)) {
                            visitResult = VisitResult.REJECT;
                        } else if (FormOmittedChecker.isInNeedOfForm(uIComponent)) {
                            FormOmittedChecker.addFormOmittedMessage(facesContext2);
                        }
                        return visitResult;
                    }
                });
            }
            finally {
                facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
            }
        }
    }

    private static boolean isForm(UIComponent uIComponent) {
        return uIComponent instanceof UIForm || uIComponent.getFamily() != null && uIComponent.getFamily().endsWith("Form");
    }

    private static boolean isInNeedOfForm(UIComponent uIComponent) {
        return uIComponent instanceof ActionSource || uIComponent instanceof ActionSource2 || uIComponent instanceof EditableValueHolder;
    }

    private static void addFormOmittedMessage(FacesContext facesContext) {
        String string = "com.sun.faces.MISSING_FORM_ERROR";
        Object[] objectArray = new Object[]{};
        boolean bl = false;
        FacesMessage facesMessage = MessageUtils.getExceptionMessage(string, objectArray);
        List<FacesMessage> list = facesContext.getMessageList();
        for (FacesMessage facesMessage2 : list) {
            if (!facesMessage2.getDetail().equals(facesMessage.getDetail())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            facesMessage.setSeverity(FacesMessage.SEVERITY_WARN);
            facesContext.addMessage(null, facesMessage);
        }
    }
}

