/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.util.FacesLogger;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

class ZipDirectoryEntryScanner {
    private static final Logger LOGGER = FacesLogger.RESOURCE.getLogger();
    private static final String prefix = "META-INF/resources";
    private static final int prefixLen = "META-INF/resources".length();
    Map<String, Boolean> resourceLibraries;

    ZipDirectoryEntryScanner() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        Set<String> set = externalContext.getResourcePaths("/WEB-INF/lib");
        this.resourceLibraries = new ConcurrentHashMap<String, Boolean>();
        ZipInputStream zipInputStream = null;
        ZipEntry zipEntry = null;
        String string = null;
        if (null != set) {
            for (String string2 : set) {
                zipInputStream = new ZipInputStream(externalContext.getResourceAsStream(string2));
                try {
                    while (null != (zipEntry = zipInputStream.getNextEntry())) {
                        int n;
                        string = zipEntry.getName();
                        if (!string.startsWith(prefix) || prefixLen >= string.length() || (string = string.substring(prefixLen + 1)).endsWith("/") || -1 == (n = string.lastIndexOf("/")) || this.resourceLibraries.containsKey(string = string.substring(0, n))) continue;
                        this.resourceLibraries.put(string, Boolean.TRUE);
                    }
                }
                catch (IOException iOException) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, "Unable to inspect resource library " + string2, iOException);
                }
            }
        }
        Iterator<String> iterator = this.resourceLibraries.keySet().iterator();
        while (iterator.hasNext()) {
            String string2;
            string2 = iterator.next();
            if (!string2.contains("/")) continue;
            iterator.remove();
        }
    }

    boolean libraryExists(String string, String string2) {
        boolean bl = false;
        bl = null != string2 ? this.resourceLibraries.containsKey(string2 + "/" + string) : this.resourceLibraries.containsKey(string);
        return bl;
    }
}

