/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.ClientResourceInfo;
import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.VersionInfo;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceHelper {
    private static final Logger LOGGER = FacesLogger.RESOURCE.getLogger();
    private static final Pattern LIBRARY_VERSION_PATTERN = Pattern.compile("^(\\d+)(_\\d+)+");
    private static final Pattern RESOURCE_VERSION_PATTERN = Pattern.compile("^((?:\\d+)(?:_\\d+)+)[\\.]?(\\w+)?");
    private static final String COMPRESSED_CONTENT_FILENAME = "compressed-content";
    private static final String[] EL_CONTENT_TYPES = new String[]{"text/css"};

    public abstract String getBaseResourcePath();

    public abstract String getBaseContractsPath();

    protected String getBasePath(String string) {
        if (string == null) {
            return this.getBaseResourcePath();
        }
        return this.getBaseContractsPath() + '/' + string;
    }

    public InputStream getInputStream(ResourceInfo resourceInfo, FacesContext facesContext) throws IOException {
        ClientResourceInfo clientResourceInfo;
        ClientResourceInfo clientResourceInfo2;
        InputStream inputStream = null;
        if (resourceInfo instanceof ClientResourceInfo && null == (inputStream = this.getInputStreamFromClientInfo(clientResourceInfo2 = (ClientResourceInfo)resourceInfo, facesContext)) && null != (inputStream = this.getInputStreamFromClientInfo(clientResourceInfo = new ClientResourceInfo(clientResourceInfo2, false), facesContext))) {
            clientResourceInfo2.copy(clientResourceInfo);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getInputStreamFromClientInfo(ClientResourceInfo clientResourceInfo, FacesContext facesContext) throws IOException {
        InputStream inputStream = null;
        if (clientResourceInfo.isCompressable() && this.clientAcceptsCompression(facesContext)) {
            if (!clientResourceInfo.supportsEL()) {
                try {
                    String string = clientResourceInfo.getCompressedPath();
                    inputStream = new BufferedInputStream(new FileInputStream(string + File.separatorChar + COMPRESSED_CONTENT_FILENAME));
                }
                catch (IOException iOException) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, iOException.getMessage(), iOException);
                    }
                    inputStream = null;
                }
            } else {
                InputStream inputStream2 = null;
                try {
                    inputStream2 = new BufferedInputStream(new ELEvaluatingInputStream(facesContext, clientResourceInfo, this.getNonCompressedInputStream(clientResourceInfo, facesContext)));
                    byte[] byArray = new byte[512];
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
                    GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                    int n = inputStream2.read(byArray);
                    while (n != -1) {
                        ((OutputStream)gZIPOutputStream).write(byArray, 0, n);
                        n = inputStream2.read(byArray);
                    }
                    ((OutputStream)gZIPOutputStream).flush();
                    ((OutputStream)gZIPOutputStream).close();
                    inputStream = new BufferedInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                }
                catch (IOException iOException) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, iOException.getMessage(), iOException);
                    }
                }
                finally {
                    block23: {
                        if (inputStream2 != null) {
                            try {
                                inputStream2.close();
                            }
                            catch (IOException iOException) {
                                if (!LOGGER.isLoggable(Level.FINEST)) break block23;
                                LOGGER.log(Level.FINEST, "Closing stream", iOException);
                            }
                        }
                    }
                }
            }
        }
        if (inputStream == null) {
            if (clientResourceInfo.supportsEL()) {
                return new BufferedInputStream(new ELEvaluatingInputStream(facesContext, clientResourceInfo, this.getNonCompressedInputStream(clientResourceInfo, facesContext)));
            }
            inputStream = this.getNonCompressedInputStream(clientResourceInfo, facesContext);
        }
        return inputStream;
    }

    public abstract URL getURL(ResourceInfo var1, FacesContext var2);

    public abstract LibraryInfo findLibrary(String var1, String var2, String var3, FacesContext var4);

    public abstract ResourceInfo findResource(LibraryInfo var1, String var2, String var3, boolean var4, FacesContext var5);

    public long getLastModified(ResourceInfo resourceInfo, FacesContext facesContext) {
        URL uRL = this.getURL(resourceInfo, facesContext);
        if (uRL == null) {
            return 0L;
        }
        return Util.getLastModified(uRL);
    }

    protected abstract InputStream getNonCompressedInputStream(ResourceInfo var1, FacesContext var2) throws IOException;

    protected VersionInfo getVersion(Collection<String> collection, boolean bl) {
        ArrayList<VersionInfo> arrayList = new ArrayList<VersionInfo>(collection.size());
        for (String string : collection) {
            VersionInfo versionInfo = this.getVersion(string, bl);
            if (versionInfo == null) continue;
            arrayList.add(versionInfo);
        }
        Object object = null;
        if (!arrayList.isEmpty()) {
            Collections.sort(arrayList);
            object = (VersionInfo)arrayList.get(arrayList.size() - 1);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean compressContent(ClientResourceInfo clientResourceInfo) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream;
            block22: {
                URL uRL = clientResourceInfo.getHelper().getURL(clientResourceInfo, FacesContext.getCurrentInstance());
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setUseCaches(false);
                uRLConnection.connect();
                inputStream = uRLConnection.getInputStream();
                byte[] byArray = new byte[512];
                byteArrayOutputStream = new ByteArrayOutputStream();
                outputStream = new GZIPOutputStream(byteArrayOutputStream);
                n = 0;
                int n2 = inputStream.read(byArray);
                while (n2 != -1) {
                    outputStream.write(byArray, 0, n2);
                    n += n2;
                    n2 = inputStream.read(byArray);
                }
                outputStream.flush();
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block22;
                    LOGGER.log(Level.FINEST, "Closing stream", iOException);
                }
            }
            if (byteArrayOutputStream.size() < n) {
                String string = clientResourceInfo.getCompressedPath() + File.separatorChar + COMPRESSED_CONTENT_FILENAME;
                outputStream = new FileOutputStream(string);
                outputStream.write(byteArrayOutputStream.toByteArray());
                outputStream.flush();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            block24: {
                block23: {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            if (!LOGGER.isLoggable(Level.FINEST)) break block23;
                            LOGGER.log(Level.FINEST, "Closing stream", iOException);
                        }
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block24;
                        LOGGER.log(Level.FINEST, "Closing stream", iOException);
                    }
                }
            }
        }
    }

    protected boolean clientAcceptsCompression(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Object object = externalContext.getResponse();
        if (object instanceof HttpServletResponse) {
            String[] stringArray = externalContext.getRequestHeaderValuesMap().get("accept-encoding");
            boolean bl = false;
            for (String string : stringArray) {
                if (string.contains("gzip;q=0")) {
                    return false;
                }
                if (string.contains("gzip")) {
                    bl = true;
                    break;
                }
                if (!string.contains("*") || string.contains("*;q=0,") || string.endsWith("*;q=0")) continue;
                bl = true;
            }
            if (bl) {
                ((HttpServletResponse)object).setHeader("Content-Encoding", "gzip");
                return true;
            }
        }
        return false;
    }

    protected ClientResourceInfo handleCompression(ClientResourceInfo clientResourceInfo) {
        try {
            if (!clientResourceInfo.supportsEL() && !this.compressContent(clientResourceInfo)) {
                clientResourceInfo = this.rebuildAsNonCompressed(clientResourceInfo);
            }
        }
        catch (IOException iOException) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, iOException.getMessage(), iOException);
            }
            clientResourceInfo = this.rebuildAsNonCompressed(clientResourceInfo);
        }
        return clientResourceInfo;
    }

    protected boolean resourceSupportsEL(String string, String string2, FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        String string3 = externalContext.getMimeType(string);
        boolean bl = string3 != null && Arrays.binarySearch(EL_CONTENT_TYPES, string3) >= 0 || null != string && null != string2 && "javax.faces".equals(string2) && "jsf.js".equals(string);
        return bl;
    }

    protected String trimLeadingSlash(String string) {
        if (string.charAt(0) == '/') {
            return string.substring(1);
        }
        return string;
    }

    private ClientResourceInfo rebuildAsNonCompressed(ClientResourceInfo clientResourceInfo) {
        LibraryInfo libraryInfo = clientResourceInfo.getLibraryInfo();
        ClientResourceInfo clientResourceInfo2 = libraryInfo != null ? new ClientResourceInfo(clientResourceInfo.library, clientResourceInfo.contract, clientResourceInfo.name, clientResourceInfo.version, false, clientResourceInfo.supportsEL, clientResourceInfo.isDevStage, clientResourceInfo.cacheTimestamp) : new ClientResourceInfo(clientResourceInfo.contract, clientResourceInfo.name, clientResourceInfo.version, clientResourceInfo.localePrefix, this, false, clientResourceInfo.supportsEL, clientResourceInfo.isDevStage, clientResourceInfo.cacheTimestamp);
        return clientResourceInfo2;
    }

    private VersionInfo getVersion(String string, boolean bl) {
        Map<String, Object> map = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
        String[] stringArray = Util.split(map, string, "/");
        String string2 = stringArray[stringArray.length - 1];
        String string3 = null;
        if (bl) {
            Matcher matcher = RESOURCE_VERSION_PATTERN.matcher(string2);
            return matcher.matches() ? new VersionInfo(matcher.group(1), matcher.group(2)) : null;
        }
        return LIBRARY_VERSION_PATTERN.matcher(string2).matches() ? new VersionInfo(string2, string3) : null;
    }

    static {
        Arrays.sort(EL_CONTENT_TYPES);
    }

    private static final class ELEvaluatingInputStream
    extends InputStream {
        private List<Integer> buf = new ArrayList<Integer>(1024);
        private boolean failedExpressionTest = false;
        private boolean writingExpression = false;
        private InputStream inner;
        private ClientResourceInfo info;
        private FacesContext ctx;
        private boolean expressionEvaluated;
        private boolean endOfStreamReached;
        private int nextRead = -1;

        public ELEvaluatingInputStream(FacesContext facesContext, ClientResourceInfo clientResourceInfo, InputStream inputStream) {
            this.inner = inputStream;
            this.info = clientResourceInfo;
            this.ctx = facesContext;
        }

        public int read() throws IOException {
            int n;
            if (null == this.inner) {
                return -1;
            }
            if (this.failedExpressionTest) {
                n = this.nextRead;
                this.nextRead = -1;
                this.failedExpressionTest = false;
            } else if (this.writingExpression) {
                if (0 < this.buf.size()) {
                    n = this.buf.remove(0);
                } else {
                    this.writingExpression = false;
                    n = this.inner.read();
                }
            } else {
                n = this.inner.read();
                char c = (char)n;
                if (c == '#') {
                    n = this.inner.read();
                    c = (char)n;
                    if (c == '{') {
                        this.readExpressionIntoBufferAndEvaluateIntoBuffer();
                        this.writingExpression = true;
                        n = this.read();
                    } else {
                        n = 35;
                        this.nextRead = c;
                        this.failedExpressionTest = true;
                    }
                }
            }
            if (n == -1) {
                this.endOfStreamReached = true;
            }
            return n;
        }

        private void readExpressionIntoBufferAndEvaluateIntoBuffer() throws IOException {
            int n;
            char c;
            do {
                if ((c = (char)(n = this.inner.read())) == '}') {
                    this.evaluateExpressionIntoBuffer();
                    continue;
                }
                this.buf.add(n);
            } while (c != '}' && n != -1);
        }

        private void evaluateExpressionIntoBuffer() {
            ValueExpression valueExpression;
            Object object;
            char[] cArray = new char[this.buf.size()];
            int n = this.buf.size();
            for (int i = 0; i < n; ++i) {
                cArray[i] = (char)this.buf.get(i).intValue();
            }
            String string = new String(cArray);
            n = string.indexOf(":");
            if (-1 != n) {
                if (!this.isPropertyValid(string)) {
                    String string2 = MessageUtils.getExceptionMessageString("com.sun.faces.RESOURCE_INVALID_FORMAT_COLON_ERROR", string);
                    throw new ELException(string2);
                }
                object = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
                valueExpression = Util.split((Map<String, Object>)object, string, ":");
                if (null == valueExpression[0] || null == valueExpression[1]) {
                    String string3 = MessageUtils.getExceptionMessageString("com.sun.faces.RESOURCE_INVALID_FORMAT_NO_LIBRARY_NAME_ERROR", string);
                    throw new ELException(string3);
                }
                try {
                    int n2 = valueExpression[0].indexOf("[") + 2;
                    char c = valueExpression[0].charAt(n2 - 1);
                    valueExpression[0] = valueExpression[0].substring(n2, n);
                    if (valueExpression[0].equals("this")) {
                        LibraryInfo libraryInfo = this.info.getLibraryInfo();
                        if (null != libraryInfo) {
                            valueExpression[0] = libraryInfo.getName();
                        } else if (null != this.info.getContract()) {
                            valueExpression[0] = this.info.getContract();
                        } else {
                            throw new NullPointerException("Resource expression is not a library or resource library contract");
                        }
                        n2 = valueExpression[1].indexOf("]") - 1;
                        valueExpression[1] = valueExpression[1].substring(0, n2);
                        string = "resource[" + c + (String)valueExpression[0] + ":" + (String)valueExpression[1] + c + "]";
                    }
                }
                catch (Exception exception) {
                    String string4 = MessageUtils.getExceptionMessageString("com.sun.faces.RESOURCE_INVALID_FORMAT_ERROR", string);
                    throw new ELException(string4);
                }
            }
            object = this.ctx.getELContext();
            this.expressionEvaluated = true;
            valueExpression = this.ctx.getApplication().getExpressionFactory().createValueExpression(object, "#{" + string + "}", String.class);
            Object object2 = valueExpression.getValue(object);
            String string5 = object2 != null ? object2.toString() : "";
            this.buf.clear();
            int n3 = string5.length();
            for (int i = 0; i < n3; ++i) {
                this.buf.add(Integer.valueOf(string5.charAt(i)));
            }
        }

        public void close() throws IOException {
            if (this.endOfStreamReached && !this.expressionEvaluated) {
                this.info.disableEL();
            }
            this.inner.close();
            super.close();
        }

        private boolean isPropertyValid(String string) {
            int n = string.indexOf(58);
            return string.indexOf(58, n + 1) == -1;
        }
    }
}

