/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.annotation;

import com.sun.faces.application.annotation.RuntimeAnnotationHandler;
import com.sun.faces.el.ELUtils;
import com.sun.faces.util.RequestStateManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

class ResourceDependencyHandler
implements RuntimeAnnotationHandler {
    private ResourceDependency[] dependencies;
    private Map<ResourceDependency, Expressions> expressionsMap;

    public ResourceDependencyHandler(ResourceDependency[] resourceDependencyArray) {
        this.dependencies = resourceDependencyArray;
        Map<Object, Object> map = FacesContext.getCurrentInstance().getAttributes();
        this.expressionsMap = new HashMap<ResourceDependency, Expressions>(resourceDependencyArray.length, 1.0f);
        for (ResourceDependency resourceDependency : resourceDependencyArray) {
            String string;
            Expressions expressions = new Expressions();
            expressions.name = resourceDependency.name();
            String string2 = resourceDependency.library();
            if (string2.length() > 0) {
                if ("this".equals(string2)) {
                    string = (String)map.get("com.sun.faces.composite.this.library");
                    assert (null != string);
                    string2 = string;
                }
                expressions.library = string2;
            }
            if ((string = resourceDependency.target()).length() > 0) {
                expressions.target = string;
            }
            this.expressionsMap.put(resourceDependency, expressions);
        }
    }

    public void apply(FacesContext facesContext, Object ... objectArray) {
        for (ResourceDependency resourceDependency : this.dependencies) {
            if (this.hasBeenProcessed(facesContext, resourceDependency)) continue;
            this.pushResourceToRoot(facesContext, this.createComponentResource(facesContext, resourceDependency));
            this.markProcssed(facesContext, resourceDependency);
        }
    }

    private void pushResourceToRoot(FacesContext facesContext, UIComponent uIComponent) {
        facesContext.getViewRoot().addComponentResource(facesContext, uIComponent, (String)uIComponent.getAttributes().get("target"));
    }

    private boolean hasBeenProcessed(FacesContext facesContext, ResourceDependency resourceDependency) {
        Set set = (Set)RequestStateManager.get(facesContext, "com.sun.faces.PROCESSED_RESOURCE_DEPENDENCIES");
        return set != null && set.contains(resourceDependency);
    }

    private UIComponent createComponentResource(FacesContext facesContext, ResourceDependency resourceDependency) {
        Expressions expressions = this.expressionsMap.get(resourceDependency);
        Application application = facesContext.getApplication();
        String string = expressions.getName(facesContext);
        UIComponent uIComponent = facesContext.getApplication().createComponent("javax.faces.Output");
        uIComponent.setRendererType(application.getResourceHandler().getRendererTypeForResourceName(string));
        Map<String, Object> map = uIComponent.getAttributes();
        map.put("name", string);
        if (expressions.library != null) {
            map.put("library", expressions.getLibrary(facesContext));
        }
        if (expressions.target != null) {
            map.put("target", expressions.getTarget(facesContext));
        }
        return uIComponent;
    }

    private void markProcssed(FacesContext facesContext, ResourceDependency resourceDependency) {
        HashSet<ResourceDependency> hashSet = (HashSet<ResourceDependency>)RequestStateManager.get(facesContext, "com.sun.faces.PROCESSED_RESOURCE_DEPENDENCIES");
        if (hashSet == null) {
            hashSet = new HashSet<ResourceDependency>(6);
            RequestStateManager.set(facesContext, "com.sun.faces.PROCESSED_RESOURCE_DEPENDENCIES", hashSet);
        }
        hashSet.add(resourceDependency);
    }

    private static final class Expressions {
        ValueExpression nameExpression;
        ValueExpression libraryExpression;
        ValueExpression targetExpression;
        String name;
        String library;
        String target;

        private Expressions() {
        }

        String getName(FacesContext facesContext) {
            if (this.nameExpression == null) {
                this.nameExpression = ELUtils.createValueExpression(this.name, String.class);
            }
            return (String)this.nameExpression.getValue(facesContext.getELContext());
        }

        String getLibrary(FacesContext facesContext) {
            if (this.library != null) {
                if (this.libraryExpression == null) {
                    this.libraryExpression = ELUtils.createValueExpression(this.library, String.class);
                }
                return (String)this.libraryExpression.getValue(facesContext.getELContext());
            }
            return null;
        }

        String getTarget(FacesContext facesContext) {
            if (this.target != null) {
                if (this.targetExpression == null) {
                    this.targetExpression = ELUtils.createValueExpression(this.target, String.class);
                }
                return (String)this.targetExpression.getValue(facesContext.getELContext());
            }
            return null;
        }
    }
}

