/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.view.ViewScopeManager;
import com.sun.faces.config.InitFacesContext;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.el.ELUtils;
import com.sun.faces.flow.FlowCDIContext;
import com.sun.faces.io.FastStringWriter;
import com.sun.faces.mgbean.BeanManager;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebappLifecycleListener {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private ServletContext servletContext;
    private ApplicationAssociate applicationAssociate;
    private List<HttpSession> activeSessions;

    public WebappLifecycleListener() {
    }

    public WebappLifecycleListener(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDestroyed(ServletRequestEvent servletRequestEvent) {
        try {
            ServletRequest servletRequest = servletRequestEvent.getServletRequest();
            Object object = servletRequest.getAttributeNames();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                this.handleAttributeEvent(string, servletRequest.getAttribute(string), ELUtils.Scope.REQUEST);
            }
            object = WebConfiguration.getInstance(servletRequestEvent.getServletContext());
            if (((WebConfiguration)object).isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableAgressiveSessionDirtying)) {
                this.syncSessionScopedBeans(servletRequest);
            }
        }
        catch (Throwable throwable) {
            InitFacesContext initFacesContext = new InitFacesContext(servletRequestEvent.getServletContext());
            ExceptionQueuedEventContext exceptionQueuedEventContext = new ExceptionQueuedEventContext(initFacesContext, throwable);
            ((FacesContext)initFacesContext).getApplication().publishEvent(initFacesContext, ExceptionQueuedEvent.class, exceptionQueuedEventContext);
            initFacesContext.getExceptionHandler().handle();
        }
        finally {
            ApplicationAssociate.setCurrentInstance(null);
        }
    }

    public void requestInitialized(ServletRequestEvent servletRequestEvent) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext instanceof InitFacesContext) {
            InitFacesContext initFacesContext = (InitFacesContext)facesContext;
            initFacesContext.releaseCurrentInstance();
        }
        ApplicationAssociate.setCurrentInstance(this.getAssociate());
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        ApplicationAssociate applicationAssociate = this.getAssociate();
        if (applicationAssociate != null && applicationAssociate.isDevModeEnabled()) {
            if (this.activeSessions == null) {
                this.activeSessions = new ArrayList<HttpSession>();
            }
            this.activeSessions.add(httpSessionEvent.getSession());
        }
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        ViewScopeManager viewScopeManager;
        if (this.activeSessions != null) {
            this.activeSessions.remove(httpSessionEvent.getSession());
        }
        if (Util.isCDIAvailable(this.servletContext)) {
            FlowCDIContext.sessionDestroyed(httpSessionEvent);
        }
        if ((viewScopeManager = (ViewScopeManager)this.servletContext.getAttribute("com.sun.faces.application.view.viewScopeManager")) != null) {
            viewScopeManager.sessionDestroyed(httpSessionEvent);
        }
    }

    public void attributeRemoved(ServletRequestAttributeEvent servletRequestAttributeEvent) {
        this.handleAttributeEvent(servletRequestAttributeEvent.getName(), servletRequestAttributeEvent.getValue(), ELUtils.Scope.REQUEST);
    }

    public void attributeReplaced(ServletRequestAttributeEvent servletRequestAttributeEvent) {
        String string = servletRequestAttributeEvent.getName();
        Object object = servletRequestAttributeEvent.getServletRequest().getAttribute(string);
        if (servletRequestAttributeEvent.getValue() != object) {
            this.handleAttributeEvent(string, servletRequestAttributeEvent.getValue(), ELUtils.Scope.REQUEST);
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent httpSessionBindingEvent) {
        this.handleAttributeEvent(httpSessionBindingEvent.getName(), httpSessionBindingEvent.getValue(), ELUtils.Scope.SESSION);
    }

    public void attributeReplaced(HttpSessionBindingEvent httpSessionBindingEvent) {
        HttpSession httpSession = httpSessionBindingEvent.getSession();
        String string = httpSessionBindingEvent.getName();
        Object object = httpSession.getAttribute(string);
        if (httpSessionBindingEvent.getValue() != object) {
            this.handleAttributeEvent(string, httpSessionBindingEvent.getValue(), ELUtils.Scope.SESSION);
        }
    }

    public void attributeRemoved(ServletContextAttributeEvent servletContextAttributeEvent) {
        this.handleAttributeEvent(servletContextAttributeEvent.getName(), servletContextAttributeEvent.getValue(), ELUtils.Scope.APPLICATION);
    }

    public void attributeReplaced(ServletContextAttributeEvent servletContextAttributeEvent) {
        ServletContext servletContext = servletContextAttributeEvent.getServletContext();
        String string = servletContextAttributeEvent.getName();
        Object object = servletContext.getAttribute(string);
        if (servletContextAttributeEvent.getValue() != object) {
            this.handleAttributeEvent(string, servletContextAttributeEvent.getValue(), ELUtils.Scope.APPLICATION);
        }
    }

    private void handleAttributeEvent(String string, Object object, ELUtils.Scope scope) {
        block5: {
            ApplicationAssociate applicationAssociate = this.getAssociate();
            try {
                BeanManager beanManager;
                if (applicationAssociate != null && (beanManager = applicationAssociate.getBeanManager()) != null && beanManager.isManaged(string)) {
                    beanManager.destroy(string, object);
                }
            }
            catch (Exception exception) {
                String string2 = exception.getClass().getName();
                String string3 = exception.getMessage();
                if (string3 == null) {
                    string3 = "";
                }
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "jsf.config.listener.predestroy.error", new Object[]{string2, string, scope, string3});
                }
                if (!LOGGER.isLoggable(Level.FINE)) break block5;
                FastStringWriter fastStringWriter = new FastStringWriter(128);
                exception.printStackTrace(new PrintWriter(fastStringWriter));
                LOGGER.fine(fastStringWriter.toString());
            }
        }
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        if (this.servletContext == null) {
            this.servletContext = servletContextEvent.getServletContext();
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        Enumeration enumeration = this.servletContext.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.handleAttributeEvent(string, this.servletContext.getAttribute(string), ELUtils.Scope.APPLICATION);
        }
        this.applicationAssociate = null;
    }

    public List<HttpSession> getActiveSessions() {
        return new ArrayList<HttpSession>(this.activeSessions);
    }

    private ApplicationAssociate getAssociate() {
        if (this.applicationAssociate == null) {
            this.applicationAssociate = ApplicationAssociate.getInstance(this.servletContext);
        }
        return this.applicationAssociate;
    }

    private void syncSessionScopedBeans(ServletRequest servletRequest) {
        HttpSession httpSession;
        if (servletRequest instanceof HttpServletRequest && (httpSession = ((HttpServletRequest)servletRequest).getSession(false)) != null) {
            ApplicationAssociate applicationAssociate = this.getAssociate();
            if (applicationAssociate == null) {
                return;
            }
            BeanManager beanManager = applicationAssociate.getBeanManager();
            if (beanManager != null) {
                Enumeration enumeration = httpSession.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (!beanManager.isManaged(string)) continue;
                    httpSession.setAttribute(string, httpSession.getAttribute(string));
                }
            }
        }
    }
}

