/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.util.MessageFactory;
import com.sun.faces.util.RequestStateManager;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyEditorHelper {
    private Application app;

    public PropertyEditorHelper(Application application) {
        this.app = application;
    }

    public Object convertToObject(Class<?> clazz, String string) {
        UIComponent uIComponent = this.getComponent();
        Converter converter = this.app.createConverter(clazz);
        if (null == converter) {
            FacesException facesException = new FacesException("Cannot create Converter to convert value " + string + " to instance of target class " + clazz.getName() + '.');
            throw facesException;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        try {
            return converter.getAsObject(facesContext, uIComponent, string);
        }
        catch (ConverterException converterException) {
            this.addConversionErrorMessage(facesContext, uIComponent, converterException);
            return null;
        }
    }

    public String convertToString(Class<?> clazz, Object object) {
        UIComponent uIComponent = this.getComponent();
        Converter converter = this.app.createConverter(clazz);
        if (null == converter) {
            throw new FacesException("Cannot create Converter to convert " + clazz.getName() + " value " + object + " to string.");
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        try {
            return converter.getAsString(facesContext, uIComponent, object);
        }
        catch (ConverterException converterException) {
            this.addConversionErrorMessage(facesContext, uIComponent, converterException);
            return null;
        }
    }

    protected UIComponent getComponent() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            return (UIComponent)RequestStateManager.get(facesContext, "com.sun.faces.ComponentForValue");
        }
        return null;
    }

    protected void addConversionErrorMessage(FacesContext facesContext, UIComponent uIComponent, ConverterException converterException) {
        FacesMessage facesMessage;
        String string = null;
        if (uIComponent instanceof UIInput) {
            UIInput uIInput = (UIInput)uIComponent;
            string = uIInput.getConverterMessage();
            uIInput.setValid(false);
        }
        if (null != string) {
            facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, string, string);
        } else {
            facesMessage = converterException.getFacesMessage();
            if (facesMessage == null && (facesMessage = MessageFactory.getMessage(facesContext, "javax.faces.component.UIInput.CONVERSION", new Object[0])).getDetail() == null) {
                facesMessage.setDetail(converterException.getMessage());
            }
        }
        facesContext.addMessage(uIComponent != null ? uIComponent.getClientId(facesContext) : null, facesMessage);
    }
}

