/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UpdateModelException;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerFactory;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.PhaseId;
import javax.faces.event.SystemEvent;

public class PreJsf2ExceptionHandlerFactory
extends ExceptionHandlerFactory {
    public ExceptionHandler getExceptionHandler() {
        return new PreJsf2ExceptionHandler();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PreJsf2ExceptionHandler
    extends ExceptionHandler {
        private static final Logger LOGGER = Logger.getLogger("javax.faces.webapp", "javax.faces.LogStrings");
        private static final String LOG_BEFORE_KEY = "servere.webapp.prejsf2.exception.handler.log_before";
        private static final String LOG_AFTER_KEY = "servere.webapp.prejsf2.exception.handler.log_after";
        private static final String LOG_KEY = "servere.webapp.prejsf2.exception.handler.log";
        private LinkedList<ExceptionQueuedEvent> unhandledExceptions;
        private LinkedList<ExceptionQueuedEvent> handledExceptions;
        private ExceptionQueuedEvent handled;

        private PreJsf2ExceptionHandler() {
        }

        @Override
        public ExceptionQueuedEvent getHandledExceptionQueuedEvent() {
            return this.handled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle() throws FacesException {
            Iterator<ExceptionQueuedEvent> i = this.getUnhandledExceptionQueuedEvents().iterator();
            while (i.hasNext()) {
                ExceptionQueuedEvent event = i.next();
                ExceptionQueuedEventContext context = (ExceptionQueuedEventContext)event.getSource();
                try {
                    Throwable t = context.getException();
                    if (this.isRethrown(t, context.inBeforePhase() || context.inAfterPhase())) {
                        this.handled = event;
                        Throwable unwrapped = this.getRootCause(t);
                        if (unwrapped != null) {
                            throw new FacesException(unwrapped.getMessage(), unwrapped);
                        }
                        if (t instanceof FacesException) {
                            throw (FacesException)t;
                        }
                        throw new FacesException(t.getMessage(), t);
                    }
                    this.log(context);
                }
                finally {
                    if (this.handledExceptions == null) {
                        this.handledExceptions = new LinkedList();
                    }
                    this.handledExceptions.add(event);
                    i.remove();
                }
            }
        }

        @Override
        public boolean isListenerForSource(Object source) {
            return source instanceof ExceptionQueuedEventContext;
        }

        @Override
        public void processEvent(SystemEvent event) throws AbortProcessingException {
            if (event != null) {
                if (this.unhandledExceptions == null) {
                    this.unhandledExceptions = new LinkedList();
                }
                this.unhandledExceptions.add((ExceptionQueuedEvent)event);
            }
        }

        @Override
        public Throwable getRootCause(Throwable t) {
            if (t == null) {
                return null;
            }
            if (this.shouldUnwrap(t.getClass())) {
                Throwable root = t.getCause();
                if (root != null) {
                    Throwable tmp = this.getRootCause(root);
                    if (tmp == null) {
                        return root;
                    }
                    return tmp;
                }
                return t;
            }
            return t;
        }

        @Override
        public Iterable<ExceptionQueuedEvent> getUnhandledExceptionQueuedEvents() {
            return this.unhandledExceptions != null ? this.unhandledExceptions : Collections.emptyList();
        }

        @Override
        public Iterable<ExceptionQueuedEvent> getHandledExceptionQueuedEvents() {
            return this.handledExceptions != null ? this.handledExceptions : Collections.emptyList();
        }

        private boolean shouldUnwrap(Class<? extends Throwable> c) {
            return FacesException.class.equals(c) || ELException.class.equals(c);
        }

        private boolean isRethrown(Throwable t, boolean isBeforeOrAfterPhase) {
            return !isBeforeOrAfterPhase && !(t instanceof AbortProcessingException) && !(t instanceof UpdateModelException);
        }

        private void log(ExceptionQueuedEventContext exceptionContext) {
            Throwable t = exceptionContext.getException();
            UIComponent c = exceptionContext.getComponent();
            if (t instanceof UpdateModelException) {
                FacesContext context = FacesContext.getCurrentInstance();
                FacesMessage message = ((UpdateModelException)t).getFacesMessage();
                LOGGER.log(Level.SEVERE, message.getSummary(), t.getCause());
                context.addMessage(c.getClientId(context), message);
            } else {
                boolean beforePhase = exceptionContext.inBeforePhase();
                boolean afterPhase = exceptionContext.inAfterPhase();
                PhaseId phaseId = exceptionContext.getPhaseId();
                String key = this.getLoggingKey(beforePhase, afterPhase);
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, key, new Object[]{t.getClass().getName(), phaseId.toString(), c != null ? c.getClientId(exceptionContext.getContext()) : "", t.getMessage()});
                    LOGGER.log(Level.SEVERE, t.getMessage(), t);
                }
            }
        }

        private String getLoggingKey(boolean beforePhase, boolean afterPhase) {
            if (beforePhase) {
                return LOG_BEFORE_KEY;
            }
            if (afterPhase) {
                return LOG_AFTER_KEY;
            }
            return LOG_KEY;
        }
    }
}

