/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.AnnotationScanner;
import com.sun.faces.config.DelegateToGlassFishAnnotationScanner;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.spi.AnnotationProvider;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingAnnotationProvider
extends AnnotationProvider {
    private AnnotationScanner scanner = null;

    public DelegatingAnnotationProvider(ServletContext sc) {
        super(sc);
    }

    @Override
    public Map<Class<? extends Annotation>, Set<Class<?>>> getAnnotatedClasses(Set<URI> urls) {
        HashMap annotatedMap = new HashMap();
        this.createAnnotatedMap(annotatedMap, (Set)this.sc.getAttribute("com.sun.faces.AnnotatedClasses"));
        return annotatedMap;
    }

    public void setAnnotationScanner(com.sun.faces.spi.AnnotationScanner containerConnector, Set<String> jarNamesWithoutMetadataComplete) {
        assert (null == this.scanner);
        DelegateToGlassFishAnnotationScanner impl = new DelegateToGlassFishAnnotationScanner(this.sc);
        impl.setAnnotationScanner(containerConnector, jarNamesWithoutMetadataComplete);
        this.scanner = impl;
    }

    private void createAnnotatedMap(HashMap<Class<? extends Annotation>, Set<Class<?>>> annotatedMap, Set<Class<?>> annotatedSet) {
        if (annotatedSet != null && !annotatedSet.isEmpty()) {
            Iterator<Class<?>> iterator = annotatedSet.iterator();
            WebConfiguration webConfig = WebConfiguration.getInstance();
            boolean annotationScanPackagesSet = webConfig.isSet(WebConfiguration.WebContextInitParameter.AnnotationScanPackages);
            String[] annotationScanPackages = null;
            if (annotationScanPackagesSet) {
                annotationScanPackages = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.AnnotationScanPackages).split("\\s+");
            }
            while (iterator.hasNext()) {
                try {
                    Annotation[] annotations;
                    Class<?> clazz = iterator.next();
                    for (Annotation annotation : annotations = clazz.getAnnotations()) {
                        Class<? extends Annotation> annoType = annotation.annotationType();
                        if (!AnnotationScanner.FACES_ANNOTATION_TYPE.contains(annoType)) continue;
                        Set<Class<?>> classes = annotatedMap.get(annoType);
                        if (classes == null) {
                            classes = new HashSet();
                            annotatedMap.put(annoType, classes);
                        }
                        if (annotationScanPackagesSet) {
                            if (!this.matchesAnnotationScanPackages(clazz, annotationScanPackages)) continue;
                            classes.add(clazz);
                            continue;
                        }
                        classes.add(clazz);
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
            }
        }
    }

    private boolean matchesAnnotationScanPackages(Class clazz, String[] annotationScanPackages) {
        boolean result = false;
        for (int i = 0; i < annotationScanPackages.length; ++i) {
            String classUrlString = clazz.getProtectionDomain().getCodeSource().getLocation().toString();
            String classPackageName = clazz.getPackage().getName();
            if (classUrlString.contains("WEB-INF/classes") && annotationScanPackages[i].equals("*")) {
                result = true;
                continue;
            }
            if (classPackageName.equals(annotationScanPackages[i])) {
                result = true;
                continue;
            }
            if (!annotationScanPackages[i].startsWith("jar:")) continue;
            String jarName = annotationScanPackages[i].substring(4, annotationScanPackages[i].indexOf(":", 5));
            String jarPackageName = annotationScanPackages[i].substring(annotationScanPackages[i].lastIndexOf(":") + 1);
            if (jarName.equals("*")) {
                if (jarPackageName.equals("*")) {
                    result = true;
                    continue;
                }
                if (!jarPackageName.equals(classPackageName)) continue;
                result = true;
                continue;
            }
            if (classUrlString.contains(jarName) && jarPackageName.equals("*")) {
                result = true;
                continue;
            }
            if (!classUrlString.contains(jarName) || !jarPackageName.equals(classPackageName)) continue;
            result = true;
        }
        return result;
    }
}

