/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.RIConstants;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.io.FastStringWriter;
import com.sun.faces.util.DebugUtil;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.LRUMap;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.RequestStateManager;
import java.beans.FeatureDescriptor;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.ProjectStage;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.AbortProcessingException;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.SchemaFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static boolean unitTestModeEnabled = false;
    private static final String patternCacheKey = "com.sun.faces.patternCache";
    private static final String CDI_AVAILABLE_PER_APP_KEY = Util.class.getName() + "_CDI_AVAILABLE";
    private static final String FACES_CONTEXT_ATTRIBUTES_DOCTYPE_KEY = Util.class.getName() + "_FACES_CONTEXT_ATTRS_DOCTYPE_KEY";
    private static final String FACES_CONTEXT_ATTRIBUTES_XMLDECL_KEY = Util.class.getName() + "_FACES_CONTEXT_ATTRS_XMLDECL_KEY";

    private Util() {
        throw new IllegalStateException();
    }

    private static Map<String, Pattern> getPatternCache(Map<String, Object> appMap) {
        LRUMap result = (LRUMap)appMap.get(patternCacheKey);
        if (null == result) {
            result = new LRUMap(15);
            appMap.put(patternCacheKey, result);
        }
        return result;
    }

    private static Map<String, Pattern> getPatternCache(ServletContext sc) {
        LRUMap result = (LRUMap)sc.getAttribute(patternCacheKey);
        if (null == result) {
            result = new LRUMap(15);
            sc.setAttribute(patternCacheKey, result);
        }
        return result;
    }

    public static boolean isCDIAvailable(Map<String, Object> appMap) {
        boolean result = appMap.containsKey(CDI_AVAILABLE_PER_APP_KEY);
        return result;
    }

    public static boolean isCDIAvailable(ServletContext sc) {
        boolean result = null != sc.getAttribute(CDI_AVAILABLE_PER_APP_KEY);
        return result;
    }

    public static Object getCDIBeanManager(Map<String, Object> appMap) {
        Object beanManager = appMap.get(CDI_AVAILABLE_PER_APP_KEY);
        return beanManager;
    }

    public static void setCDIAvailable(ServletContext sc, Object beanManager) {
        sc.setAttribute(CDI_AVAILABLE_PER_APP_KEY, beanManager);
    }

    public static boolean isCdiOneOneOrGreater() {
        boolean result;
        block2: {
            result = false;
            try {
                Class.forName("javax.enterprise.context.Initialized");
                result = true;
            }
            catch (ClassNotFoundException ignored) {
                if (!LOGGER.isLoggable(Level.FINEST)) break block2;
                LOGGER.log(Level.FINEST, "Dected CDI 1.0", ignored);
            }
        }
        return result;
    }

    public static boolean isPortletRequest(FacesContext context) {
        return context.getExternalContext().getRequestMap().get("javax.portlet.faces.phase") != null;
    }

    public static Object getListenerInstance(ValueExpression type, ValueExpression binding) {
        FacesContext faces = FacesContext.getCurrentInstance();
        Object instance = null;
        if (faces == null) {
            return null;
        }
        if (binding != null) {
            instance = binding.getValue(faces.getELContext());
        }
        if (instance == null && type != null) {
            try {
                instance = ReflectionUtils.newInstance((String)type.getValue(faces.getELContext()));
            }
            catch (Exception e) {
                throw new AbortProcessingException(e.getMessage(), e);
            }
            if (binding != null) {
                binding.setValue(faces.getELContext(), instance);
            }
        }
        return instance;
    }

    public static void setUnitTestModeEnabled(boolean enabled) {
        unitTestModeEnabled = enabled;
    }

    public static boolean isUnitTestModeEnabled() {
        return unitTestModeEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransformerFactory createTransformerFactory() {
        TransformerFactory factory;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Util.class.getClassLoader());
            factory = TransformerFactory.newInstance();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SAXParserFactory createSAXParserFactory() {
        SAXParserFactory factory;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Util.class.getClassLoader());
            factory = SAXParserFactory.newInstance();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Util.class.getClassLoader());
            factory = DocumentBuilderFactory.newInstance();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchemaFactory createSchemaFactory(String uri) {
        SchemaFactory factory;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Util.class.getClassLoader());
            factory = SchemaFactory.newInstance(uri);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return factory;
    }

    public static Class loadClass(String name, Object fallbackClass) throws ClassNotFoundException {
        ClassLoader loader = Util.getCurrentLoader(fallbackClass);
        String[] primitiveNames = new String[]{"byte", "short", "int", "long", "float", "double", "boolean", "char"};
        Class[] primitiveClasses = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE};
        for (int i = 0; i < primitiveNames.length; ++i) {
            if (!primitiveNames[i].equals(name)) continue;
            return primitiveClasses[i];
        }
        return Class.forName(name, true, loader);
    }

    public static ClassLoader getCurrentLoader(Object fallbackClass) {
        ClassLoader loader = Util.getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader;
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static String removeAllButLastSlashPathSegment(String input) {
        int slash;
        int len;
        if (input.charAt(0) == '/') {
            input = input.substring(1);
        }
        if (input.charAt((len = input.length()) - 1) == '/') {
            input = input.substring(0, len - 1);
        }
        if (-1 != (slash = input.lastIndexOf("/"))) {
            input = input.substring(slash + 1);
        }
        return input;
    }

    public static String removeAllButNextToLastSlashPathSegment(String input) {
        int lastSlash;
        int len;
        if (input.charAt(0) == '/') {
            input = input.substring(1);
        }
        if (input.charAt((len = input.length()) - 1) == '/') {
            input = input.substring(0, len - 1);
        }
        if (-1 != (lastSlash = input.lastIndexOf("/"))) {
            int startOrPreviousSlash = input.lastIndexOf("/", lastSlash - 1);
            startOrPreviousSlash = -1 == startOrPreviousSlash ? 0 : startOrPreviousSlash;
            input = input.substring(startOrPreviousSlash, lastSlash);
        }
        return input;
    }

    public static String removeLastPathSegment(String input) {
        int slash = input.lastIndexOf("/");
        if (-1 != slash) {
            input = input.substring(0, slash);
        }
        return input;
    }

    public static String getFlowIdFromComponent(FacesContext context, UIComponent target) {
        int dot;
        String result = "";
        if (target instanceof UIViewRoot && -1 != (dot = (result = Util.removeAllButNextToLastSlashPathSegment(((UIViewRoot)target).getViewId())).indexOf("."))) {
            result = result.substring(0, dot);
        }
        return result;
    }

    public static void notNull(String varname, Object var) {
        if (var == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", varname));
        }
    }

    public static Locale getLocaleFromContextOrSystem(FacesContext context) {
        UIViewRoot root;
        Locale temp;
        Locale result = temp = Locale.getDefault();
        if (null != context && null != (root = context.getViewRoot()) && null == (result = root.getLocale())) {
            result = temp;
        }
        return result;
    }

    public static Converter getConverterForClass(Class converterClass, FacesContext context) {
        if (converterClass == null) {
            return null;
        }
        try {
            Application application = context.getApplication();
            return application.createConverter(converterClass);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Converter getConverterForIdentifer(String converterId, FacesContext context) {
        if (converterId == null) {
            return null;
        }
        try {
            Application application = context.getApplication();
            return application.createConverter(converterId);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static StateManager getStateManager(FacesContext context) throws FacesException {
        return context.getApplication().getStateManager();
    }

    public static Class getTypeFromString(String type) throws ClassNotFoundException {
        Class result;
        if (type.equals("byte")) {
            result = Byte.TYPE;
        } else if (type.equals("short")) {
            result = Short.TYPE;
        } else if (type.equals("int")) {
            result = Integer.TYPE;
        } else if (type.equals("long")) {
            result = Long.TYPE;
        } else if (type.equals("float")) {
            result = Float.TYPE;
        } else if (type.equals("double")) {
            result = Double.TYPE;
        } else if (type.equals("boolean")) {
            result = Boolean.TYPE;
        } else if (type.equals("char")) {
            result = Character.TYPE;
        } else if (type.equals("void")) {
            result = Void.TYPE;
        } else {
            if (type.indexOf(46) == -1) {
                type = "java.lang." + type;
            }
            result = Util.loadClass(type, Void.TYPE);
        }
        return result;
    }

    public static ViewHandler getViewHandler(FacesContext context) throws FacesException {
        Application application = context.getApplication();
        assert (application != null);
        ViewHandler viewHandler = application.getViewHandler();
        assert (viewHandler != null);
        return viewHandler;
    }

    public static boolean componentIsDisabled(UIComponent component) {
        return Boolean.valueOf(String.valueOf(component.getAttributes().get("disabled")));
    }

    public static boolean componentIsDisabledOrReadonly(UIComponent component) {
        return Boolean.valueOf(String.valueOf(component.getAttributes().get("disabled"))) != false || Boolean.valueOf(String.valueOf(component.getAttributes().get("readonly"))) != false;
    }

    public static Locale getLocaleFromString(String localeStr) throws IllegalArgumentException {
        if (null == localeStr || localeStr.length() < 2) {
            throw new IllegalArgumentException("Illegal locale String: " + localeStr);
        }
        Locale result = null;
        String lang = null;
        String country = null;
        String variant = null;
        char[] seps = new char[]{'-', '_'};
        int inputLength = localeStr.length();
        int i = 0;
        int j = 0;
        if (inputLength >= 2 && (i = Util.indexOfSet(localeStr, seps, 0)) == -1) {
            if (2 != localeStr.length()) {
                throw new IllegalArgumentException("Illegal locale String: " + localeStr);
            }
            lang = localeStr.toLowerCase();
        }
        if (i != -1) {
            lang = localeStr.substring(0, i);
            if (inputLength >= 5 && (j = Util.indexOfSet(localeStr, seps, i + 1)) == -1) {
                if (inputLength != 5) {
                    throw new IllegalArgumentException("Illegal locale String: " + localeStr);
                }
                country = localeStr.substring(i + 1);
            }
            if (j != -1) {
                country = localeStr.substring(i + 1, j);
                if (inputLength >= 8) {
                    variant = localeStr.substring(j + 1);
                } else {
                    throw new IllegalArgumentException("Illegal locale String: " + localeStr);
                }
            }
        }
        if (variant != null && country != null && lang != null) {
            result = new Locale(lang, country, variant);
        } else if (lang != null && country != null) {
            result = new Locale(lang, country);
        } else if (lang != null) {
            result = new Locale(lang, "");
        }
        return result;
    }

    public static int indexOfSet(String str, char[] set, int fromIndex) {
        int result = -1;
        int len = str.length();
        for (int i = fromIndex; i < len; ++i) {
            int innerLen = set.length;
            for (int j = 0; j < innerLen; ++j) {
                if (str.charAt(i) != set[j]) continue;
                result = i;
                break;
            }
            if (-1 != result) break;
        }
        return result;
    }

    public static String getStackTraceString(Throwable e) {
        if (null == e) {
            return "";
        }
        StackTraceElement[] stacks = e.getStackTrace();
        StringBuffer sb = new StringBuffer();
        for (StackTraceElement stack : stacks) {
            sb.append(stack.toString()).append('\n');
        }
        return sb.toString();
    }

    public static String getContentTypeFromResponse(Object response) {
        String result = null;
        if (null != response) {
            try {
                Object obj;
                Method method = ReflectionUtils.lookupMethod(response.getClass(), "getContentType", RIConstants.EMPTY_CLASS_ARGS);
                if (null != method && null != (obj = method.invoke(response, RIConstants.EMPTY_METH_ARGS))) {
                    result = obj.toString();
                }
            }
            catch (Exception e) {
                throw new FacesException(e);
            }
        }
        return result;
    }

    public static FeatureDescriptor getFeatureDescriptor(String name, String displayName, String desc, boolean expert, boolean hidden, boolean preferred, Object type, Boolean designTime) {
        FeatureDescriptor fd = new FeatureDescriptor();
        fd.setName(name);
        fd.setDisplayName(displayName);
        fd.setShortDescription(desc);
        fd.setExpert(expert);
        fd.setHidden(hidden);
        fd.setPreferred(preferred);
        fd.setValue("type", type);
        fd.setValue("resolvableAtDesignTime", designTime);
        return fd;
    }

    public static synchronized String[] split(Map<String, Object> appMap, String toSplit, String regex) {
        Map<String, Pattern> patternCache = Util.getPatternCache(appMap);
        Pattern pattern = patternCache.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            patternCache.put(regex, pattern);
        }
        return pattern.split(toSplit, 0);
    }

    public static synchronized String[] split(ServletContext sc, String toSplit, String regex) {
        Map<String, Pattern> patternCache = Util.getPatternCache(sc);
        Pattern pattern = patternCache.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            patternCache.put(regex, pattern);
        }
        return pattern.split(toSplit, 0);
    }

    public static String getFacesMapping(FacesContext context) {
        String pathInfo;
        String servletPath;
        if (context == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(message);
        }
        ExternalContext extContext = context.getExternalContext();
        String mapping = (String)RequestStateManager.get(context, "com.sun.faces.INVOCATION_PATH");
        if (mapping == null && (mapping = Util.getMappingForRequest(servletPath = extContext.getRequestServletPath(), pathInfo = extContext.getRequestPathInfo())) == null && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "jsf.faces_servlet_mapping_cannot_be_determined_error", new Object[]{servletPath});
        }
        if (mapping != null) {
            RequestStateManager.set(context, "com.sun.faces.INVOCATION_PATH", mapping);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "URL pattern of the FacesServlet executing the current request " + mapping);
        }
        return mapping;
    }

    private static String getMappingForRequest(String servletPath, String pathInfo) {
        if (servletPath == null) {
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "servletPath " + servletPath);
            LOGGER.log(Level.FINE, "pathInfo " + pathInfo);
        }
        if (servletPath.length() == 0) {
            return "/*";
        }
        if (pathInfo != null) {
            return servletPath;
        }
        if (servletPath.indexOf(46) < 0) {
            return servletPath;
        }
        return servletPath.substring(servletPath.lastIndexOf(46));
    }

    public static boolean isPrefixMapped(String mapping) {
        return mapping.charAt(0) == '/';
    }

    public static boolean isSpecialAttributeName(String name) {
        boolean isSpecialAttributeName = name.equals("action") || name.equals("actionListener") || name.equals("validator") || name.equals("valueChangeListener");
        return isSpecialAttributeName;
    }

    public static boolean isViewPopulated(FacesContext ctx, UIViewRoot viewToRender) {
        return ctx.getAttributes().containsKey(viewToRender);
    }

    public static void setViewPopulated(FacesContext ctx, UIViewRoot viewToRender) {
        ctx.getAttributes().put(viewToRender, Boolean.TRUE);
    }

    public static void checkIdUniqueness(FacesContext context, UIComponent component, Set<String> componentIds) {
        boolean uniquenessCheckDisabled = false;
        if (context.isProjectStage(ProjectStage.Production)) {
            WebConfiguration config = WebConfiguration.getInstance(context.getExternalContext());
            uniquenessCheckDisabled = config.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DisableIdUniquenessCheck);
        }
        if (!uniquenessCheckDisabled) {
            Iterator<UIComponent> kids = component.getFacetsAndChildren();
            while (kids.hasNext()) {
                UIComponent kid = kids.next();
                String id = kid.getClientId(context);
                if (componentIds.add(id)) {
                    Util.checkIdUniqueness(context, kid, componentIds);
                    continue;
                }
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "jsf.duplicate_component_id_error", id);
                    FastStringWriter writer = new FastStringWriter(128);
                    DebugUtil.simplePrintTree(context.getViewRoot(), id, writer);
                    LOGGER.severe(writer.toString());
                }
                String message = MessageUtils.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", id);
                throw new IllegalStateException(message);
            }
        }
    }

    public static boolean classHasAnnotations(Class<?> clazz) {
        if (clazz != null) {
            while (clazz != Object.class) {
                Method[] methods;
                Field[] fields = clazz.getDeclaredFields();
                if (fields != null) {
                    for (Field field : fields) {
                        if (field.getAnnotations().length <= 0) continue;
                        return true;
                    }
                }
                if ((methods = clazz.getDeclaredMethods()) != null) {
                    for (Method method : methods) {
                        if (method.getDeclaredAnnotations().length <= 0) continue;
                        return true;
                    }
                }
                clazz = clazz.getSuperclass();
            }
        }
        return false;
    }

    public static String getViewStateId(FacesContext context) {
        String result = null;
        String viewStateCounterKey = "com.sun.faces.util.ViewStateCounterKey";
        Map<Object, Object> contextAttrs = context.getAttributes();
        Integer counter = (Integer)contextAttrs.get("com.sun.faces.util.ViewStateCounterKey");
        if (null == counter) {
            counter = 0;
        }
        char sep = UINamingContainer.getSeparatorChar(context);
        UIViewRoot root = context.getViewRoot();
        result = root.getContainerClientId(context) + sep + "javax.faces.ViewState" + sep + counter;
        counter = counter + 1;
        contextAttrs.put("com.sun.faces.util.ViewStateCounterKey", counter);
        return result;
    }

    public static String getClientWindowId(FacesContext context) {
        String result = null;
        String clientWindowIdCounterKey = "com.sun.faces.util.ClientWindowCounterKey";
        Map<Object, Object> contextAttrs = context.getAttributes();
        Integer counter = (Integer)contextAttrs.get("com.sun.faces.util.ClientWindowCounterKey");
        if (null == counter) {
            counter = 0;
        }
        char sep = UINamingContainer.getSeparatorChar(context);
        result = context.getViewRoot().getContainerClientId(context) + sep + "javax.faces.ClientWindow" + sep + counter;
        counter = counter + 1;
        contextAttrs.put("com.sun.faces.util.ClientWindowCounterKey", counter);
        return result;
    }

    public static void saveDOCTYPEToFacesContextAttributes(String DOCTYPE) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (null == context) {
            return;
        }
        Map<Object, Object> attrs = context.getAttributes();
        attrs.put(FACES_CONTEXT_ATTRIBUTES_DOCTYPE_KEY, DOCTYPE);
    }

    public static String getDOCTYPEFromFacesContextAttributes(FacesContext context) {
        if (null == context) {
            return null;
        }
        Map<Object, Object> attrs = context.getAttributes();
        return (String)attrs.get(FACES_CONTEXT_ATTRIBUTES_DOCTYPE_KEY);
    }

    public static void saveXMLDECLToFacesContextAttributes(String XMLDECL) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (null == context) {
            return;
        }
        Map<Object, Object> attrs = context.getAttributes();
        attrs.put(FACES_CONTEXT_ATTRIBUTES_XMLDECL_KEY, XMLDECL);
    }

    public static String getXMLDECLFromFacesContextAttributes(FacesContext context) {
        if (null == context) {
            return null;
        }
        Map<Object, Object> attrs = context.getAttributes();
        return (String)attrs.get(FACES_CONTEXT_ATTRIBUTES_XMLDECL_KEY);
    }

    public static long getLastModified(URL url) {
        long lastModified;
        InputStream is = null;
        try {
            URLConnection conn = url.openConnection();
            if (conn instanceof JarURLConnection) {
                JarURLConnection jarUrlConnection = (JarURLConnection)conn;
                URL jarFileUrl = jarUrlConnection.getJarFileURL();
                URLConnection jarFileConnection = jarFileUrl.openConnection();
                lastModified = jarFileConnection.getLastModified();
                jarFileConnection.getInputStream().close();
            } else {
                is = conn.getInputStream();
                lastModified = conn.getLastModified();
            }
        }
        catch (Exception e) {
            throw new FacesException("Error Checking Last Modified for " + url, e);
        }
        finally {
            block13: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block13;
                        LOGGER.log(Level.FINEST, "Closing stream", e);
                    }
                }
            }
        }
        return lastModified;
    }
}

