/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.spi;

import com.sun.faces.config.DelegatingAnnotationProvider;
import com.sun.faces.spi.AnnotationProvider;
import com.sun.faces.spi.ServiceFactoryUtils;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.faces.FacesException;
import javax.servlet.ServletContext;

public class AnnotationProviderFactory {
    private static final Class<? extends AnnotationProvider> DEFAULT_ANNOTATION_PROVIDER = DelegatingAnnotationProvider.class;
    private static final String ANNOTATION_PROVIDER_SERVICE_KEY = "com.sun.faces.spi.annotationprovider";

    public static AnnotationProvider createAnnotationProvider(ServletContext sc) {
        AnnotationProvider annotationProvider = AnnotationProviderFactory.createDefaultProvider(sc);
        String[] services = ServiceFactoryUtils.getServiceEntries(ANNOTATION_PROVIDER_SERVICE_KEY);
        if (services.length > 0) {
            Object provider = ServiceFactoryUtils.getProviderFromEntry(services[0], new Class[]{ServletContext.class, AnnotationProvider.class}, new Object[]{sc, annotationProvider});
            if (provider == null) {
                provider = ServiceFactoryUtils.getProviderFromEntry(services[0], new Class[]{ServletContext.class}, new Object[]{sc});
            }
            if (provider != null) {
                if (!(provider instanceof AnnotationProvider)) {
                    throw new FacesException("Class " + provider.getClass().getName() + " is not an instance of com.sun.faces.spi.AnnotationProvider");
                }
                annotationProvider = (AnnotationProvider)provider;
            }
        } else {
            ServiceLoader<AnnotationProvider> serviceLoader = ServiceLoader.load(AnnotationProvider.class);
            Iterator<AnnotationProvider> iterator = serviceLoader.iterator();
            if (iterator.hasNext()) {
                AnnotationProvider defaultAnnotationProvider = annotationProvider;
                annotationProvider = iterator.next();
                annotationProvider.initialize(sc, defaultAnnotationProvider);
            }
        }
        return annotationProvider;
    }

    private static AnnotationProvider createDefaultProvider(ServletContext sc) {
        AnnotationProvider result = null;
        try {
            Constructor<? extends AnnotationProvider> c = DEFAULT_ANNOTATION_PROVIDER.getDeclaredConstructor(ServletContext.class);
            result = c.newInstance(sc);
        }
        catch (Exception e2) {
            throw new FacesException(e2);
        }
        return result;
    }
}

