/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.component.visit;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;

public class PartialVisitContext
extends VisitContext {
    private Collection<String> clientIds;
    private Collection<String> ids;
    private Collection<String> unvisitedClientIds;
    private Map<String, Collection<String>> subtreeClientIds;
    private FacesContext facesContext;
    private Set<VisitHint> hints;

    public PartialVisitContext(FacesContext facesContext, Collection<String> clientIds) {
        this(facesContext, clientIds, null);
    }

    public PartialVisitContext(FacesContext facesContext, Collection<String> clientIds, Set<VisitHint> hints) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        this.facesContext = facesContext;
        this.initializeCollections(clientIds);
        EnumSet<VisitHint> hintsEnumSet = hints == null || hints.isEmpty() ? EnumSet.noneOf(VisitHint.class) : EnumSet.copyOf(hints);
        this.hints = Collections.unmodifiableSet(hintsEnumSet);
    }

    @Override
    public FacesContext getFacesContext() {
        return this.facesContext;
    }

    @Override
    public Set<VisitHint> getHints() {
        return this.hints;
    }

    @Override
    public Collection<String> getIdsToVisit() {
        return this.clientIds;
    }

    public Collection<String> getUnvisitedClientIds() {
        return this.unvisitedClientIds;
    }

    @Override
    public Collection<String> getSubtreeIdsToVisit(UIComponent component) {
        if (!(component instanceof NamingContainer)) {
            throw new IllegalArgumentException("Component is not a NamingContainer: " + component);
        }
        String clientId = component.getClientId();
        Collection<String> ids = this.subtreeClientIds.get(clientId);
        if (ids == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(ids);
    }

    @Override
    public VisitResult invokeVisitCallback(UIComponent component, VisitCallback callback) {
        String clientId = this.getVisitId(component);
        if (clientId == null) {
            return VisitResult.ACCEPT;
        }
        VisitResult result = callback.visit(this, component);
        this.unvisitedClientIds.remove(clientId);
        if (this.unvisitedClientIds.isEmpty()) {
            return VisitResult.COMPLETE;
        }
        return result;
    }

    private void idAdded(String clientId) {
        this.ids.add(this.getIdFromClientId(clientId));
        this.unvisitedClientIds.add(clientId);
        this.addSubtreeClientId(clientId);
    }

    private void idRemoved(String clientId) {
        this.unvisitedClientIds.remove(clientId);
        this.removeSubtreeClientId(clientId);
    }

    private void initializeCollections(Collection<String> clientIds) {
        this.unvisitedClientIds = new HashSet<String>();
        this.ids = new HashSet<String>();
        this.subtreeClientIds = new HashMap<String, Collection<String>>();
        this.clientIds = new CollectionProxy<String>(new HashSet());
        this.clientIds.addAll(clientIds);
    }

    private String getVisitId(UIComponent component) {
        String id = component.getId();
        if (id != null && !this.ids.contains(id)) {
            return null;
        }
        String clientId = component.getClientId();
        assert (clientId != null);
        return this.clientIds.contains(clientId) ? clientId : null;
    }

    private String getIdFromClientId(String clientId) {
        FacesContext facesContext = this.getFacesContext();
        char separator = UINamingContainer.getSeparatorChar(facesContext);
        int lastIndex = clientId.lastIndexOf(separator);
        String id = null;
        if (lastIndex < 0) {
            id = clientId;
        } else if (lastIndex < clientId.length() - 1) {
            id = clientId.substring(lastIndex + 1);
        }
        return id;
    }

    private void addSubtreeClientId(String clientId) {
        FacesContext facesContext = this.getFacesContext();
        char separator = UINamingContainer.getSeparatorChar(facesContext);
        int length = clientId.length();
        for (int i = 0; i < length; ++i) {
            if (clientId.charAt(i) != separator) continue;
            String namingContainerClientId = clientId.substring(0, i);
            Collection<String> c = this.subtreeClientIds.get(namingContainerClientId);
            if (c == null) {
                c = new ArrayList<String>();
                this.subtreeClientIds.put(namingContainerClientId, c);
            }
            c.add(clientId);
        }
    }

    private void removeSubtreeClientId(String clientId) {
        for (String key : this.subtreeClientIds.keySet()) {
            if (!clientId.startsWith(key)) continue;
            Collection<String> ids = this.subtreeClientIds.get(key);
            ids.remove(clientId);
        }
    }

    private class IteratorProxy<E extends String>
    implements Iterator<E> {
        private Iterator<E> wrapped;
        private E current = null;

        private IteratorProxy(Iterator<E> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        @Override
        public E next() {
            this.current = (String)this.wrapped.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current != null) {
                PartialVisitContext.this.idRemoved(this.current);
            }
            this.wrapped.remove();
        }
    }

    private class CollectionProxy<E extends String>
    extends AbstractCollection<E> {
        private Collection<E> wrapped;

        private CollectionProxy(Collection<E> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }

        @Override
        public Iterator<E> iterator() {
            return new IteratorProxy(this.wrapped.iterator());
        }

        @Override
        public boolean add(E o) {
            boolean added = this.wrapped.add(o);
            if (added) {
                PartialVisitContext.this.idAdded(o);
            }
            return added;
        }
    }
}

