/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.configprovider;

import com.sun.faces.facelets.util.Classpath;
import com.sun.faces.spi.ConfigurationResourceProvider;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.faces.FacesException;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaInfFaceletTaglibraryConfigProvider
implements ConfigurationResourceProvider {
    private static final String SUFFIX = ".taglib.xml";
    private static final String WEB_INF_CLASSES = "/WEB-INF/classes/META-INF";
    private static final String[] FACELET_CONFIG_FILES = new String[]{"META-INF/jsf-core.taglib.xml", "META-INF/jsf-html.taglib.xml", "META-INF/jsf-ui.taglib.xml", "META-INF/jstl-core.taglib.xml", "META-INF/jstl-fn.taglib.xml"};
    private static final String[] BUILT_IN_TAGLIB_XML_FILES = new String[]{"META-INF/mojarra_ext.taglib.xml"};

    @Override
    public Collection<URI> getResources(ServletContext context) {
        try {
            URL[] externalTaglibUrls = Classpath.search(Util.getCurrentLoader(this), "META-INF/", SUFFIX);
            URL[] builtInTaglibUrls = new URL[BUILT_IN_TAGLIB_XML_FILES.length];
            ClassLoader runtimeClassLoader = this.getClass().getClassLoader();
            for (int i = 0; i < BUILT_IN_TAGLIB_XML_FILES.length; ++i) {
                builtInTaglibUrls[i] = runtimeClassLoader.getResource(BUILT_IN_TAGLIB_XML_FILES[i]);
            }
            URL[] urls = new URL[externalTaglibUrls.length + builtInTaglibUrls.length];
            System.arraycopy(externalTaglibUrls, 0, urls, 0, externalTaglibUrls.length);
            System.arraycopy(builtInTaglibUrls, 0, urls, externalTaglibUrls.length, builtInTaglibUrls.length);
            List<URI> urlsList = this.pruneURLs(urls);
            Set paths = context.getResourcePaths(WEB_INF_CLASSES);
            if (paths != null) {
                for (Object path : paths) {
                    String p = path.toString();
                    if (!p.endsWith(SUFFIX)) continue;
                    String urlString = context.getResource(p).toExternalForm();
                    urlString = urlString.replaceAll(" ", "%20");
                    try {
                        urlsList.add(new URI(urlString));
                    }
                    catch (URISyntaxException ex) {
                        throw new FacesException(ex);
                    }
                }
            }
            return urlsList;
        }
        catch (IOException ioe) {
            throw new FacesException("Error searching classpath from facelet-taglib documents", ioe);
        }
    }

    private List<URI> pruneURLs(URL[] urls) {
        List<URI> ret = null;
        if (urls != null && urls.length > 0) {
            for (URL url : urls) {
                String u = url.toString();
                boolean found = false;
                for (String excludeName : FACELET_CONFIG_FILES) {
                    if (!u.contains(excludeName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                if (ret == null) {
                    ret = new ArrayList<URI>();
                }
                try {
                    String urlString = url.toExternalForm();
                    urlString = urlString.replaceAll(" ", "%20");
                    ret.add(new URI(urlString));
                }
                catch (URISyntaxException ex) {
                    throw new FacesException(ex);
                }
            }
        }
        if (ret == null) {
            ret = Collections.emptyList();
        }
        return ret;
    }
}

