/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.view.ViewScopeManager;
import com.sun.faces.config.InitFacesContext;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.el.ELUtils;
import com.sun.faces.flow.FlowCDIContext;
import com.sun.faces.io.FastStringWriter;
import com.sun.faces.mgbean.BeanManager;
import com.sun.faces.renderkit.StateHelper;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.context.FacesContext;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebappLifecycleListener {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private ServletContext servletContext;
    private ApplicationAssociate applicationAssociate;
    private List<HttpSession> activeSessions;

    public WebappLifecycleListener() {
    }

    public WebappLifecycleListener(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDestroyed(ServletRequestEvent event) {
        try {
            HttpSession session;
            boolean distributable;
            ServletRequest request = event.getServletRequest();
            Enumeration e = request.getAttributeNames();
            while (e.hasMoreElements()) {
                String beanName = (String)e.nextElement();
                this.handleAttributeEvent(beanName, request.getAttribute(beanName), ELUtils.Scope.REQUEST);
            }
            WebConfiguration config = WebConfiguration.getInstance(event.getServletContext());
            if (config.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableAgressiveSessionDirtying)) {
                this.syncSessionScopedBeans(request);
            }
            if ((distributable = config.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableDistributable)) && (session = ((HttpServletRequest)request).getSession(false)) != null && session.getAttribute("com.sun.faces.application.view.activeViewMaps") != null) {
                session.setAttribute("com.sun.faces.application.view.activeViewMaps", session.getAttribute("com.sun.faces.application.view.activeViewMaps"));
            }
        }
        catch (Throwable t) {
            InitFacesContext context = new InitFacesContext(event.getServletContext());
            ExceptionQueuedEventContext eventContext = new ExceptionQueuedEventContext(context, t);
            ((FacesContext)context).getApplication().publishEvent(context, ExceptionQueuedEvent.class, eventContext);
            context.getExceptionHandler().handle();
        }
        finally {
            ApplicationAssociate.setCurrentInstance(null);
        }
    }

    public void requestInitialized(ServletRequestEvent event) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext instanceof InitFacesContext) {
            InitFacesContext initFacesContext = (InitFacesContext)facesContext;
            initFacesContext.releaseCurrentInstance();
            initFacesContext.removeServletContextEntryForInitContext();
        }
        ApplicationAssociate.setCurrentInstance(this.getAssociate());
    }

    public void sessionCreated(HttpSessionEvent event) {
        ApplicationAssociate associate = this.getAssociate();
        if (associate != null && associate.isDevModeEnabled()) {
            if (this.activeSessions == null) {
                this.activeSessions = new ArrayList<HttpSession>();
            }
            this.activeSessions.add(event.getSession());
        }
        boolean doCreateToken = true;
        if (null != associate) {
            Application application = associate.getApplication();
            ViewHandler viewHandler = application.getViewHandler();
            boolean bl = doCreateToken = !viewHandler.getProtectedViewsUnmodifiable().isEmpty();
        }
        if (doCreateToken) {
            StateHelper.createAndStoreCryptographicallyStrongTokenInSession(event.getSession());
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        ViewScopeManager manager;
        if (this.activeSessions != null) {
            this.activeSessions.remove(event.getSession());
        }
        if (Util.isCDIAvailable(this.servletContext)) {
            FlowCDIContext.sessionDestroyed(event);
        }
        if ((manager = (ViewScopeManager)this.servletContext.getAttribute("com.sun.faces.application.view.viewScopeManager")) != null) {
            manager.sessionDestroyed(event);
        }
    }

    public void attributeRemoved(ServletRequestAttributeEvent event) {
        this.handleAttributeEvent(event.getName(), event.getValue(), ELUtils.Scope.REQUEST);
    }

    public void attributeReplaced(ServletRequestAttributeEvent event) {
        String attrName = event.getName();
        Object newValue = event.getServletRequest().getAttribute(attrName);
        if (event.getValue() != newValue) {
            this.handleAttributeEvent(attrName, event.getValue(), ELUtils.Scope.REQUEST);
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        this.handleAttributeEvent(event.getName(), event.getValue(), ELUtils.Scope.SESSION);
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        HttpSession session = event.getSession();
        String attrName = event.getName();
        Object newValue = session.getAttribute(attrName);
        if (event.getValue() != newValue) {
            this.handleAttributeEvent(attrName, event.getValue(), ELUtils.Scope.SESSION);
        }
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
        this.handleAttributeEvent(event.getName(), event.getValue(), ELUtils.Scope.APPLICATION);
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
        ServletContext context = event.getServletContext();
        String attrName = event.getName();
        Object newValue = context.getAttribute(attrName);
        if (event.getValue() != newValue) {
            this.handleAttributeEvent(attrName, event.getValue(), ELUtils.Scope.APPLICATION);
        }
    }

    private void handleAttributeEvent(String beanName, Object bean, ELUtils.Scope scope) {
        block5: {
            ApplicationAssociate associate = this.getAssociate();
            try {
                BeanManager beanManager;
                if (associate != null && (beanManager = associate.getBeanManager()) != null && beanManager.isManaged(beanName)) {
                    beanManager.destroy(beanName, bean);
                }
            }
            catch (Exception e) {
                String className = e.getClass().getName();
                String message = e.getMessage();
                if (message == null) {
                    message = "";
                }
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "jsf.config.listener.predestroy.error", new Object[]{className, beanName, scope, message});
                }
                if (!LOGGER.isLoggable(Level.FINE)) break block5;
                FastStringWriter writer = new FastStringWriter(128);
                e.printStackTrace(new PrintWriter(writer));
                LOGGER.fine(writer.toString());
            }
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        if (this.servletContext == null) {
            this.servletContext = event.getServletContext();
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        Enumeration e = this.servletContext.getAttributeNames();
        while (e.hasMoreElements()) {
            String beanName = (String)e.nextElement();
            this.handleAttributeEvent(beanName, this.servletContext.getAttribute(beanName), ELUtils.Scope.APPLICATION);
        }
        this.applicationAssociate = null;
    }

    public List<HttpSession> getActiveSessions() {
        return new ArrayList<HttpSession>(this.activeSessions);
    }

    private ApplicationAssociate getAssociate() {
        if (this.applicationAssociate == null) {
            this.applicationAssociate = ApplicationAssociate.getInstance(this.servletContext);
        }
        return this.applicationAssociate;
    }

    private void syncSessionScopedBeans(ServletRequest request) {
        HttpSession session;
        if (request instanceof HttpServletRequest && (session = ((HttpServletRequest)request).getSession(false)) != null) {
            ApplicationAssociate associate = this.getAssociate();
            if (associate == null) {
                return;
            }
            BeanManager manager = associate.getBeanManager();
            if (manager != null) {
                Enumeration e = session.getAttributeNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    if (!manager.isManaged(name)) continue;
                    session.setAttribute(name, session.getAttribute(name));
                }
            }
        }
    }
}

